/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Random;
import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class BootstrappedMatrixByGenes {
    public Vector resampledIndices = new Vector();

    float[][] get2DArrFromExpMatrix(FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = floatMatrix.get(i, j);
            }
        }
        return fArray;
    }

    float[][] resampleMatrix(FloatMatrix floatMatrix) {
        float[][] fArray = this.get2DArrFromExpMatrix(floatMatrix);
        float[][] fArray2 = new float[fArray.length][fArray[0].length];
        int n = fArray.length;
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(n);
            for (int j = 0; j < fArray2[0].length; ++j) {
                fArray2[i][j] = fArray[n2][j];
            }
            this.resampledIndices.add(new Integer(n2));
        }
        fArray = fArray2;
        return fArray;
    }

    public FloatMatrix createResampExpMatrixObject(FloatMatrix floatMatrix) {
        float[][] fArray = this.resampleMatrix(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(fArray);
        return floatMatrix2;
    }

    void printMatrix(float[][] fArray) {
        int n = 0;
        for (int i = 0; i < fArray[0].length; ++i) {
            for (n = 0; n < fArray.length; ++n) {
                System.out.print((int)(fArray[n][i] * 100.0f) / 100 + " ");
            }
            System.out.println();
        }
    }
}

