/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.util.ParameterAttributes;

public class ScriptValueChangeDialog
extends AlgorithmDialog {
    private int result = 2;
    private ScriptManager manager;
    private String algName;
    private String origLine;
    private String line;
    private String key;
    private String origValue;
    private String valueType;
    private String leadingSpaces;
    private JLabel prefix;
    private String value;
    private JLabel suffix;
    private JComponent valueComponent;
    private Hashtable parameterHash;

    public ScriptValueChangeDialog(String string, String string2, ScriptManager scriptManager) {
        super(new JFrame(), "Value Editor", true);
        this.manager = scriptManager;
        this.algName = string2;
        this.origLine = string;
        this.leadingSpaces = new String();
        this.initializeValues();
        ParameterPanel parameterPanel = new ParameterPanel("Script Line");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        Component component = null;
        int n = 0;
        parameterPanel.add((Component)this.prefix, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, n, 0), 0, 0));
        parameterPanel.add((Component)this.valueComponent, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, n, 2), 0, 0));
        parameterPanel.add((Component)this.suffix, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, n, 0), 0, 0));
        if (component != null) {
            parameterPanel.add(component, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 5, 0), 0, 0));
        }
        JButton jButton = new JButton("View Valid Parameters");
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setFocusPainted(false);
        jButton.addActionListener(new ParameterListener());
        jButton.setPreferredSize(new Dimension(180, 30));
        jButton.setSize(180, 30);
        parameterPanel.add((Component)jButton, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 5, 0), 0, 0));
        this.parameterHash = scriptManager.getParameterHash(string2);
        ButtonPanel buttonPanel = new ButtonPanel();
        this.supplantButtonPanel(buttonPanel);
        this.addContent((Component)parameterPanel);
        this.pack();
    }

    private void initializeValues() {
        String string;
        int n = this.origLine.indexOf("value");
        if (n >= 0) {
            String string2 = this.origLine.substring(0, n);
            this.leadingSpaces = "";
            char[] cArray = string2.toCharArray();
            for (int i = 0; i < cArray.length && cArray[i] == ' '; ++i) {
                this.leadingSpaces = this.leadingSpaces + " ";
            }
            string2 = string2.trim();
            string = this.origLine.substring(n);
            n = string.indexOf("\"");
            this.value = string.substring(n + 1);
            string = new String(this.value);
            n = this.value.indexOf("\"");
            this.value = this.value.substring(0, n);
            this.value.trim();
            string = string.substring(n + 1);
            this.prefix = this.createJLabel(string2 + " value=\"");
            this.suffix = this.createJLabel("\"" + string);
            this.valueComponent = this.getValueComponent(this.value);
        } else {
            this.prefix = this.createJLabel(" ");
            this.suffix = this.createJLabel(" ");
            this.valueComponent = new JLabel("Incorrect construction");
        }
        n = this.origLine.indexOf("key");
        if (n >= 0) {
            string = this.origLine.substring(n);
            n = string.indexOf("\"");
            string = string.substring(n + 1);
            n = string.indexOf("\"");
            this.key = string.substring(0, n);
            this.key = this.key.trim();
        }
    }

    private JLabel createJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBackground(Color.white);
        return jLabel;
    }

    private JComponent getValueComponent(String string) {
        int n;
        String string2 = "unknown";
        if (string.equals("true") || string.equals("false")) {
            String[] stringArray = new String[]{"true", "false"};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            if (string.equals("true")) {
                jComboBox.setSelectedIndex(0);
            } else {
                jComboBox.setSelectedIndex(1);
            }
            this.valueType = string2 = "boolean";
            return jComboBox;
        }
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            if (!Character.isLetter(cArray[n]) || cArray[n] == '.') continue;
            string2 = "a character string";
            bl = true;
            break;
        }
        n = 0;
        if (!bl) {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '.') continue;
                ++n;
            }
            if (n == 1) {
                string2 = "a floating point number";
                bl = true;
            } else if (n > 1) {
                string2 = "a character string";
                bl = true;
            } else if (n == 0) {
                string2 = "an integer number";
                bl = true;
            }
        }
        JTextField jTextField = new JTextField(string, string.length() + 3);
        this.valueType = string2;
        return jTextField;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void onReset() {
    }

    public String getLine() {
        return this.line;
    }

    public String getValue() {
        if (this.valueComponent != null) {
            if (this.valueComponent instanceof JTextField) {
                return ((JTextField)this.valueComponent).getText();
            }
            if (this.valueComponent instanceof JComboBox) {
                return (String)((JComboBox)this.valueComponent).getSelectedItem();
            }
        }
        return null;
    }

    private boolean validateValue(String string) {
        String string2;
        String string3;
        ParameterAttributes parameterAttributes = this.manager.getParameterAttributes(this.algName, this.key);
        if (parameterAttributes == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter value, type, and constraints could not be verified.\nValue will be committed but please consider it's validity.", "Parameter Validataion Warning", 2);
            return true;
        }
        String string4 = parameterAttributes.getValueType();
        if (!this.checkType(string, string4)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter type seems incorrect ( requires: " + string4 + " )", "Parameter Validataion Error", 0);
            return false;
        }
        if (parameterAttributes.hasConstraints() && !this.checkConstraints(string, string4, string3 = parameterAttributes.getMin(), string2 = parameterAttributes.getMax())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter falls outside the constraints.", "Parameter Validataion Error", 0);
            return false;
        }
        return true;
    }

    private boolean checkConstraints(String string, String string2, String string3, String string4) {
        if (string2.equals("int")) {
            int n = Integer.parseInt(string);
            if (!string3.equals("") && !string4.equals("")) {
                return n >= Integer.parseInt(string3) && n <= Integer.parseInt(string4);
            }
            if (!string4.equals("")) {
                return n <= Integer.parseInt(string4);
            }
            if (!string3.equals("")) {
                return n >= Integer.parseInt(string3);
            }
            return true;
        }
        if (string2.equals("float")) {
            float f = Float.parseFloat(string);
            if (!string3.equals("") && !string4.equals("")) {
                return f >= Float.parseFloat(string3) && f <= Float.parseFloat(string4);
            }
            if (!string4.equals("")) {
                return f <= Float.parseFloat(string4);
            }
            if (!string3.equals("")) {
                return f >= Float.parseFloat(string3);
            }
            return true;
        }
        if (string2.equals("long")) {
            long l = Long.parseLong(string);
            if (!string3.equals("") && !string4.equals("")) {
                return l >= Long.parseLong(string3) && l <= Long.parseLong(string4);
            }
            if (!string4.equals("")) {
                return l <= Long.parseLong(string4);
            }
            if (!string3.equals("")) {
                return l >= Long.parseLong(string3);
            }
            return true;
        }
        if (string2.equals("double")) {
            double d = Double.parseDouble(string);
            if (!string3.equals("") && !string4.equals("")) {
                return d >= Double.parseDouble(string3) && d <= Double.parseDouble(string4);
            }
            if (!string4.equals("")) {
                return d <= Double.parseDouble(string4);
            }
            if (!string3.equals("")) {
                return d >= Double.parseDouble(string3);
            }
            return true;
        }
        return true;
    }

    private boolean checkType(String string, String string2) {
        try {
            if (string2.equals("int")) {
                Integer.parseInt(string);
            } else if (string2.equals("float")) {
                Float.parseFloat(string);
            } else if (string2.equals("long")) {
                Long.parseLong(string);
            } else if (string2.equals("double")) {
                Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private class ButtonPanel
    extends JPanel {
        private JButton refreshBut;
        private JButton resetBut;
        private JButton cancelBut;
        private JButton okBut;
        private JButton infoButton;

        public ButtonPanel() {
            super(new GridBagLayout());
            ButtonListener buttonListener = new ButtonListener();
            JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 10));
            this.resetBut = new JButton("Reset");
            this.resetBut.setBorder(BorderFactory.createBevelBorder(0));
            this.resetBut.setFocusPainted(false);
            this.resetBut.setActionCommand("reset-cmd");
            this.resetBut.addActionListener(buttonListener);
            jPanel.add(this.resetBut);
            this.cancelBut = new JButton("Cancel");
            this.cancelBut.setBorder(BorderFactory.createBevelBorder(0));
            this.cancelBut.setSize(60, 30);
            this.cancelBut.setPreferredSize(new Dimension(60, 30));
            this.cancelBut.setFocusPainted(false);
            this.cancelBut.setActionCommand("cancel-cmd");
            this.cancelBut.addActionListener(buttonListener);
            jPanel.add(this.cancelBut);
            this.okBut = new JButton("Commit");
            this.okBut.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
            this.okBut.setSize(60, 30);
            this.okBut.setPreferredSize(new Dimension(60, 30));
            this.okBut.setFocusPainted(false);
            this.okBut.setActionCommand("commit-cmd");
            this.okBut.addActionListener(buttonListener);
            jPanel.add(this.okBut);
            this.infoButton = new JButton(null, GUIFactory.getIcon((String)"Information24.gif"));
            this.infoButton.setActionCommand("info-cmd");
            this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
            this.infoButton.setSize(30, 30);
            this.infoButton.setPreferredSize(new Dimension(30, 30));
            this.infoButton.setFocusPainted(false);
            this.infoButton.addActionListener(buttonListener);
            this.add((Component)this.infoButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public class ButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (!string.equals("apply-cmd")) {
                    HelpWindow helpWindow;
                    if (string.equals("cancel-cmd")) {
                        ScriptValueChangeDialog.this.dispose();
                    } else if (string.equals("commit-cmd")) {
                        ScriptValueChangeDialog.this.result = 0;
                        if (ScriptValueChangeDialog.this.valueType != null && ScriptValueChangeDialog.this.valueType.equals("boolean")) {
                            ScriptValueChangeDialog.this.value = (String)((JComboBox)ScriptValueChangeDialog.this.valueComponent).getSelectedItem();
                            ScriptValueChangeDialog.this.line = ScriptValueChangeDialog.this.leadingSpaces + ScriptValueChangeDialog.this.prefix.getText() + ScriptValueChangeDialog.this.value + ScriptValueChangeDialog.this.suffix.getText();
                            ScriptValueChangeDialog.this.dispose();
                        } else {
                            ScriptValueChangeDialog.this.value = ((JTextField)ScriptValueChangeDialog.this.valueComponent).getText();
                            if (ScriptValueChangeDialog.this.validateValue(ScriptValueChangeDialog.this.value)) {
                                ScriptValueChangeDialog.this.line = ScriptValueChangeDialog.this.leadingSpaces + ScriptValueChangeDialog.this.prefix.getText() + ScriptValueChangeDialog.this.value + ScriptValueChangeDialog.this.suffix.getText();
                                ScriptValueChangeDialog.this.dispose();
                            }
                        }
                    } else if (!string.equals("reset-cmd") && string.equals("info-cmd") && (helpWindow = new HelpWindow((JDialog)((Object)ScriptValueChangeDialog.this), "Script Value Input Dialog")).getWindowContent()) {
                        helpWindow.setSize(450, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                    }
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                ScriptValueChangeDialog.this.result = -1;
                ScriptValueChangeDialog.this.dispose();
            }
        }
    }

    private class ParameterListener
    implements ActionListener {
        private ParameterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (ScriptValueChangeDialog.this.manager != null && ScriptValueChangeDialog.this.algName != null && (string = ScriptValueChangeDialog.this.manager.getValidParametersTable(ScriptValueChangeDialog.this.algName)) != null && string.length() > 0) {
                JFrame jFrame = new JFrame("Valid Parameters for " + ScriptValueChangeDialog.this.algName);
                JDialog jDialog = new JDialog((Dialog)((Object)ScriptValueChangeDialog.this), "Valid Parameters for " + ScriptValueChangeDialog.this.algName);
                JTextPane jTextPane = new JTextPane();
                jTextPane.setContentType("text/html");
                jTextPane.setText(string);
                jTextPane.setEditable(false);
                jTextPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
                jTextPane.setMargin(new Insets(5, 10, 5, 10));
                JScrollPane jScrollPane = new JScrollPane(jTextPane);
                jDialog.getContentPane().add(jScrollPane);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                jDialog.setSize(dimension.width / 3, (int)((double)dimension.height / 1.5));
                jDialog.setLocation((dimension.width - jDialog.getSize().width) / 2, (dimension.height - jDialog.getSize().height) / 2);
                jDialog.setVisible(true);
            }
        }
    }
}

