/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.event.ScriptDocumentEvent;
import org.tigr.microarray.mev.script.event.ScriptEventListener;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptNode;
import org.tigr.microarray.mev.script.util.ScriptTree;

public class ScriptTreeViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 1000102010301040001L;
    ScriptTree scriptTree;
    JPopupMenu dataPopup;
    JPopupMenu algPopup;
    JPopupMenu defaultMenu;
    ScriptTreeListener listener;
    ScriptManager manager;
    private boolean isAlgSetViewer = false;
    private DataNode algSetRoot;
    boolean selected = false;

    public ScriptTreeViewer(ScriptTree scriptTree, ScriptManager scriptManager) {
        this.scriptTree = scriptTree;
        this.manager = scriptManager;
        this.listener = new ScriptTreeListener();
        this.scriptTree.addMouseListener(this.listener);
        this.scriptTree.getDocument().addDocumentListener(new ScriptListener());
        this.dataPopup = this.createPopupMenu(this.listener, "data");
        this.algPopup = this.createPopupMenu(this.listener, "alg");
        this.defaultMenu = this.createPopupMenu(this.listener, "default");
        this.isAlgSetViewer = false;
    }

    public ScriptTreeViewer(ScriptTree scriptTree, ScriptManager scriptManager, DataNode dataNode) {
        this.scriptTree = scriptTree;
        this.manager = scriptManager;
        this.algSetRoot = this.findLocalAlgSetRoot(dataNode.toString());
        if (this.algSetRoot != null) {
            this.scriptTree.highlightAlgSet(this.algSetRoot);
            this.isAlgSetViewer = true;
        } else {
            this.isAlgSetViewer = false;
        }
    }

    private DataNode findLocalAlgSetRoot(String string) {
        AlgorithmSet[] algorithmSetArray = this.scriptTree.getAlgorithmSets();
        DataNode dataNode = null;
        for (int i = 0; i < algorithmSetArray.length; ++i) {
            if (!algorithmSetArray[i].getDataNode().toString().equals(string)) continue;
            dataNode = algorithmSetArray[i].getDataNode();
            break;
        }
        return dataNode;
    }

    public void onSelected(IFramework iFramework) {
        this.selected = true;
        if (this.isAlgSetViewer) {
            this.scriptTree.highlightAlgSet(this.algSetRoot);
        } else {
            this.scriptTree.clearHighlights();
        }
        this.scriptTree.validate();
    }

    public void onClosed() {
        this.selected = false;
    }

    public JComponent getContentComponent() {
        return this.scriptTree;
    }

    public JPopupMenu createPopupMenu(ScriptTreeListener scriptTreeListener, String string) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (string.equals("alg")) {
            jMenuItem = new JMenuItem("Change Algorithm");
            jMenuItem.setActionCommand("replace-algorithm-cmd");
            jMenuItem.addActionListener(scriptTreeListener);
            jMenuItem = new JMenuItem("Delete Algorithm");
            jMenuItem.setActionCommand("delete-algorithm-cmd");
            jMenuItem.addActionListener(scriptTreeListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Modify Paramaters");
            jMenuItem.setActionCommand("modify-algorithm-cmd");
            jMenuItem.addActionListener(scriptTreeListener);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("View XML Section");
            jMenuItem.setActionCommand("view-xml-cmd");
            jMenuItem.addActionListener(scriptTreeListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        } else {
            jMenuItem = new JMenuItem("Add Algorithm Node");
            jMenuItem.setActionCommand("add-new-algorithm-cmd");
            jMenuItem.addActionListener(scriptTreeListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        jMenuItem = new JMenuItem("Execute Script");
        jMenuItem.setActionCommand("execute-script-cmd");
        jMenuItem.addActionListener(scriptTreeListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save Script");
        jMenuItem.setActionCommand("save-script-cmd");
        jMenuItem.addActionListener(scriptTreeListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.manager);
        objectOutputStream.writeObject(this.scriptTree.getDocument());
        objectOutputStream.writeBoolean(this.isAlgSetViewer);
        if (this.isAlgSetViewer) {
            objectOutputStream.writeObject(this.algSetRoot);
        }
        objectOutputStream.writeBoolean(this.selected);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.manager = (ScriptManager)objectInputStream.readObject();
        this.scriptTree = new ScriptTree((ScriptDocument)objectInputStream.readObject(), this.manager);
        this.isAlgSetViewer = objectInputStream.readBoolean();
        if (this.isAlgSetViewer) {
            this.algSetRoot = (DataNode)objectInputStream.readObject();
            this.algSetRoot = this.scriptTree.getDataNodeNamed(this.algSetRoot.toString());
            if (this.algSetRoot != null) {
                this.scriptTree.highlightAlgSet(this.algSetRoot);
            }
        }
        this.selected = objectInputStream.readBoolean();
    }

    public class ScriptListener
    implements ScriptEventListener {
        public void documentChanged(ScriptDocumentEvent scriptDocumentEvent) {
            ScriptTreeViewer.this.scriptTree.updateTree();
        }
    }

    public class ScriptTreeListener
    extends MouseAdapter
    implements ActionListener {
        ScriptNode node;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    ScriptTreeViewer.this.defaultMenu.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                } else if (this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.algPopup.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    ScriptNode scriptNode = (ScriptNode)this.node.getParent();
                    if (scriptNode != null) {
                        if (((AlgorithmNode)scriptNode).getAlgorithmType().equals("data-visualization")) {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(false);
                        } else {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(true);
                        }
                    }
                    ScriptTreeViewer.this.dataPopup.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    return;
                }
                if (this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.algPopup.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    ScriptNode scriptNode = (ScriptNode)this.node.getParent();
                    if (scriptNode != null) {
                        if (((AlgorithmNode)scriptNode).getAlgorithmType().equals("data-visualization")) {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(false);
                        } else {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(true);
                        }
                    }
                    ScriptTreeViewer.this.dataPopup.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    return;
                }
                if (this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.algPopup.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    ScriptNode scriptNode = (ScriptNode)this.node.getParent();
                    if (scriptNode != null) {
                        if (((AlgorithmNode)scriptNode).getAlgorithmType().equals("data-visualization")) {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(false);
                        } else {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(true);
                        }
                    }
                    ScriptTreeViewer.this.dataPopup.show(ScriptTreeViewer.this.scriptTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            String string = actionEvent.getActionCommand();
            if (string.equals("add-new-algorithm-cmd") || string.equals("replace-algorithm-cmd")) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    return;
                }
                if (this.node instanceof DataNode) {
                    ScriptTreeViewer.this.scriptTree.addNewAlgorithmToDataNode((DataNode)this.node);
                }
            } else if (string.equals("delete-algorithm-cmd")) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node != null && this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.scriptTree.removeAlgorithm((AlgorithmNode)this.node);
                }
            } else if (!string.equals("modify-algorithm-cmd")) {
                if (string.equals("view-xml-cmd")) {
                    this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                    if (this.node != null) {
                        ScriptTreeViewer.this.manager.viewSelectedNodeXML(ScriptTreeViewer.this, this.node);
                    }
                } else if (string.equals("save-script-cmd")) {
                    ScriptTreeViewer.this.manager.saveScript(ScriptTreeViewer.this.scriptTree.getDocument());
                } else if (string.equals("execute-script-cmd")) {
                    ScriptTreeViewer.this.manager.runScript(ScriptTreeViewer.this.scriptTree.getDocument());
                }
            }
        }
    }
}

