/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.script.Script;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;

public class ScriptTable
extends ViewerAdapter {
    public static final long serialVersionUID = 1000102010301030001L;
    private JTable table;
    private Vector data;
    private ScriptDataModel dataModel;
    private ScriptManager manager;
    private JPopupMenu menu;

    public ScriptTable(ScriptManager scriptManager, Vector vector) {
        this.manager = scriptManager;
        this.dataModel = new ScriptDataModel(vector, this.constructHeaderNames());
        this.table = new JTable(this.dataModel);
        this.table.setBackground(Color.white);
        TableListener tableListener = new TableListener();
        this.menu = this.createPopupMenu(tableListener);
        this.table.addMouseListener(tableListener);
        this.table.setVisible(true);
    }

    private Vector constructHeaderNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Row");
        vector.add("Script ID");
        vector.add("File Name");
        vector.add("Script Name");
        vector.add("Script Description");
        return vector;
    }

    private JPopupMenu createPopupMenu(TableListener tableListener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Exectute Script");
        jMenuItem.setActionCommand("run-script-cmd");
        jMenuItem.addActionListener(tableListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void addScriptDoc(ScriptDocument scriptDocument) {
        this.data.add(scriptDocument);
    }

    public void update() {
    }

    public JComponent getContentComponent() {
        return this.table;
    }

    public JComponent getHeaderComponent() {
        return this.table.getTableHeader();
    }

    public class TableListener
    extends MouseAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = actionEvent.getActionCommand();
            if (string.equals("run-script-cmd") && (n = ScriptTable.this.table.getSelectedRow()) > -1) {
                ScriptTable.this.manager.runScript(n);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ScriptTable.this.menu.show(ScriptTable.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ScriptTable.this.menu.show(ScriptTable.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class ScriptDataModel
    extends AbstractTableModel
    implements Serializable {
        Vector data;
        ScriptDocument currentDoc;
        Vector headerNames;

        public ScriptDataModel(Vector vector, Vector vector2) {
            this.data = vector;
            this.headerNames = vector2;
        }

        public Object getValueAt(int n, int n2) {
            this.currentDoc = ((Script)this.data.elementAt(n)).getScriptDocument();
            String string = new String(" ");
            switch (n2) {
                case 0: {
                    string = String.valueOf(n + 1);
                    break;
                }
                case 1: {
                    string = new String("Script(" + this.currentDoc.getDocumentID() + ")");
                    break;
                }
                case 2: {
                    String string2 = this.currentDoc.getDocumentFileName();
                    if (string2 == null) {
                        string = new String("New Script");
                        break;
                    }
                    string = string2;
                    break;
                }
                case 3: {
                    string = this.currentDoc.getDocumentName();
                    break;
                }
                case 4: {
                    string = this.currentDoc.getDescription();
                }
            }
            return string;
        }

        public String getColumnName(int n) {
            return (String)this.headerNames.elementAt(n);
        }

        public int getColumnCount() {
            return this.headerNames.size();
        }

        public int getRowCount() {
            return this.data.size();
        }
    }
}

