/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;

public class FileTreePane
extends JPanel {
    public static final ImageIcon ICON_COMPUTER = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$microarray$mev$file$FileTreePane == null ? (class$org$tigr$microarray$mev$file$FileTreePane = FileTreePane.class$("org.tigr.microarray.mev.file.FileTreePane")) : class$org$tigr$microarray$mev$file$FileTreePane).getClassLoader().getResource("org/tigr/images/PCIcon.gif")));
    public static final ImageIcon ICON_DISK = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$microarray$mev$file$FileTreePane == null ? (class$org$tigr$microarray$mev$file$FileTreePane = FileTreePane.class$("org.tigr.microarray.mev.file.FileTreePane")) : class$org$tigr$microarray$mev$file$FileTreePane).getClassLoader().getResource("org/tigr/images/disk.gif")));
    public static final ImageIcon ICON_FOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$microarray$mev$file$FileTreePane == null ? (class$org$tigr$microarray$mev$file$FileTreePane = FileTreePane.class$("org.tigr.microarray.mev.file.FileTreePane")) : class$org$tigr$microarray$mev$file$FileTreePane).getClassLoader().getResource("org/tigr/images/Directory.gif")));
    public static final ImageIcon ICON_EXPANDEDFOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$microarray$mev$file$FileTreePane == null ? (class$org$tigr$microarray$mev$file$FileTreePane = FileTreePane.class$("org.tigr.microarray.mev.file.FileTreePane")) : class$org$tigr$microarray$mev$file$FileTreePane).getClassLoader().getResource("org/tigr/images/expandedfolder.gif")));
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String MAC = "mac";
    private String os = System.getProperty("os.name");
    public char DIRECTORY_DIV;
    public String DIRECTORY_DIV_S;
    protected JTree m_tree;
    protected DefaultTreeModel m_model;
    protected JList fileList;
    private Vector rightListContent;
    private Vector leftListContent;
    protected String fPath;
    protected String selectedSingleFile;
    protected Vector selectedFilesVec;
    protected int selectedCount;
    protected Vector listeners = new Vector();
    protected String dataPath;
    protected DefaultMutableTreeNode top;
    public static final int NODE_COLLAPSED = 0;
    public static final int NODE_EXPANDED = 1;
    public static final int NODE_SELECTED = 2;
    static /* synthetic */ Class class$org$tigr$microarray$mev$file$FileTreePane;

    public FileTreePane() {
        String string = System.getProperty("file.separator");
        this.DIRECTORY_DIV = string.toCharArray()[0];
        this.DIRECTORY_DIV_S = string;
        JPanel jPanel = new JPanel();
        this.top = new DefaultMutableTreeNode(new IconData(ICON_COMPUTER, null, "Computer"));
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new IconData(ICON_DISK, null, new FileNode(fileArray[i])));
            this.top.add(defaultMutableTreeNode);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        this.m_model = new DefaultTreeModel(this.top);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer iconCellRenderer = new IconCellRenderer();
        this.m_tree.setCellRenderer(iconCellRenderer);
        this.m_tree.addTreeExpansionListener(new EventHandler());
        this.m_tree.addTreeSelectionListener(new EventHandler());
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_tree);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public FileTreePane(String string) {
        this.dataPath = string;
        String string2 = System.getProperty("file.separator");
        this.DIRECTORY_DIV = string2.toCharArray()[0];
        this.DIRECTORY_DIV_S = string2;
        JPanel jPanel = new JPanel();
        this.top = new DefaultMutableTreeNode(new IconData(ICON_COMPUTER, null, "Computer"));
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new IconData(ICON_DISK, null, new FileNode(fileArray[i])));
            this.top.add(defaultMutableTreeNode);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        this.m_model = new DefaultTreeModel(this.top);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer iconCellRenderer = new IconCellRenderer();
        this.m_tree.setCellRenderer(iconCellRenderer);
        this.m_tree.addTreeExpansionListener(new EventHandler());
        this.m_tree.addTreeSelectionListener(new EventHandler());
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_tree);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public String getSelection() {
        return this.fPath;
    }

    public void openDataPath() {
        if (this.dataPath == null) {
            return;
        }
        File file = new File(this.dataPath);
        if (file.exists() && file.isDirectory()) {
            this.openPath(this.top, this.dataPath, System.getProperty("file.separator"));
        }
    }

    private boolean openPath(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        int n;
        this.fPath = string;
        TreePath treePath = new TreePath(defaultMutableTreeNode);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        String string3 = stringTokenizer.nextToken() + string2;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n2 = defaultMutableTreeNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        FileNode fileNode = null;
        int n3 = 0;
        if (!string2.equals("/")) {
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                fileNode = this.getFileNode(defaultMutableTreeNode3);
                if (!string3.equalsIgnoreCase(fileNode.toString())) continue;
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                n4 = n;
                n3 = n;
                break;
            }
        } else {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            stringTokenizer = new StringTokenizer(string, string2);
        }
        if (defaultMutableTreeNode2 == null) {
            return false;
        }
        treePath = treePath.pathByAddingChild(defaultMutableTreeNode2);
        this.m_tree.expandPath(treePath);
        this.m_tree.validate();
        n = 0;
        block1: while (n == 0 && stringTokenizer.hasMoreTokens()) {
            n2 = defaultMutableTreeNode2.getChildCount();
            String string4 = stringTokenizer.nextToken();
            for (int i = 0; i < n2; ++i) {
                defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                fileNode = this.getFileNode(defaultMutableTreeNode3);
                if (fileNode == null) {
                    n = 1;
                    continue block1;
                }
                if (!string4.equalsIgnoreCase(fileNode.toString())) continue;
                this.buildOffNode(fileNode, defaultMutableTreeNode2);
                treePath = treePath.pathByAddingChild(defaultMutableTreeNode3);
                this.fPath = this.fPath + defaultMutableTreeNode3.toString() + string2;
                this.m_tree.expandPath(treePath);
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                this.repaint();
                continue block1;
            }
        }
        this.m_tree.makeVisible(treePath);
        this.m_tree.scrollPathToVisible(treePath);
        this.m_tree.setSelectionPath(treePath);
        this.m_tree.validate();
        return true;
    }

    private void buildOffNode(FileNode fileNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        Object object2;
        int n;
        File[] fileArray = new File(fileNode.toString()).listFiles();
        if (fileArray == null) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < fileArray.length; ++n) {
            object2 = fileArray[n];
            if (!((File)object2).isDirectory()) continue;
            object = new FileNode((File)object2);
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                FileNode fileNode2 = (FileNode)vector.elementAt(i);
                if (((FileNode)object).compareTo(fileNode2) >= 0) continue;
                vector.insertElementAt(object, i);
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(object);
        }
        for (n = 0; n < vector.size(); ++n) {
            object2 = (FileNode)vector.elementAt(n);
            object = new IconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, object2);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (!((FileNode)object2).hasSubDirs()) continue;
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
    }

    private DefaultMutableTreeNode getTreeNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    private FileNode getFileNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof IconData) {
            object = ((IconData)object).getObject();
        }
        if (object instanceof FileNode) {
            return (FileNode)object;
        }
        return null;
    }

    public Vector getFileNameList(String string) {
        if (string == null) {
            return null;
        }
        FileBrowser fileBrowser = new FileBrowser(this.fPath);
        Vector vector = fileBrowser.getFileNamesVec();
        return vector;
    }

    public void addFileTreePaneListener(FileTreePaneListener fileTreePaneListener) {
        this.listeners.addElement(fileTreePaneListener);
    }

    public void removeFileTreePaneListener(FileTreePaneListener fileTreePaneListener) {
        this.listeners.removeElement(fileTreePaneListener);
    }

    public void fireEvent(FileTreePaneEvent fileTreePaneEvent, int n) {
        Vector vector = (Vector)this.listeners.clone();
        block5: for (int i = 0; i < vector.size(); ++i) {
            FileTreePaneListener fileTreePaneListener = (FileTreePaneListener)vector.elementAt(i);
            switch (n) {
                case 0: {
                    fileTreePaneListener.nodeCollapsed(fileTreePaneEvent);
                    continue block5;
                }
                case 1: {
                    fileTreePaneListener.nodeExpanded(fileTreePaneEvent);
                    continue block5;
                }
                case 2: {
                    fileTreePaneListener.nodeSelected(fileTreePaneEvent);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        FileTreePane fileTreePane = new FileTreePane("C:\\MyProjects\\MeV_2_3_Devel\\Data");
        JFrame jFrame = new JFrame("FileTreePane");
        jFrame.getContentPane().add(fileTreePane);
        jFrame.setSize(600, 600);
        jFrame.setLocation(150, 150);
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FileBrowser {
        private String workingFullDir;
        private String workingDir;
        private Vector filesVec;
        private File dir;
        private File subDir;

        public FileBrowser(String string) {
            this.setDirectory(string);
        }

        public void setDirectory(String string) {
            this.workingFullDir = string;
            this.dir = new File(string);
            this.workingDir = this.dir.getAbsolutePath();
            if (!this.dir.isDirectory()) {
                this.workingDir = this.workingDir.substring(0, this.workingDir.lastIndexOf(FileTreePane.this.DIRECTORY_DIV));
            } else {
                this.filterFiles();
            }
        }

        public void filterFiles() {
            this.filesVec = new Vector();
            if (this.dir == null) {
                return;
            }
            String[] stringArray = this.dir.list();
            if (this.workingDir == null) {
                this.workingDir = this.dir.getAbsolutePath();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(this.dir, stringArray[i]);
                if (!file.isFile()) continue;
                this.filesVec.addElement(this.workingDir + (this.workingDir.endsWith(FileTreePane.this.DIRECTORY_DIV_S) ? "" : FileTreePane.this.DIRECTORY_DIV_S) + stringArray[i]);
            }
        }

        public Vector getFileNamesVec() {
            return this.filesVec;
        }

        public int getFileCounts() {
            return this.filesVec.size();
        }

        public String getAbsolutePath() {
            return this.workingDir;
        }

        public String creatSubDir(String string) {
            this.subDir = new File(this.workingFullDir + FileTreePane.this.DIRECTORY_DIV + string + FileTreePane.this.DIRECTORY_DIV);
            return this.workingFullDir + FileTreePane.this.DIRECTORY_DIV + string + FileTreePane.this.DIRECTORY_DIV;
        }

        public String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }

    private class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        protected boolean m_selected;

        public IconCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            this.setText(object2.toString());
            if (object2 instanceof Boolean) {
                this.setText("Retrieving data...");
            }
            if (object2 instanceof IconData) {
                IconData iconData = (IconData)object2;
                if (bl2) {
                    this.setIcon(iconData.getExpandedIcon());
                } else {
                    this.setIcon(iconData.getIcon());
                }
            } else {
                this.setIcon(null);
            }
            this.setFont(jTree.getFont());
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_selected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    private class IconData {
        protected Icon m_icon;
        protected Icon m_expandedIcon;
        protected Object m_data;

        public IconData(Icon icon, Object object) {
            this.m_icon = icon;
            this.m_expandedIcon = null;
            this.m_data = object;
        }

        public IconData(Icon icon, Icon icon2, Object object) {
            this.m_icon = icon;
            this.m_expandedIcon = icon2;
            this.m_data = object;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public Icon getExpandedIcon() {
            return this.m_expandedIcon != null ? this.m_expandedIcon : this.m_icon;
        }

        public Object getObject() {
            return this.m_data;
        }

        public String toString() {
            return this.m_data.toString();
        }
    }

    private class EventHandler
    implements ListSelectionListener,
    TreeExpansionListener,
    TreeSelectionListener {
        private EventHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileTreePane.this.selectedFilesVec = new Vector();
            FileTreePane.this.selectedCount = FileTreePane.this.fileList.getSelectedValues().length;
            for (int i = 0; i <= FileTreePane.this.selectedCount - 1; ++i) {
                FileTreePane.this.selectedFilesVec.add(i, (String)FileTreePane.this.fileList.getSelectedValues()[i]);
            }
            FileTreePane.this.selectedSingleFile = (String)FileTreePane.this.fileList.getSelectedValue();
            FileTreePane.this.fPath = (String)FileTreePane.this.fileList.getSelectedValue();
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = FileTreePane.this.getTreeNode(treeExpansionEvent.getPath());
            FileNode fileNode = FileTreePane.this.getFileNode(defaultMutableTreeNode);
            if (fileNode != null && fileNode.expand(defaultMutableTreeNode)) {
                FileTreePane.this.m_model.reload(defaultMutableTreeNode);
            }
            FileTreePane.this.fireEvent(new FileTreePaneEvent(treeExpansionEvent, null), 1);
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            FileTreePane.this.fireEvent(new FileTreePaneEvent(treeExpansionEvent, null), 0);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = FileTreePane.this.getTreeNode(treeSelectionEvent.getPath());
            FileNode fileNode = FileTreePane.this.getFileNode(defaultMutableTreeNode);
            if (fileNode != null) {
                FileTreePane.this.fPath = fileNode.getFile().getAbsolutePath();
                if (FileTreePane.this.fPath.charAt(FileTreePane.this.fPath.length() - 1) != FileTreePane.this.DIRECTORY_DIV) {
                    FileTreePane.this.fPath = FileTreePane.this.fPath + FileTreePane.this.DIRECTORY_DIV;
                }
                Vector vector = FileTreePane.this.getFileNameList(FileTreePane.this.fPath);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("Path", FileTreePane.this.fPath);
                if (vector != null) {
                    hashtable.put("Filenames", vector);
                }
                FileTreePane.this.fireEvent(new FileTreePaneEvent(treeSelectionEvent, hashtable), 2);
            } else {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("Path", "");
                FileTreePane.this.fireEvent(new FileTreePaneEvent(treeSelectionEvent, null), 2);
            }
        }
    }

    private class FileNode {
        protected File m_file;

        public FileNode(File file) {
            this.m_file = file;
        }

        public File getFile() {
            return this.m_file;
        }

        public String toString() {
            return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
        }

        public boolean expand(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object;
            Object object2;
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            if (defaultMutableTreeNode2 == null) {
                return false;
            }
            Object object3 = defaultMutableTreeNode2.getUserObject();
            if (!(object3 instanceof Boolean)) {
                return false;
            }
            defaultMutableTreeNode.removeAllChildren();
            File[] fileArray = this.listFiles();
            if (fileArray == null) {
                return true;
            }
            Vector<Object> vector = new Vector<Object>();
            for (n = 0; n < fileArray.length; ++n) {
                object2 = fileArray[n];
                if (!((File)object2).isDirectory()) continue;
                object = new FileNode((File)object2);
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    FileNode fileNode = (FileNode)vector.elementAt(i);
                    if (((FileNode)object).compareTo(fileNode) >= 0) continue;
                    vector.insertElementAt(object, i);
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector.addElement(object);
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = (FileNode)vector.elementAt(n);
                object = new IconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, object2);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                if (!((FileNode)object2).hasSubDirs()) continue;
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new Boolean(true)));
            }
            return true;
        }

        public boolean hasSubDirs() {
            File[] fileArray = this.listFiles();
            if (fileArray == null) {
                return false;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                return true;
            }
            return false;
        }

        public int compareTo(FileNode fileNode) {
            return this.m_file.getName().compareToIgnoreCase(fileNode.m_file.getName());
        }

        protected File[] listFiles() {
            if (!this.m_file.isDirectory()) {
                return null;
            }
            try {
                return this.m_file.listFiles();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error reading directory " + this.m_file.getAbsolutePath(), "Warning", 2);
                return null;
            }
        }
    }
}

