/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.xerces.parsers.DOMParser;
import org.tigr.microarray.mev.TMEV;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryConfigParser
extends DefaultHandler {
    Document document;
    private Element root;
    private Hashtable repositoryHash;

    public boolean parseSubmissionConfigFile() {
        try {
            File file = TMEV.getConfigurationFile("archive_submission_config.xml");
            if (file == null || !file.exists()) {
                JOptionPane.showMessageDialog(new JFrame(), "Error during submission configuration.  The file archive_submission_config.xml which contains\ncluter repository information was missing or not in MeV's config folder.\n", "Cluster Submission Error", 0);
                return false;
            }
            URL uRL = file.toURL();
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            dOMParser.setErrorHandler((ErrorHandler)this);
            dOMParser.parse(uRL.toString());
            this.document = dOMParser.getDocument();
            this.root = this.document.getDocumentElement();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Error parsing archive_submission_config.xml which contains repository information.", "Cluster Submission Error", 0);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Error parsing archive_submission_config.xml which contains repository information.", "Cluster Submission Error", 0);
            return false;
        }
        this.initializeRepositoryHash();
        return true;
    }

    public Element getRoot() {
        return this.root;
    }

    public String[] getRepositoryNames() {
        if (this.repositoryHash == null) {
            return null;
        }
        Set set = this.repositoryHash.keySet();
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public String getRepositoryDescription(String string) {
        if (this.repositoryHash == null) {
            return null;
        }
        Element element = this.getRepositoryXMLElement(string);
        NodeList nodeList = element.getElementsByTagName("description");
        return nodeList.item(0).getChildNodes().item(0).getNodeValue();
    }

    public Element getRepositoryXMLElement(String string) {
        if (this.repositoryHash == null) {
            return null;
        }
        return (Element)this.repositoryHash.get(string);
    }

    private void initializeRepositoryHash() {
        this.repositoryHash = new Hashtable();
        NodeList nodeList = this.root.getElementsByTagName("submit_entry");
        String[] stringArray = new String[nodeList.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            this.repositoryHash.put(((Element)nodeList.item(i)).getAttribute("name"), (Element)nodeList.item(i));
        }
    }

    public String getRepositorySpecifications(String string) {
        String string2 = new String();
        string2 = string2 + "<table cellpadding=5><tr><th colspan=2 align=left>Additional Submission Details</th></tr>";
        Element element = this.getRepositoryXMLElement(string);
        element = (Element)element.getElementsByTagName("submission").item(0);
        element = (Element)element.getElementsByTagName("specification_table").item(0);
        NodeList nodeList = element.getElementsByTagName("spec");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string3 = ((Element)nodeList.item(i)).getAttribute("key");
            String string4 = ((Element)nodeList.item(i)).getAttribute("value");
            string2 = string2 + "<tr><td><b>" + string3 + ":</b></td><td>" + string4 + "</td></tr>";
        }
        string2 = string2 + "</table>";
        return string2;
    }

    public String getRepositoryPage(String string) {
        String string2 = new String();
        string2 = string2 + "<html><body><h2>" + string + "</h2><hr size=3>" + "<b>Repository Name:&nbsp&nbsp</b>" + string + "<br><br>" + "<b>Repository Web Site:&nbsp&nbsp</b>" + this.getRepositoryURL(string) + "<br><br>" + "<b>Description:&nbsp&nbsp</b>" + this.getRepositoryDescription(string) + "<br><br>";
        string2 = string2 + this.getRepositorySpecifications(string);
        string2 = string2 + "</body></html>";
        return string2;
    }

    public Hashtable getUserInfo(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Element element = this.getRepositoryXMLElement(string);
        NodeList nodeList = element.getElementsByTagName("user");
        element = (Element)nodeList.item(0);
        String string2 = element.getAttribute("user_name");
        hashtable.put("user_name", string2);
        string2 = element.getAttribute("password");
        hashtable.put("password", string2);
        string2 = element.getAttribute("email");
        hashtable.put("email", string2);
        return hashtable;
    }

    public String getRepositorySubmissionClass(String string) {
        Element element = this.getRepositoryXMLElement(string);
        NodeList nodeList = element.getElementsByTagName("impl");
        return ((Element)nodeList.item(0)).getAttribute("impl_class");
    }

    public String getRepositoryURL(String string) {
        Element element = this.getRepositoryXMLElement(string);
        if (element != null) {
            return element.getAttribute("url");
        }
        return null;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Warning:  " + sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Error:  " + sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Fatal Error:  " + sAXParseException);
    }
}

