/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Frame;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.SearchResultDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ListImportDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.SubmissionManager;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class ClusterRepository
extends Vector
implements Serializable {
    public static final long serialVersionUID = 1000102010203030001L;
    public static final int GENE_CLUSTER = 0;
    public static final int EXPERIMENT_CLUSTER = 1;
    private int numberOfElements;
    private ClusterList[] elementClusters;
    private int clusterSerialCounter = 0;
    private boolean geneClusterRepository = false;
    private IFramework framework;

    public ClusterRepository(int n, IFramework iFramework) {
        this.numberOfElements = n;
        this.framework = iFramework;
        this.elementClusters = new ClusterList[n];
        this.addClusterList(new ClusterList("Cluster Ops."));
    }

    public ClusterRepository(int n, IFramework iFramework, boolean bl) {
        this.numberOfElements = n;
        this.framework = iFramework;
        this.elementClusters = new ClusterList[n];
        this.geneClusterRepository = bl;
        this.addClusterList(new ClusterList("Cluster Ops."));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.geneClusterRepository);
        objectOutputStream.writeInt(this.clusterSerialCounter);
        objectOutputStream.writeObject(this.elementClusters);
        objectOutputStream.writeInt(this.numberOfElements);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.geneClusterRepository = objectInputStream.readBoolean();
        this.clusterSerialCounter = objectInputStream.readInt();
        this.elementClusters = (ClusterList[])objectInputStream.readObject();
        this.numberOfElements = objectInputStream.readInt();
    }

    public void setFramework(IFramework iFramework) {
        this.framework = iFramework;
    }

    public Color getColor(int n) {
        if (this.elementClusters[n] == null || this.elementClusters[n].size() == 0) {
            return null;
        }
        Color color = this.elementClusters[n].lastCluster().getClusterColor();
        if (color != null) {
            return color;
        }
        Color[] colorArray = this.getColors(n);
        if (colorArray.length <= 1) {
            return null;
        }
        for (int i = colorArray.length - 2; i >= 0; --i) {
            if (colorArray[i] == null) continue;
            return colorArray[i];
        }
        return null;
    }

    public Color[] getColors(int n) {
        if (this.elementClusters[n] == null) {
            return null;
        }
        ClusterList clusterList = this.elementClusters[n];
        Color[] colorArray = new Color[clusterList.size()];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = clusterList.getClusterAt(i).getClusterColor();
        }
        return colorArray;
    }

    public int getDataElementCount() {
        return this.numberOfElements;
    }

    public boolean isGeneClusterRepository() {
        return this.geneClusterRepository;
    }

    public ClusterList getClusterList(int n) {
        if (this.isInRange(n)) {
            return (ClusterList)this.elementAt(n);
        }
        return null;
    }

    public void addClusterList(ClusterList clusterList) {
        this.add(clusterList);
    }

    public void addCluster(ClusterList clusterList, Cluster cluster) {
        if (cluster == null) {
            return;
        }
        if (!cluster.getSource().equals("Cluster Op.") && clusterList.isClusterSaved(cluster.getClusterID(), cluster.getIndices())) {
            Cluster cluster2 = clusterList.getCluster(cluster.getClusterID());
            if (cluster2 == null) {
                clusterList.addCluster(cluster);
                this.updateClusterMembership(cluster);
                return;
            }
            cluster2.setClusterColor(cluster.getClusterColor());
            cluster2.setClusterLabel(cluster.getClusterLabel());
            cluster2.setClusterDescription(cluster.getClusterDescription());
            this.setClusterSerialCounter(this.getMaxClusterSerialNumber() - 1);
            this.moveClusterToEndInMembershipLists(cluster2);
        } else {
            if (clusterList == null) {
                clusterList = new ClusterList("Cluster Ops.");
                this.addClusterList(clusterList);
            }
            clusterList.addCluster(cluster);
            this.updateClusterMembership(cluster);
        }
    }

    public void addSubCluster(ClusterList clusterList, Cluster cluster) {
        if (cluster == null) {
            return;
        }
        clusterList.addCluster(cluster);
        this.updateClusterMembership(cluster);
    }

    private void updateClusterMembership(Cluster cluster) {
        int[] nArray = cluster.getIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.elementClusters[nArray[i]] == null) {
                this.elementClusters[nArray[i]] = new ClusterList("element " + nArray[i]);
            }
            this.elementClusters[nArray[i]].add(cluster);
        }
    }

    private void moveClusterToEndInMembershipLists(Cluster cluster) {
        int[] nArray = cluster.getIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.elementClusters[nArray[i]] == null) {
                this.elementClusters[nArray[i]] = new ClusterList("element " + nArray[i]);
            }
            if (!this.elementClusters[nArray[i]].contains(cluster)) continue;
            this.elementClusters[nArray[i]].removeElement(cluster);
            this.elementClusters[nArray[i]].addElement(cluster);
        }
    }

    private void removeClusterMembership(Cluster cluster) {
        int[] nArray = cluster.getIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.elementClusters[nArray[i]] == null) continue;
            this.elementClusters[nArray[i]].removeElement(cluster);
        }
    }

    public void clearClusterLists() {
        for (int i = 0; i < this.size(); ++i) {
            this.getClusterList(i).clear();
        }
        this.clearElementClusters();
        if (this.isGeneClusterRepository()) {
            this.framework.getData().deleteColors();
        } else {
            this.framework.getData().deleteExperimentColors();
        }
    }

    private void clearElementClusters() {
        for (int i = 0; i < this.numberOfElements; ++i) {
            this.elementClusters[i] = null;
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getClusterList(i).size() <= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isInRange(int n) {
        return n > -1 && n < this.size();
    }

    public Cluster storeCluster(int n, String string, String string2, int[] nArray, Experiment experiment) {
        Object object;
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null) {
            clusterList = new ClusterList(string);
            this.addClusterList(clusterList);
        } else if (clusterList.isClusterSaved(string2, nArray)) {
            object = new JOptionPane("Cluster has already been saved.  Would you like to replace the existing attributes?", 3, 1);
            ((JComponent)object).setVisible(true);
            int n2 = ((JOptionPane)object).getOptionType();
            if (n2 == 2 || n2 == 1) {
                return null;
            }
        }
        object = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (((ClusterAttributesDialog)((Object)object)).showModal() != 0) {
            return null;
        }
        Color color = ((ClusterAttributesDialog)((Object)object)).getColor();
        String string3 = ((ClusterAttributesDialog)((Object)object)).getLabel();
        String string4 = ((ClusterAttributesDialog)((Object)object)).getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(nArray, "Algorithm", string3, string, string2, string4, n, this.clusterSerialCounter, color, experiment);
        this.addCluster(clusterList, cluster);
        return cluster;
    }

    public Cluster storeCluster(int n, String string, String string2, int[] nArray, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        int n2;
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null) {
            clusterList = new ClusterList(string);
            this.addClusterList(clusterList);
        } else if (clusterList.isClusterSaved(string2, nArray) && (n2 = JOptionPane.showConfirmDialog(new Frame(), "Cluster has already been saved.  Would you like to modify the existing attributes?", "Cluster Saved Alert", 0, 3)) == 1) {
            return null;
        }
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (clusterAttributesDialog.showModal() != 0) {
            return null;
        }
        Color color = clusterAttributesDialog.getColor();
        String string3 = clusterAttributesDialog.getLabel();
        String string4 = clusterAttributesDialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(nArray, "Algorithm", string3, string, string2, string4, n, this.clusterSerialCounter, color, defaultMutableTreeNode, experiment);
        this.addCluster(clusterList, cluster);
        return cluster;
    }

    public Cluster storeSubCluster(int n, String string, String string2, int[] nArray, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        ClusterList clusterList = this.findClusterList(string);
        boolean bl = false;
        if (clusterList == null) {
            clusterList = new ClusterList(string);
            this.addClusterList(clusterList);
        } else if (clusterList.isClusterSaved(string2, nArray) && clusterList.getCluster(string2).doIndicesMatch(nArray)) {
            int n2 = JOptionPane.showConfirmDialog(new Frame(), "Cluster has already been saved.  Would you like to modify the existing attributes?", "Cluster Saved Alert", 0, 3);
            bl = true;
            if (n2 == 1) {
                return null;
            }
        }
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (clusterAttributesDialog.showModal() != 0) {
            return null;
        }
        Color color = clusterAttributesDialog.getColor();
        String string3 = clusterAttributesDialog.getLabel();
        String string4 = clusterAttributesDialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(nArray, "Algorithm", string3, string, string2, string4, n, this.clusterSerialCounter, color, defaultMutableTreeNode, experiment);
        if (bl) {
            this.addCluster(clusterList, cluster);
        } else {
            this.addSubCluster(clusterList, cluster);
        }
        return cluster;
    }

    private ClusterList findClusterList(String string) {
        for (int i = 0; i < this.size(); ++i) {
            ClusterList clusterList = this.getClusterList(i);
            if (!clusterList.getAlgorithmName().equals(string)) continue;
            return clusterList;
        }
        return null;
    }

    public ClusterList getClusterOperationsList() {
        return this.findClusterList("Cluster Ops.");
    }

    public boolean removeCluster(int[] nArray, String string, String string2) {
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null || clusterList.size() == 0) {
            return false;
        }
        Cluster cluster = clusterList.getCluster(string2);
        if (cluster != null) {
            int n = cluster.getSerialNumber();
            if (this.isGeneClusterRepository()) {
                this.framework.getData().setProbesColor(nArray, null);
                this.framework.addHistory("Remove Gene Cluster From Repository: Serial # " + String.valueOf(n));
            } else {
                this.framework.getData().setExperimentColor(nArray, null);
                this.framework.addHistory("Remove Experiment Cluster From Repository: Serial # " + String.valueOf(n));
            }
        } else {
            return false;
        }
        clusterList.removeCluster(string2);
        this.removeElementClusters(nArray, cluster);
        return true;
    }

    public boolean removeSubCluster(int[] nArray, String string, String string2) {
        int n;
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null || clusterList.size() == 0) {
            return false;
        }
        Cluster cluster = null;
        Cluster cluster2 = null;
        for (n = 0; n < clusterList.size(); ++n) {
            cluster2 = clusterList.getClusterAt(n);
            if (!cluster2.doIndicesMatch(nArray)) continue;
            cluster = cluster2;
        }
        if (cluster == null) {
            return false;
        }
        n = cluster.getSerialNumber();
        if (this.isGeneClusterRepository()) {
            this.framework.getData().setProbesColor(nArray, null);
            this.framework.addHistory("Remove Gene Cluster From Repository: Serial # " + String.valueOf(n));
        } else {
            this.framework.getData().setExperimentColor(nArray, null);
            this.framework.addHistory("Remove Experiment Cluster From Repository: Serial # " + String.valueOf(n));
        }
        clusterList.removeCluster(cluster);
        this.removeElementClusters(nArray, cluster);
        return true;
    }

    private void removeElementClusters(int[] nArray, Cluster cluster) {
        for (int i = 0; i < nArray.length; ++i) {
            this.elementClusters[nArray[i]].remove(cluster);
        }
    }

    public void updateClusterColor(int n, Color color) {
        Cluster cluster = this.getCluster(n);
        if (cluster != null) {
            cluster.setClusterColor(color);
        }
    }

    public Cluster getCluster(int n) {
        Cluster cluster = null;
        ClusterList clusterList = null;
        for (int i = 0; i < this.size(); ++i) {
            clusterList = this.getClusterList(i);
            for (int j = 0; j < clusterList.size(); ++j) {
                cluster = clusterList.getClusterAt(j);
                if (n != cluster.getSerialNumber()) continue;
                return cluster;
            }
        }
        return cluster;
    }

    public boolean removeCluster(int n) {
        Cluster cluster = this.getCluster(n);
        if (cluster == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ClusterList clusterList = this.getClusterList(i);
            for (int j = 0; j < clusterList.size(); ++j) {
                if (clusterList.getClusterAt(j) != cluster) continue;
                clusterList.removeCluster(n);
            }
        }
        int[] nArray = cluster.getIndices();
        this.removeClusterMembership(cluster);
        if (this.isGeneClusterRepository()) {
            this.framework.getData().setProbesColor(nArray, null);
            this.framework.addHistory("Remove Gene Cluster From Repository: Serial # " + String.valueOf(n));
        } else {
            this.framework.getData().setExperimentColor(nArray, null);
            this.framework.addHistory("Remove Experiment Cluster From Repository: Serial # " + String.valueOf(n));
        }
        return true;
    }

    public int takeNextClusterSerialNumber() {
        ++this.clusterSerialCounter;
        return this.clusterSerialCounter;
    }

    public int getMaxClusterSerialNumber() {
        return this.clusterSerialCounter;
    }

    public void setClusterSerialCounter(int n) {
        this.clusterSerialCounter = n;
    }

    public void printRepository() {
    }

    public void saveCluster(int n) {
        Cluster cluster = this.getCluster(n);
        try {
            if (this.geneClusterRepository) {
                ExperimentUtil.saveGeneCluster((Frame)this.framework.getFrame(), (IData)this.framework.getData(), (int[])cluster.getIndices());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.framework.getFrame(), (Experiment)cluster.getExperiment(), (IData)this.framework.getData(), (int[])cluster.getIndices());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving cluster.  Cluster not saved.", "Save Error", 2);
            exception.printStackTrace();
        }
    }

    public Cluster createClusterFromList() {
        Experiment experiment = this.framework.getData().getExperiment();
        if (this.isGeneClusterRepository()) {
            ListImportDialog listImportDialog = new ListImportDialog(this.framework.getFrame(), this.framework.getData().getFieldNames(), true);
            if (listImportDialog.showModal() == 0) {
                boolean[] blArray;
                String[] stringArray;
                String string = listImportDialog.getFieldName();
                int[] nArray = this.getMatchingIndices(experiment, string, stringArray = listImportDialog.getList(), blArray = new boolean[stringArray.length], true);
                if (nArray != null && nArray.length > 0) {
                    SearchResultDialog searchResultDialog = new SearchResultDialog(this.framework, nArray, stringArray, blArray, true);
                    if (searchResultDialog.showModal() == 0) {
                        int[] nArray2 = searchResultDialog.getSelectedIndices();
                        if (nArray2 == null || nArray2.length < 1) {
                            return null;
                        }
                        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", "List Import", "Gene List");
                        if (clusterAttributesDialog.showModal() != 0) {
                            return null;
                        }
                        ClusterList clusterList = this.getClusterOperationsList();
                        Color color = clusterAttributesDialog.getColor();
                        String string2 = clusterAttributesDialog.getLabel();
                        String string3 = clusterAttributesDialog.getDescription();
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(nArray2, "Cluster Op.", string2, "List Import", "N/A", string3, clusterList.getAlgorithmIndex(), this.clusterSerialCounter, color, experiment);
                        this.addCluster(clusterList, cluster);
                        return cluster;
                    }
                    return null;
                }
                JOptionPane.showMessageDialog(this.framework.getFrame(), "No genes matching the list entries were found.", "No Matches Found", 1);
            }
        } else {
            ISlideData iSlideData = this.framework.getData().getFeature(0);
            if (iSlideData == null) {
                return null;
            }
            Vector vector = iSlideData.getSlideDataKeys();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            ListImportDialog listImportDialog = new ListImportDialog(this.framework.getFrame(), stringArray, false);
            if (listImportDialog.showModal() == 0) {
                boolean[] blArray;
                String[] stringArray2;
                String string = listImportDialog.getFieldName();
                int[] nArray = this.getMatchingIndices(experiment, string, stringArray2 = listImportDialog.getList(), blArray = new boolean[stringArray2.length], false);
                if (nArray != null && nArray.length > 0) {
                    SearchResultDialog searchResultDialog = new SearchResultDialog(this.framework, nArray, stringArray2, blArray, false);
                    if (searchResultDialog.showModal() == 0) {
                        int[] nArray3 = searchResultDialog.getSelectedIndices();
                        if (nArray3 == null || nArray3.length < 1) {
                            return null;
                        }
                        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", "List Import", "Sample List");
                        if (clusterAttributesDialog.showModal() != 0) {
                            return null;
                        }
                        ClusterList clusterList = this.getClusterOperationsList();
                        Color color = clusterAttributesDialog.getColor();
                        String string4 = clusterAttributesDialog.getLabel();
                        String string5 = clusterAttributesDialog.getDescription();
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(nArray3, "List Import", string4, "List Import", "N/A", string5, clusterList.getAlgorithmIndex(), this.clusterSerialCounter, color, experiment);
                        this.addCluster(clusterList, cluster);
                        return cluster;
                    }
                } else {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "No samples matching the list entries were found.", "No Matches Found", 1);
                }
            }
        }
        return null;
    }

    private int[] getMatchingIndices(Experiment experiment, String string, String[] stringArray, boolean bl) {
        int[] nArray = null;
        Vector<Integer> vector = new Vector<Integer>();
        IData iData = this.framework.getData();
        if (bl) {
            int n;
            int[] nArray2 = experiment.getRowMappingArrayCopy();
            String[] stringArray2 = this.framework.getData().getAnnotationList(string, nArray2);
            Vector<String> vector2 = new Vector<String>(stringArray2.length);
            for (n = 0; n < stringArray.length; ++n) {
                vector2.addElement(stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (!vector2.contains(stringArray2[n])) continue;
                vector.addElement(new Integer(nArray2[n]));
            }
            nArray = new int[vector.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector.elementAt(n);
            }
        } else {
            int n;
            int[] nArray3 = experiment.getColumnIndicesCopy();
            String[] stringArray3 = new String[experiment.getNumberOfSamples()];
            iData.setSampleLabelKey(string);
            Vector<String> vector3 = new Vector<String>(stringArray3.length);
            for (n = 0; n < stringArray.length; ++n) {
                vector3.addElement(stringArray[n]);
            }
            for (n = 0; n < nArray3.length; ++n) {
                stringArray3[n] = iData.getFullSampleName(n);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                if (!vector3.contains(stringArray3[n])) continue;
                vector.addElement(new Integer(nArray3[n]));
            }
            nArray = new int[vector.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector.elementAt(n);
            }
        }
        return nArray;
    }

    private int[] getMatchingIndices(Experiment experiment, String string, String[] stringArray, boolean[] blArray, boolean bl) {
        int[] nArray = null;
        Vector<Integer> vector = new Vector<Integer>();
        IData iData = this.framework.getData();
        if (bl) {
            int n;
            int[] nArray2 = experiment.getRowMappingArrayCopy();
            String[] stringArray2 = this.framework.getData().getAnnotationList(string, nArray2);
            Vector<String> vector2 = new Vector<String>(stringArray2.length);
            for (n = 0; n < stringArray.length; ++n) {
                vector2.addElement(stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (!vector2.contains(stringArray2[n])) continue;
                vector.addElement(new Integer(nArray2[n]));
                for (int i = 0; i < vector2.size(); ++i) {
                    if (!stringArray2[n].equals((String)vector2.elementAt(i))) continue;
                    blArray[i] = true;
                }
            }
            nArray = new int[vector.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector.elementAt(n);
            }
        } else {
            int n;
            int[] nArray3 = experiment.getColumnIndicesCopy();
            String[] stringArray3 = new String[experiment.getNumberOfSamples()];
            iData.setSampleLabelKey(string);
            Vector<String> vector3 = new Vector<String>(stringArray3.length);
            for (n = 0; n < stringArray.length; ++n) {
                vector3.addElement(stringArray[n]);
            }
            for (n = 0; n < nArray3.length; ++n) {
                stringArray3[n] = iData.getFullSampleName(n);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                if (!vector3.contains(stringArray3[n])) continue;
                vector.addElement(new Integer(nArray3[n]));
                for (int i = 0; i < vector3.size(); ++i) {
                    if (!stringArray3[n].equals((String)vector3.elementAt(i))) continue;
                    blArray[i] = true;
                }
            }
            nArray = new int[vector.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector.elementAt(n);
            }
        }
        return nArray;
    }

    public void submitCluster(Cluster cluster) {
        SubmissionManager submissionManager = new SubmissionManager(this.framework, this);
        submissionManager.submit(cluster);
    }
}

