/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;

public class ClusterList
extends Vector
implements Serializable {
    public static final long serialVersionUID = 1000102010203020001L;
    String algorithmName;
    int algorithmIndex;

    public ClusterList() {
    }

    public ClusterList(int n) {
        super(n);
    }

    public ClusterList(String string) {
        this.algorithmName = string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.algorithmIndex);
        objectOutputStream.writeObject(this.algorithmName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.algorithmIndex = objectInputStream.readInt();
        this.algorithmName = (String)objectInputStream.readObject();
    }

    public void addCluster(Cluster cluster) {
        this.add(cluster);
    }

    public void removeCluster(Cluster cluster) {
        this.remove(cluster);
    }

    public void removeClusterAt(int n) {
        if (this.isInRange(n)) {
            this.removeElementAt(n);
        }
    }

    public Cluster getClusterAt(int n) {
        if (this.isInRange(n)) {
            return (Cluster)this.elementAt(n);
        }
        return null;
    }

    public Cluster lastCluster() {
        if (!this.isEmpty()) {
            return (Cluster)this.lastElement();
        }
        return null;
    }

    public Color getClusterColor(int n) {
        if (this.isInRange(n)) {
            return ((Cluster)this.elementAt(n)).getClusterColor();
        }
        return null;
    }

    public String getClusterName(int n) {
        if (this.isInRange(n)) {
            return ((Cluster)this.elementAt(n)).getClusterLabel();
        }
        return null;
    }

    public String getClusterID(int n) {
        if (this.isInRange(n)) {
            return ((Cluster)this.elementAt(n)).getClusterID();
        }
        return null;
    }

    public int getClusterSerialNumber(int n) {
        if (this.isInRange(n)) {
            return ((Cluster)this.elementAt(n)).getSerialNumber();
        }
        return -1;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getAlgorithmIndex() {
        return this.algorithmIndex;
    }

    protected boolean isInRange(int n) {
        return n > -1 && n < this.size();
    }

    public boolean isClusterSaved(String string, int[] nArray) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getClusterID(i).equals(string) || !this.getCluster(string).doIndicesMatch(nArray)) continue;
            return true;
        }
        return false;
    }

    public boolean isClusterSaved(int n) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getClusterSerialNumber(i) != n) continue;
            return true;
        }
        return false;
    }

    public Cluster getCluster(String string) {
        for (int i = 0; i < this.size(); ++i) {
            Cluster cluster = this.getClusterAt(i);
            if (!cluster.getClusterID().equals(string)) continue;
            return cluster;
        }
        return null;
    }

    public Cluster getCluster(int n) {
        for (int i = 0; i < this.size(); ++i) {
            Cluster cluster = this.getClusterAt(i);
            if (cluster.getSerialNumber() != n) continue;
            return cluster;
        }
        return null;
    }

    public void removeCluster(String string) {
        Cluster cluster = this.getCluster(string);
        if (cluster != null) {
            this.removeCluster(cluster);
        }
    }

    public void removeCluster(int n) {
        Cluster cluster = this.getCluster(n);
        if (cluster != null) {
            this.removeCluster(cluster);
        }
    }
}

