/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;

public class Cluster
implements Serializable {
    public static final long serialVersionUID = 1000102010203010001L;
    public static final int GENE_CLUSTER = 0;
    public static final int EXPERIMENT_CLUSTER = 1;
    private Color clusterColor;
    private int[] indices;
    private int[] experimentIndices;
    private String source;
    private String clusterID;
    private String clusterLabel;
    private String algorithmName;
    private String clusterDescription;
    private int algorithmIndex;
    private int serialNumber;
    private DefaultMutableTreeNode node;
    private Experiment experiment;
    private Object userObject;
    private boolean isShowColor;

    public Cluster(int[] nArray, String string, String string2, String string3, String string4, String string5, int n, int n2, Color color, Experiment experiment) {
        this.indices = nArray;
        this.source = string;
        this.clusterLabel = string2;
        this.clusterID = string4;
        this.algorithmName = string3;
        this.algorithmIndex = n;
        this.clusterColor = color;
        this.clusterDescription = string5;
        this.serialNumber = n2;
        this.experiment = experiment;
        this.isShowColor = true;
        this.experimentIndices = this.getIndicesMappedToExperiment();
    }

    public Cluster(int[] nArray, String string, String string2, String string3, String string4, String string5, int n, int n2, Color color, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        this.indices = nArray;
        this.source = string;
        this.clusterLabel = string2;
        this.clusterID = string4;
        this.algorithmName = string3;
        this.algorithmIndex = n;
        this.clusterColor = color;
        this.clusterDescription = string5;
        this.serialNumber = n2;
        this.node = defaultMutableTreeNode;
        this.userObject = defaultMutableTreeNode.getUserObject();
        this.experiment = experiment;
        this.isShowColor = true;
        this.experimentIndices = this.getIndicesMappedToExperiment();
    }

    public Color getClusterColor() {
        if (this.isShowColor) {
            return this.clusterColor;
        }
        return null;
    }

    public void enableShowColor(boolean bl) {
        this.isShowColor = bl;
    }

    public boolean showColor() {
        return this.isShowColor;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int[] getExperimentIndices() {
        return this.experimentIndices;
    }

    public String getSource() {
        return this.source;
    }

    public String getClusterLabel() {
        return this.clusterLabel;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getClusterDescription() {
        return this.clusterDescription;
    }

    public int getAlgorithmIndex() {
        return this.algorithmIndex;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getSize() {
        return this.indices.length;
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setClusterColor(Color color) {
        this.clusterColor = color;
    }

    public void setClusterLabel(String string) {
        this.clusterLabel = string;
    }

    public void setClusterDescription(String string) {
        this.clusterDescription = string;
    }

    public void setNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.node = defaultMutableTreeNode;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public boolean isMember(int n) {
        for (int i = 0; i < this.indices.length; ++i) {
            if (n != this.indices[i]) continue;
            return true;
        }
        return false;
    }

    public boolean removeMember(int n) {
        if (!this.isMember(n)) {
            return false;
        }
        int[] nArray = new int[this.indices.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] == n) continue;
            nArray[n2] = this.indices[i];
            ++n2;
        }
        return true;
    }

    public HashSet getHashSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>(this.indices.length);
        for (int i = 0; i < this.indices.length; ++i) {
            hashSet.add(new Integer(this.indices[i]));
        }
        return hashSet;
    }

    public boolean doIndicesMatch(int[] nArray) {
        if (nArray.length != this.indices.length) {
            return false;
        }
        HashSet hashSet = this.getHashSet();
        HashSet hashSet2 = this.makeHashSet(nArray);
        return hashSet.containsAll(hashSet2);
    }

    private HashSet makeHashSet(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            hashSet.add(new Integer(nArray[i]));
        }
        return hashSet;
    }

    private int[] getIndicesMappedToExperiment() {
        int[] nArray = new int[this.indices.length];
        int[] nArray2 = this.experiment.getRowMappingArrayCopy();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.indices[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] != n) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.indices);
        objectOutputStream.writeObject(this.source);
        objectOutputStream.writeObject(this.clusterLabel);
        objectOutputStream.writeObject(this.clusterID);
        objectOutputStream.writeObject(this.algorithmName);
        objectOutputStream.writeInt(this.algorithmIndex);
        objectOutputStream.writeObject(this.clusterColor);
        objectOutputStream.writeObject(this.clusterDescription);
        objectOutputStream.writeInt(this.serialNumber);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.experimentIndices);
        objectOutputStream.writeBoolean(this.isShowColor);
        objectOutputStream.writeBoolean(this.node != null);
        if (this.node != null) {
            objectOutputStream.writeObject(this.node.getUserObject());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.indices = (int[])objectInputStream.readObject();
        this.source = (String)objectInputStream.readObject();
        this.clusterLabel = (String)objectInputStream.readObject();
        this.clusterID = (String)objectInputStream.readObject();
        this.algorithmName = (String)objectInputStream.readObject();
        this.algorithmIndex = objectInputStream.readInt();
        this.clusterColor = (Color)objectInputStream.readObject();
        this.clusterDescription = (String)objectInputStream.readObject();
        this.serialNumber = objectInputStream.readInt();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.experimentIndices = (int[])objectInputStream.readObject();
        this.isShowColor = objectInputStream.readBoolean();
        if (objectInputStream.readBoolean()) {
            this.userObject = objectInputStream.readObject();
        }
    }
}

