/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;
import org.tigr.microarray.mev.ArrayElement;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.TMEV;

public class SlideDataElement
extends ArrayElement
implements ISlideDataElement,
Serializable {
    public static final long serialVersionUID = 100010201130001L;
    protected String UID;
    protected int[] rows;
    protected int[] columns;
    protected float[] currentIntensity;
    protected float[] trueIntensity;
    protected String[] extraFields;
    protected boolean isNull = false;
    protected boolean isNonZero = true;

    public SlideDataElement(String string, int[] nArray, int[] nArray2, float[] fArray, String[] stringArray) {
        this.UID = string;
        this.rows = this.copyArray(nArray);
        this.columns = this.copyArray(nArray2);
        this.currentIntensity = this.copyArray(fArray);
        this.trueIntensity = this.copyArray(fArray);
        this.extraFields = this.copyArray(stringArray);
    }

    public SlideDataElement(int[] nArray, int[] nArray2, float[] fArray, String[] stringArray) {
        this.rows = this.copyArray(nArray);
        this.columns = this.copyArray(nArray2);
        this.currentIntensity = this.copyArray(fArray);
        this.trueIntensity = this.copyArray(fArray);
        this.extraFields = this.copyArray(stringArray);
    }

    public SlideDataElement(ISlideDataElement iSlideDataElement) {
        this.UID = iSlideDataElement.getUID();
        this.rows = iSlideDataElement.getRows();
        this.columns = iSlideDataElement.getColumns();
        this.currentIntensity = this.copyArray(iSlideDataElement.getCurrentIntensity());
        this.trueIntensity = this.copyArray(iSlideDataElement.getTrueIntensity());
        this.extraFields = iSlideDataElement.getExtraFields();
    }

    public void setExtraFields(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this.extraFields == null) {
            this.extraFields = stringArray;
        } else {
            int n;
            String[] stringArray2 = new String[this.extraFields.length + stringArray.length];
            for (n = 0; n < this.extraFields.length; ++n) {
                stringArray2[n] = this.extraFields[n];
            }
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n + this.extraFields.length] = stringArray[n];
            }
            this.extraFields = stringArray2;
        }
    }

    private String[] copyArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private int[] copyArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private float[] copyArray(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public int[] getRows() {
        return this.rows;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public String[] getExtraFields() {
        return this.extraFields;
    }

    public float[] getCurrentIntensity() {
        return this.currentIntensity;
    }

    public float[] getTrueIntensity() {
        return this.trueIntensity;
    }

    public void setRow(int n, int n2) {
        switch (n) {
            case 0: {
                this.rows[0] = n2;
                break;
            }
            case 1: {
                this.rows[1] = n2;
                break;
            }
            case 2: {
                this.rows[2] = n2;
            }
        }
    }

    public void setColumn(int n, int n2) {
        switch (n) {
            case 0: {
                this.columns[0] = n2;
                break;
            }
            case 1: {
                this.columns[1] = n2;
                break;
            }
            case 2: {
                this.columns[2] = n2;
            }
        }
    }

    public int getRow(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.rows[0];
                break;
            }
            case 1: {
                n2 = this.rows[1];
                break;
            }
            case 2: {
                n2 = this.rows[2];
            }
        }
        return n2;
    }

    public int getColumn(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.columns[0];
                break;
            }
            case 1: {
                n2 = this.columns[1];
                break;
            }
            case 2: {
                n2 = this.columns[2];
            }
        }
        return n2;
    }

    public int getLocation(int n, int n2) {
        int n3 = -1;
        switch (n) {
            case 0: {
                n3 = this.columns[0] + (this.rows[0] - 1) * n2;
                break;
            }
            case 1: {
                n3 = this.columns[1] + (this.rows[1] - 1) * n2;
                break;
            }
            case 2: {
                n3 = this.columns[2] + (this.rows[2] - 1) * n2;
            }
        }
        return n3;
    }

    public float getIntensity(int n) {
        float f = -1.0f;
        switch (n) {
            case 0: {
                f = this.currentIntensity[0];
                break;
            }
            case 1: {
                f = this.currentIntensity[1];
            }
        }
        return f;
    }

    public void setIntensity(int n, float f) {
        switch (n) {
            case 0: {
                this.currentIntensity[0] = f;
                break;
            }
            case 1: {
                this.currentIntensity[1] = f;
            }
        }
    }

    public void setCurrentIntensity(int n, float f) {
        switch (n) {
            case 0: {
                this.currentIntensity[0] = f;
                break;
            }
            case 1: {
                this.currentIntensity[1] = f;
            }
        }
    }

    public void setTrueIntensity(int n, float f) {
        switch (n) {
            case 0: {
                this.trueIntensity[0] = f;
                break;
            }
            case 1: {
                this.trueIntensity[1] = f;
            }
        }
    }

    public float getTrueIntensity(int n) {
        float f = -1.0f;
        switch (n) {
            case 0: {
                f = this.trueIntensity[0];
                break;
            }
            case 1: {
                f = this.trueIntensity[1];
            }
        }
        return f;
    }

    public float getRatio(int n, int n2, int n3) {
        return this.getRatio(n, n2, n3, this.isNonZero);
    }

    public float getRatio(int n, int n2, int n3, boolean bl) {
        float f;
        if (bl) {
            if (this.getIntensity(n) == 0.0f && this.getIntensity(n2) == 0.0f) {
                return Float.NaN;
            }
            f = this.getIntensity(n) == 0.0f ? 1.0f / this.getIntensity(n2) : (this.getIntensity(n2) == 0.0f ? this.getIntensity(n) / 1.0f : this.getIntensity(n) / this.getIntensity(n2));
        } else {
            if (this.getIntensity(n) == 0.0f) {
                return Float.NaN;
            }
            if (this.getIntensity(n2) == 0.0f) {
                return Float.NaN;
            }
            f = this.getIntensity(n) / this.getIntensity(n2);
        }
        if (n3 == 1) {
            f = (float)(Math.log(f) / Math.log(2.0));
        }
        return f;
    }

    public double getTrueRatio(int n, int n2, int n3) {
        return this.getTrueRatio(n, n2, n3, this.isNonZero);
    }

    public double getTrueRatio(int n, int n2, int n3, boolean bl) {
        double d;
        if (bl) {
            if (this.getTrueIntensity(n) == 0.0f && this.getTrueIntensity(n2) == 0.0f) {
                return Double.NaN;
            }
            d = this.getTrueIntensity(n) == 0.0f ? 1.0 / (double)this.getTrueIntensity(n2) : (this.getTrueIntensity(n2) == 0.0f ? (double)this.getTrueIntensity(n) / 1.0 : (double)this.getTrueIntensity(n) / (double)this.getTrueIntensity(n2));
        } else {
            if (this.getTrueIntensity(n) == 0.0f) {
                return Double.NaN;
            }
            if (this.getTrueIntensity(n2) == 0.0f) {
                return Double.NaN;
            }
            d = (double)this.getTrueIntensity(n) / (double)this.getTrueIntensity(n2);
        }
        if (n3 == 1) {
            d = (float)(Math.log(d) / Math.log(2.0));
        }
        return d;
    }

    public float getIntensityMean(int n) {
        return 0.0f;
    }

    public void setNonZero(boolean bl) {
        this.isNonZero = bl;
    }

    public void setDetection(String string) {
    }

    public String getDetection() {
        return "";
    }

    public boolean isNonZero() {
        return this.isNonZero;
    }

    public void setIsNull(boolean bl) {
        this.isNull = bl;
    }

    public boolean getIsNull() {
        return this.isNull;
    }

    public boolean hasNoZeros() {
        return this.getTrueIntensity(0) != 0.0f && this.getTrueIntensity(1) != 0.0f;
    }

    public String getAttributeString(int n) {
        String string = "";
        int n2 = TMEV.getCoordinatePairCount() * 2;
        int n3 = TMEV.getIntensityCount();
        int n4 = TMEV.getFieldNames().length;
        string = n < n2 ? (n % 2 == 0 ? String.valueOf(this.rows[n / 2]) : String.valueOf(this.columns[(n + 1) / 2])) : (n < n2 + n3 ? String.valueOf(this.currentIntensity[n - n2]) : (n < n2 + n3 + n4 ? this.getFieldAt(n - (n2 + n3)) : ""));
        return string;
    }

    public String getFieldAt(int n) {
        if (this.extraFields == null || n < 0 || n > this.extraFields.length - 1) {
            return "";
        }
        return this.extraFields[n];
    }

    public ISlideDataElement copy() {
        return new SlideDataElement(this);
    }

    public String toString() {
        return "SDE " + this.getRow(0) + ", " + this.getColumn(0);
    }

    public void setUID(String string) {
        this.UID = string;
    }

    public String getUID() {
        return this.UID;
    }
}

