/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class SetFoldFilterDialog
extends AlgorithmDialog {
    private GroupExperimentsPanel gPanel;
    private JButton filter;
    private JButton cancel;
    private JLabel msg1Label;
    private JLabel msg2Label;
    private JLabel msg3Label;
    private JLabel msg4Label;
    private int result;
    private FoldFilter ff;
    private String BOTH = "both";
    private String GREATER_THAN = ">";
    private String LESS_THAN = "<";
    protected boolean use_filter;

    public SetFoldFilterDialog(JFrame jFrame, String[] stringArray) {
        super(jFrame, "Set Fold Filter", true);
        int n;
        this.setBounds(0, 0, 800, 500);
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.setLayout(new BorderLayout(2, 2));
        Listener listener = new Listener();
        String string = "Genes in Group A must be ";
        String string2 = "than in Group B by ";
        String string3 = " fold.";
        String string4 = "'both' will keep ALL genes whose fold change is greater than the threshold";
        String[] stringArray2 = new String[]{this.GREATER_THAN, this.LESS_THAN, this.BOTH};
        this.msg1Label = new JLabel(string);
        this.msg2Label = new JLabel(string2);
        this.msg3Label = new JLabel(string3);
        this.msg4Label = new JLabel(string4);
        JTextField jTextField = new JTextField("2.0", 3);
        jTextField.addKeyListener(new VoteKeyListener());
        jTextField.addFocusListener(new VoteFocusListener(0, 1));
        JList<String> jList = new JList<String>(stringArray2);
        jList.setBorder(BorderFactory.createLineBorder(Color.black));
        jList.setBackground(Color.lightGray);
        jList.setVisibleRowCount(3);
        jList.addListSelectionListener(new SelectionListener());
        this.gPanel = new GroupExperimentsPanel(stringArray);
        this.ff = new FoldFilter(stringArray);
        for (n = 0; n < this.gPanel.groupARadioButtons.length; ++n) {
            this.gPanel.groupARadioButtons[n].addActionListener(new GroupListener(0, n));
        }
        for (n = 0; n < this.gPanel.groupBRadioButtons.length; ++n) {
            this.gPanel.groupBRadioButtons[n].addActionListener(new GroupListener(1, n));
        }
        jPanel.add((Component)this.gPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel3.setLayout(new FlowLayout(0));
        jPanel4.setLayout(new FlowLayout(0));
        jPanel3.add(this.msg1Label);
        jPanel3.add(jList);
        jPanel3.add(this.msg2Label);
        jPanel3.add(jTextField);
        jPanel3.add(this.msg3Label);
        jPanel4.add(this.msg4Label);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "South");
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[40];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = "name" + Integer.toString(i);
        }
        SetFoldFilterDialog setFoldFilterDialog = new SetFoldFilterDialog(new JFrame(), stringArray2);
        setFoldFilterDialog.showModal();
    }

    public SetFoldFilterDialog(JFrame jFrame, String[] stringArray, FoldFilter foldFilter) {
        this(jFrame, stringArray);
        this.ff = foldFilter;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public FoldFilter getFoldFilter() {
        return this.ff;
    }

    class GroupExperimentsPanel
    extends JPanel {
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(String[] stringArray) {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            JPanel jPanel = new JPanel();
            JLabel[] jLabelArray = new JLabel[stringArray.length];
            this.groupARadioButtons = new JRadioButton[stringArray.length];
            this.groupBRadioButtons = new JRadioButton[stringArray.length];
            this.neitherGroupRadioButtons = new JRadioButton[stringArray.length];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[stringArray.length];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                jLabelArray[i] = new JLabel(string);
                buttonGroupArray[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                buttonGroupArray[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                buttonGroupArray[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither", false);
                buttonGroupArray[i].add(this.neitherGroupRadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(jLabelArray[i], gridBagConstraints);
                jPanel.add(jLabelArray[i]);
                this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupARadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupARadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupBRadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupBRadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 3, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.neitherGroupRadioButtons[i], gridBagConstraints);
                jPanel.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setPreferredSize(new Dimension(400, 450));
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
        }

        void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.weightx = n5;
            gridBagConstraints.weighty = n6;
        }
    }

    class GroupListener
    implements ActionListener {
        int file_index;
        int group;

        GroupListener(int n, int n2) {
            this.group = n;
            this.file_index = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SetFoldFilterDialog.this.ff.get_group_membership(this.file_index) != this.group) {
                SetFoldFilterDialog.this.ff.set_group_membership(this.group, this.file_index);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                String string = (String)jList.getSelectedValue();
                if (string.equals(SetFoldFilterDialog.this.GREATER_THAN)) {
                    SetFoldFilterDialog.this.ff.set_divider(SetFoldFilterDialog.this.GREATER_THAN);
                }
                if (string.equals(SetFoldFilterDialog.this.LESS_THAN)) {
                    SetFoldFilterDialog.this.ff.set_divider(SetFoldFilterDialog.this.LESS_THAN);
                }
                if (string.equals(SetFoldFilterDialog.this.BOTH)) {
                    SetFoldFilterDialog.this.ff.set_divider(SetFoldFilterDialog.this.BOTH);
                }
            }
        }
    }

    class VoteFocusListener
    extends FocusAdapter {
        private int required;
        private int group_index;

        VoteFocusListener(int n, int n2) {
            this.required = n2;
            this.group_index = n;
        }

        public void focusLost(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            String string = jTextField.getText();
            SetFoldFilterDialog.this.ff.set_fold_change(Float.parseFloat(string));
        }
    }

    class VoteKeyListener
    extends KeyAdapter {
        VoteKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '.' && c != '\u007f') {
                SetFoldFilterDialog.this.getToolkit().beep();
                keyEvent.consume();
            }
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener,
    ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                this.onOk();
            } else if (string.equals("cancel-command")) {
                SetFoldFilterDialog.this.result = 2;
                SetFoldFilterDialog.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetFoldFilterDialog.this.result = -1;
            SetFoldFilterDialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            SetFoldFilterDialog.this.use_filter = itemEvent.getStateChange() == 1;
        }

        private void onOk() {
            try {
                SetFoldFilterDialog.this.getFoldFilter();
                SetFoldFilterDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetFoldFilterDialog.this.result = 2;
            }
            SetFoldFilterDialog.this.dispose();
        }
    }
}

