/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.util.awt.GBA;

public class PaperReferencesDialog
extends JDialog
implements Printable {
    private String text;
    private JEditorPane ed;

    public PaperReferencesDialog(Frame frame) {
        this(frame, "");
    }

    public PaperReferencesDialog(Frame frame, String string) {
        super(frame, "Papers / Publications Reference", false);
        EventListener eventListener = new EventListener();
        this.text = string;
        GBA gBA = new GBA();
        Font font = new Font("serif", 0, 12);
        this.ed = new JEditorPane("text/html", string);
        this.ed.setEditable(false);
        this.ed.setMargin(new Insets(10, 10, 10, 10));
        this.ed.setBackground(new Color(234, 233, 191));
        this.ed.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this.ed, 20, 31);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(new Color(234, 233, 191));
        gBA.add((Container)jPanel, (Component)jScrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
        JButton jButton = new JButton("Print");
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setFocusPainted(false);
        jButton.setActionCommand("print-command");
        jButton.addActionListener(eventListener);
        JButton jButton2 = new JButton("  Close  ");
        jButton2.setBorder(BorderFactory.createBevelBorder(0));
        jButton2.setFocusPainted(false);
        jButton2.setActionCommand("close-command");
        jButton2.addActionListener(eventListener);
        jButton2.setSize(120, 30);
        jButton2.setPreferredSize(new Dimension(120, 30));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        gBA.add((Container)jPanel2, (Component)jButton2, 0, 0, 1, 1, 1, 1, 0, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        gBA.add(this.getContentPane(), (Component)jPanel, 0, 0, 1, 2, 1, 1, 1, 10);
        gBA.add(this.getContentPane(), (Component)jPanel2, 0, 2, 1, 1, 0, 0, 0, 10);
        this.setSize(550, 650);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
    }

    public static String createReferencesText() {
        String string = "";
        string = string + "<html><body>";
        string = string + "<p><font size = +1><b>HCL</b></font> - ";
        string = string + "<b>Hierarchical Clustering</b>";
        string = string + "<br>Eisen, M.B., P.T. Spellman, P.O. Brown, and D. Botstein (1998) ";
        string = string + "Cluster analysis and display of genome-wide expression patterns. ";
        string = string + "<i>Proceedings of the National Academy of Sciences USA </i> ";
        string = string + "95:14863-14868.";
        string = string + "<br><p><font size = +1><b>ST</b></font> - ";
        string = string + "<b>Support trees (Bootstrapping)</b>";
        string = string + "<br>Graur, D., and W.-H. Li. 2000. ";
        string = string + "<i>Fundamentals of Molecular Evolution. Second Edition.</i>";
        string = string + "Sinauer Associates, Sunderland, MA. pp 209-210";
        string = string + "<br><p><font size = +1><b>SOTA</b></font> - ";
        string = string + "<b>Self-organizing trees</b>";
        string = string + "<br>Herrero J., A. Valencia, J. Dopazo (2001).  A hierarchical";
        string = string + "unsupervised growing neural network for clustering gene";
        string = string + "expression patterns.  <i>Bioinformatics</i> 17(2):126-136.";
        string = string + "<br><p>Dopazo, J., and J. M. Carazo (1997).  Phylogenetic reconstruction using ";
        string = string + "an unsupervised growing neural network that adopts the topology ";
        string = string + "of a phylogenetic tree.  <i>Journal of Molecular Evolution</i> 44:226-233.";
        string = string + "<br><p><font size = +1><b>KMC</b></font> - ";
        string = string + "<b>K-Means</b>";
        string = string + "<br>Soukas, A., P. Cohen, N.D. Socci, and J.M. Friedman (2000) ";
        string = string + "Leptin-specific patterns of gene expression in white adipose tissue. ";
        string = string + "<i>Genes and Development</i> 14:963-980.";
        string = string + "<br><p><font size = +1><b>SOM</b></font> - ";
        string = string + "<b>Self-Organizing Maps</b>";
        string = string + "<br>Kohonen, T. (1982) Self-organized formation of topologically ";
        string = string + "correct feature maps. <i>Biological Cybernetics</i> 43:59-69";
        string = string + "<br><p>Tamayo, P., D. Slonim, J. Masirov, Q. Zhu, S. Kitareewan, ";
        string = string + "E. Dmitrovsky, E.S. Lander, and T.R. Golub (1999) Interpreting patterns ";
        string = string + "of gene expression with self-organizing maps: Methods and application ";
        string = string + "to hematopoietic differentiation. <i>Proceedings of the National Academy of Sciences USA </i> ";
        string = string + "96:2907-2912.";
        string = string + "<br><p><font size = +1><b>CAST</b></font> - ";
        string = string + "<b>Clustering Affinity Search Technique</b>";
        string = string + "<br>Ben-Dor, A., R. Shamir, and Z. Yakhini (1999) ";
        string = string + "Clustering gene expression patterns. ";
        string = string + "<i>Journal of Computational Biology</i> 6:281-297.";
        string = string + "<br><p><font size = +1><b>QTC</b></font> - ";
        string = string + "<b>Jackknife Clustering</b>";
        string = string + "<br>Heyer, L.J., S. Kruglyak, and S. Yooseph (1999) ";
        string = string + "Exploring expression data: identification and analysis of coexpressed genes. ";
        string = string + "<i>Genome Research</i> 9:1106-1115.";
        string = string + "<br><p><font size = +1><b>GSH</b></font> - ";
        string = string + "<b>Gene shaving</b>";
        string = string + "<br>Hastie, T. et al. (2000). 'Gene shaving' as a method for identifying ";
        string = string + "distinct sets of genes with similar expression patterns";
        string = string + "Genome Biology 1(2):research0003.1-0003.21.";
        string = string + "<br><p><font size = +1><b>FOM</b></font> - ";
        string = string + "<b>Figures of Merit</b>";
        string = string + "<br>Yeung, K.Y., D.R. Haynor, and W.L. Ruzzo (2001) ";
        string = string + "Validating clustering for gene expression data. ";
        string = string + "<i>Bioinformatics</i> 17:309-318.";
        string = string + "<br><p><font size = +1><b>PCA</b></font> - ";
        string = string + "<b>Principal Components Analysis</b>";
        string = string + "<br>Raychaudhuri, S.,  J. M. Stuart, & R. B. Altman (2000) ";
        string = string + "Principal components analysis to summarize microarray experiments: ";
        string = string + "application to sporulation time series. ";
        string = string + "<i>Pacific Symposium on Biocomputing 2000, Honolulu, Hawaii,</i> 452-463. ";
        string = string + "Available at http://smi-web.stanford.edu/pubs/SMI_Abstracts/SMI-1999-0804.html";
        string = string + "<br><p><font size = +1><b>COA</b></font> - ";
        string = string + "<b>Correspondence Analysis</b>";
        string = string + "<br>Fellenberg K. et al. (2001) ";
        string = string + "Correspondence analysis applied to microarray data. ";
        string = string + "<i>Proceedings of the National Academy of Sciences USA</i> 98: 10781-10786";
        string = string + "<br><p>Culhane A.C. et al. (2002) ";
        string = string + "Between-group analysis of microarray data. ";
        string = string + "<i>Bioinformatics</i> 18:1600-1608.";
        string = string + "<br><p><font size = +1><b>RN</b></font> - ";
        string = string + "<b>Relevance networks</b>";
        string = string + "<br>Butte, A.J., P. Tamayo, D. Slonim, T.R. Golub and I.S. Kohane (2000) ";
        string = string + "Discovering functional relationships between RNA expression and chemotherapautic ";
        string = string + "susceptibility using relevance networks.";
        string = string + "<i>Proceedings of the National Academy of Sciences USA</i> 97: 12182-12186";
        string = string + "<br><p><font size = +1><b>PTM</b></font> - ";
        string = string + "<b>Template Matching</b>";
        string = string + "<br>Pavlidis, P., and W.S. Noble (2001) ";
        string = string + "Analysis of strain and regional variation in gene expression in mouse brain. ";
        string = string + "<i>Genome Biology</i> 2:research0042.1-0042.15";
        string = string + "<br><p><font size = +1><b>SAM</b></font> - ";
        string = string + "<b>Significance Analysis of Microarrays</b>";
        string = string + "<br>Tusher, V.G., R. Tibshirani and G. Chu. (2001) ";
        string = string + "Significance analysis of microarrays applied to the ionizing radiation response. ";
        string = string + "<i>Proceedings of the National Academy of Sciences USA</i> 98: 5116-5121.";
        string = string + "<br><p>Chu, G., B. Narasimhan, R. Tibshirani and V. Tusher (2002).";
        string = string + "SAM \"Significance Analysis of Microarrays\" Users Guide and Technical Document.";
        string = string + "http://www-stat.stanford.edu/~tibs/SAM/";
        string = string + "<br><p><font size = +1><b>ANOVA</b></font> - ";
        string = string + "<b>One-way Analysis of Variance</b>";
        string = string + "<br>Zar, J.H. 1999. Biostatistical Analysis. 4th ed. Prentice Hall, NJ.";
        string = string + "<br><p><font size = +1><b>TTEST</b></font> - ";
        string = string + "<b>T-Tests</b>";
        string = string + "<br>Pan, W. (2002). A comparative review of statistical methods for ";
        string = string + "discovering differentially expressed genes in replicated microarray experiments ";
        string = string + "<i>Bioinformatics</i> 18: 546-554.";
        string = string + "<br><p>Dudoit, S., Y.H. Yang, M.J. Callow, and T. Speed (2000).";
        string = string + "Statistical methods for identifying differentially expressed genes ";
        string = string + "in replicated cDNA microarray experiments. <i>Technical report 2000</i> ";
        string = string + "Statistics Department, University of California, Berkeley.";
        string = string + "<br><p>Welch, B.L. (1947).";
        string = string + "The generalization of \u2018students\u2019 problem when several different population variances are involved. ";
        string = string + "<i>Biometrika</i> 34: 28-35.";
        string = string + "<br><p>Korn, E.L., J.F. Troendle, L.M. McShane, R. Simon (2001).";
        string = string + "Controlling the number of false discoveries: application to high-dimensional genomic data ";
        string = string + "<i> Technical report 003</i>, Biometric Research Branch, National Cancer Institute. http://linus.nci.nih.gov/~brb/TechReport.htm";
        string = string + "<br><p>Korn, E.L., J.F. Troendle, L.M. McShane, R. Simon (2004).";
        string = string + "Controlling the number of false discoveries: application to high-dimensional genomic data ";
        string = string + "<i>Journal of Statistical Planning and Inference</i> 124: 379-398.";
        string = string + "<br><p><font size = +1><b>TFA</b></font> - ";
        string = string + "<b>Two Factor ANOVA</b>";
        string = string + "<br>Keppel, G., and S. Zedeck. (1989). Data Analysis for Research Designs. W. H. Freeman and Co., NY.";
        string = string + "<br><p>Manly, B.F.J. (1997). Randomization, Bootstrap and Monte Carlo Methods in Biology. 2nd ed. Chapman and Hall / CRC , FL.";
        string = string + "<br><p>Zar, J.H. 1999. Biostatistical Analysis. 4th ed. Prentice Hall, NJ.";
        string = string + "<br><p><font size = +1><b>SVM</b></font> - ";
        string = string + "<b>Support Vector Machines</b>";
        string = string + "<br>Brown, M.P., W.N. Grundy, D. Lin, N. Cristianini, C.W. Sugnet, ";
        string = string + "T.S. Furey, M. Ares, Jr., and D. Haussler (2000) ";
        string = string + "Knowledge-based analysis of microarray gene expression data by using support vector machines. ";
        string = string + "<i>Proceedings of the National Academy of Sciences USA</i> 97: 262-267.";
        string = string + "<br><p><font size = +1><b>KNNC</b></font> - ";
        string = string + "<b>K-Nearest Neighbor Classification</b>";
        string = string + "<br>Theilhaber, J., Connolly, S. Roman-Roman, S. Bushnell, A. Jackson, K. Call, T. Garcia, R. Baron (2002) ";
        string = string + "Finding Genes in the C2Cl2 Osteogenic Pathway by K-Nearest-Neighbor Classification of Expression Data.";
        string = string + "<i>Genome Research</i> 12:165-176";
        string = string + "<br><p><font size = +1><b>DAM</b></font> - ";
        string = string + "<b>Discriminant Analysis Module</b>";
        string = string + "<br>Nguyen, D.V., D.M. Rocke.";
        string = string + "Multi-class Cancer Classification via Partial Least Squares with Gene Expression Profiles.";
        string = string + "<i>Bioinformatics</i> 18(9):1216-1226, 2002";
        string = string + "<br><p><font size = +1><b>TRN</b></font> - ";
        string = string + "<b>Expression Terrain Maps</b>";
        string = string + "<br>Kim, S.K., J. Lund, M. Kiraly, K. Duke, M. Jiang, J.M. Stuart, A. Eizinger,";
        string = string + "B.N. Wylie, and G.S. Davidson (2001) ";
        string = string + "A Gene Expression Map for Caenorhabditis elegans. ";
        string = string + "<i>Science</i> 293: 2087-2092.";
        string = string + "<br><p><font size = +1><b>EASE</b></font> - ";
        string = string + "<b>Expression Analysis Systematic Explorer</b>";
        string = string + "<br>Hosack, D.A., G. Dennis Jr., B.T. Sherman, H.C. Lane, R.A. Lempicki. (2001)";
        string = string + "Identifying biological themes within lists of genes with EASE.";
        string = string + "<i>Genome Biol.</i> 4:R70-R70.8, 2003.";
        string = string + "</body></html>";
        return string;
    }

    public static void main(String[] stringArray) {
        PaperReferencesDialog paperReferencesDialog = new PaperReferencesDialog(new Frame(), PaperReferencesDialog.createReferencesText());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 2) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clip(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        graphics2D.translate(pageFormat.getImageableX(), (double)(-n) * pageFormat.getImageableHeight());
        graphics2D.scale(1.0, 1.0);
        graphics2D.drawString("Test String", 0, 20);
        this.ed.paint(graphics);
        return 0;
    }

    private Book makeBook(PageFormat pageFormat, int n) {
        Book book = new Book();
        book.append(this, pageFormat, n);
        return book;
    }

    private class EventListener
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close-command")) {
                PaperReferencesDialog.this.dispose();
            } else if (string.equals("print-command")) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(PaperReferencesDialog.this, printerJob.defaultPage());
                int n = PaperReferencesDialog.this.ed.getHeight();
                n = (int)((double)n / printerJob.defaultPage().getImageableY());
                printerJob.setPageable(PaperReferencesDialog.this.makeBook(printerJob.defaultPage(), n));
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                PaperReferencesDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

