/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.action.DefaultAction;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;

public class MultipleArrayMenubar
extends JMenuBar {
    private DisplayMenu displayMenu = new DisplayMenu();
    private DistanceMenu distanceMenu = new DistanceMenu();
    private JMenu normalizationMenu;
    private JMenu labelMenu;
    private JMenu expLabelSelectionMenu;
    private JMenu adjustMenu;
    private JMenu filterMenu;
    private ButtonGroup labelGroup;
    private ActionListener listener;
    private boolean affyNormAdded = false;
    private ButtonGroup experimentLabelGroup;
    private ActionManager actionManager;

    public MultipleArrayMenubar(ActionManager actionManager) {
        this.listener = actionManager.getListener();
        this.actionManager = actionManager;
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-load")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-load-analysis")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-save-analysis")));
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-save-analysis-as")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-new-script")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-load-script")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-save-matrix")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-save-image")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-print-image")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-close")));
        this.add(jMenu);
        this.adjustMenu = new JMenu("Adjust Data");
        JMenu jMenu2 = new JMenu("Gene/Row Adjustments");
        jMenu2.add(this.createJMenuItem("Normalize Genes/Rows", "normalize-spots-cmd", this.listener));
        jMenu2.add(this.createJMenuItem("Divide Genes/Rows by RMS", "divide-spots-rms-cmd", this.listener));
        jMenu2.add(this.createJMenuItem("Divide Genes/Rows by SD", "divide-spots-sd-cmd", this.listener));
        jMenu2.add(this.createJMenuItem("Mean Center Genes/Rows", "mean-center-spots-cmd", this.listener));
        jMenu2.add(this.createJMenuItem("Median Center Genes/Rows", "median-center-spots-cmd", this.listener));
        jMenu2.add(this.createJMenuItem("Digitalize Genes/Rows", "digital-spots-cmd", this.listener));
        this.adjustMenu.add(jMenu2);
        this.adjustMenu.addSeparator();
        JMenu jMenu3 = new JMenu("Sample/Column Adjustments");
        jMenu3.add(this.createJMenuItem("Normalize Samples/Columns", "normalize-experiments-cmd", this.listener));
        jMenu3.add(this.createJMenuItem("Divide Samples/Columns by RMS", "divide-experiments-rms-cmd", this.listener));
        jMenu3.add(this.createJMenuItem("Divide Samples/Columns by SD", "divide-experiments-sd-cmd", this.listener));
        jMenu3.add(this.createJMenuItem("Mean Center Samples/Columns", "mean-center-experiments-cmd", this.listener));
        jMenu3.add(this.createJMenuItem("Median Center Samples/Columns", "median-center-experiments-cmd", this.listener));
        jMenu3.add(this.createJMenuItem("Digitalize Samples/Columns", "digital-experiments-cmd", this.listener));
        this.adjustMenu.add(jMenu3);
        this.adjustMenu.addSeparator();
        JMenu jMenu4 = new JMenu("Log Transformations");
        jMenu4.add(this.createJMenuItem("Log2 Transform", "log2-transform-cmd", this.listener));
        jMenu4.add(this.createJMenuItem("Log10 to Log2", "log10-to-log2-cmd", this.listener));
        this.adjustMenu.add(jMenu4);
        this.adjustMenu.addSeparator();
        this.filterMenu = new JMenu("Data Filters");
        this.filterMenu.add(this.createJMenuItem("Low Intensity Cutoff Filter", "use-lower-cutoffs-cmd", this.listener));
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Percentage Cutoff Filter", "use-percentage-cutoffs-cmd", this.listener));
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Variance Filter", "use-variance-filter-cmd", this.listener));
        this.adjustMenu.add(this.filterMenu);
        this.adjustMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.normalizationMenu = new JMenu("Normalization");
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Total Intensity", "total-intensity-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Linear Regression", "linear-regression-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Ratio Statistics", "ratio-statistics-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Iterative Log", "iterative-log-cmd", this.listener, buttonGroup));
        this.normalizationMenu.addSeparator();
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("No Normalization", "no-normalization-cmd", this.listener, buttonGroup, true));
        this.adjustMenu.add(this.normalizationMenu);
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Adjust Intensities of '0'", "adjust-intensities-0-cmd", this.listener, true));
        this.add(this.adjustMenu);
        buttonGroup = new ButtonGroup();
        JMenu jMenu5 = new JMenu("Metrics");
        jMenu5.add(this.createJRadioButtonMenuItem("Default Distance", "default-distance-cmd", this.listener, buttonGroup, true));
        jMenu5.addSeparator();
        jMenu5.add(this.createJRadioButtonMenuItem("Euclidean Distance", "euclidean-distance-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Manhattan Distance", "manhattan-distance-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Average Dot Product", "average-dot-product-cmd", this.listener, buttonGroup));
        jMenu5.addSeparator();
        jMenu5.add(this.createJRadioButtonMenuItem("Pearson Correlation", "pearson-correlation-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Pearson Uncentered", "pearson-uncentered-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Pearson Squared", "pearson-squared-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Cosine Correlation", "cosine-correlation-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Covariance Value", "covariance-value-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Spearman Rank Correlation", "spearman-rank-correlation-cmd", this.listener, buttonGroup));
        jMenu5.addSeparator();
        jMenu5.add(this.createJRadioButtonMenuItem("Kendall's Tau", "kendalls-tau-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Mutual Information", "mutual-information-cmd", this.listener, buttonGroup));
        jMenu5.addSeparator();
        jMenu5.add(this.createJCheckBoxMenuItem("Absolute distance", "absolute-distance-cmd", this.listener, false));
        this.add(jMenu5);
        JMenu jMenu6 = new JMenu("Analysis");
        this.addAnalysisMenu(jMenu6, actionManager);
        this.add(jMenu6);
        JMenu jMenu7 = new JMenu("Display");
        JMenu jMenu8 = new JMenu("Sample/Column Labels");
        this.expLabelSelectionMenu = new JMenu("Select Sample Label");
        jMenu8.add(this.expLabelSelectionMenu);
        jMenu8.addSeparator();
        jMenu8.add(this.createJMenuItem("Edit Labels/Reorder Samples", "add-new-experiment-label", this.listener));
        jMenu8.add(this.createJMenuItem("Abbr. Sample Names", "toggle-abbr-expt-names-cmd", this.listener));
        this.experimentLabelGroup = new ButtonGroup();
        jMenu7.add(jMenu8);
        this.labelMenu = new JMenu("Gene/Row Labels");
        this.labelGroup = new ButtonGroup();
        jMenu7.add(this.labelMenu);
        jMenu7.addSeparator();
        JMenu jMenu9 = new JMenu("Color Scheme");
        jMenu9.add(this.createJMenuItem("Green-Black-Red Scheme", "display-green-red-scheme-cmd", this.listener));
        jMenu9.add(this.createJMenuItem("Blue-Black-Yellow Scheme", "display-blue-yellow-scheme-cmd", this.listener));
        jMenu9.add(this.createJMenuItem("Rainbow Scheme", "display-rainbow-scheme-cmd", this.listener));
        jMenu9.addSeparator();
        jMenu9.add(this.createJMenuItem("Custom Color Scheme", "display-custom-color-scheme-cmd", this.listener));
        jMenu9.addSeparator();
        jMenu9.add(this.createJCheckBoxMenuItem("Use Color Gradient on Graphs", "display-color-gradient-cmd", this.listener));
        jMenu7.add(jMenu9);
        jMenu7.add(this.createJMenuItem("Set Color Scale Limits", "display-set-ratio-scale-cmd", this.listener));
        jMenu7.addSeparator();
        JMenu jMenu10 = new JMenu("Set Element Size");
        buttonGroup = new ButtonGroup();
        jMenu10.add(this.createJRadioButtonMenuItem("5 x 2", "display-5x2-cmd", this.listener, buttonGroup));
        jMenu10.add(this.createJRadioButtonMenuItem("10 x 10", "display-10x10-cmd", this.listener, buttonGroup));
        jMenu10.add(this.createJRadioButtonMenuItem("20 x 5", "display-20x5-cmd", this.listener, buttonGroup, true));
        jMenu10.add(this.createJRadioButtonMenuItem("50 x 10", "display-50x10-cmd", this.listener, buttonGroup));
        jMenu10.add(this.createJRadioButtonMenuItem("Custom", "display-other-cmd", this.listener, buttonGroup));
        jMenu7.add(jMenu10);
        jMenu7.add(this.createJCheckBoxMenuItem("Draw Borders", "display-draw-borders-cmd", this.listener, false));
        this.add(jMenu7);
        JMenu jMenu11 = new JMenu("Utilities");
        jMenu11.add(this.createJMenuItem(actionManager.getAction("search-action")));
        jMenu11.addSeparator();
        JMenu jMenu12 = new JMenu("Cluster Utilities");
        JMenu jMenu13 = new JMenu("Import Cluster");
        jMenu13.add(actionManager.getAction("import-gene-list-action"));
        jMenu13.add(actionManager.getAction("import-sample-list-action"));
        jMenu12.add(jMenu13);
        jMenu12.addSeparator();
        jMenu12.add(actionManager.getAction("delete-all-action"));
        jMenu12.add(actionManager.getAction("delete-all-experiments-action"));
        jMenu11.add(jMenu12);
        jMenu11.addSeparator();
        jMenu11.add(actionManager.getAction("append-gene-annotation-action"));
        jMenu11.add(actionManager.getAction("append-sample-annotation-action"));
        this.add(jMenu11);
    }

    public MultipleArrayMenubar(MultipleArrayMenubar multipleArrayMenubar, ActionManager actionManager) {
        this(actionManager);
        IDisplayMenu iDisplayMenu = multipleArrayMenubar.getDisplayMenu();
        this.setColorSchemeIndex(iDisplayMenu.getColorScheme());
        Dimension dimension = iDisplayMenu.getElementSize();
        this.setElementSize(dimension.width, dimension.height);
        this.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.setTracing(iDisplayMenu.isTracing());
        this.setLabelIndex(iDisplayMenu.getLabelIndex());
        this.setPaletteStyle(iDisplayMenu.getPaletteStyle());
        this.setGRScale(iDisplayMenu.isGRScale());
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.setMaxRatioScale(iDisplayMenu.getMaxRatioScale());
        this.setMinRatioScale(iDisplayMenu.getMinRatioScale());
        this.setMidRatioValue(iDisplayMenu.getMidRatioValue());
        this.setColorGradientState(iDisplayMenu.getColorGradientState());
        this.setNegativeCustomGradient(iDisplayMenu.getNegativeGradientImage());
        this.setPositiveCustomGradient(iDisplayMenu.getPositiveGradientImage());
        this.setUseDoubleGradient(iDisplayMenu.getUseDoubleGradient());
        IDistanceMenu iDistanceMenu = multipleArrayMenubar.getDistanceMenu();
        this.setDistanceAbsolute(iDistanceMenu.isAbsoluteDistance());
        this.setDistanceFunction(iDistanceMenu.getDistanceFunction());
    }

    public void synchronizeSettings(MultipleArrayMenubar multipleArrayMenubar) {
        JMenu jMenu = multipleArrayMenubar.getMenu(2);
        JMenu jMenu2 = this.getMenu(2);
        for (int i = 0; i < jMenu2.getMenuComponentCount(); ++i) {
            Component component = jMenu2.getMenuComponent(i);
            Component component2 = jMenu.getMenuComponent(i);
            if (component2 instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)component).setSelected(((JRadioButtonMenuItem)component2).isSelected());
                continue;
            }
            if (!(component2 instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)component).setSelected(((JCheckBoxMenuItem)component2).isSelected());
        }
        jMenu = multipleArrayMenubar.getMenu(4);
        jMenu2 = this.getMenu(4);
        int n = jMenu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            Component component3 = jMenu2.getMenuComponent(i);
            if (component instanceof JMenu) {
                this.syncMenus((JMenu)component, (JMenu)component3);
                continue;
            }
            if (component instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)component3).setSelected(((JRadioButtonMenuItem)component).isSelected());
                continue;
            }
            if (!(component instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)component3).setSelected(((JCheckBoxMenuItem)component).isSelected());
        }
    }

    private void syncMenus(JMenu jMenu, JMenu jMenu2) {
        for (int i = 0; i < jMenu2.getMenuComponentCount(); ++i) {
            Component component = jMenu2.getMenuComponent(i);
            Component component2 = jMenu.getMenuComponent(i);
            if (component2 instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)component).setSelected(((JRadioButtonMenuItem)component2).isSelected());
                continue;
            }
            if (component2 instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)component).setSelected(((JCheckBoxMenuItem)component2).isSelected());
                continue;
            }
            if (!(component2 instanceof JMenu)) continue;
            this.syncMenus((JMenu)component2, (JMenu)component);
        }
    }

    public void systemEnable(int n) {
        switch (n) {
            case 1000: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-stanford", true);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", false);
                this.setEnableMenuItem("File", "command-new-script", false);
                this.setEnableMenuItem("File", "command-load-script", false);
                break;
            }
            case 1003: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", true);
                this.setEnableMenuItem("File", "command-save-matrix", true);
                this.setEnableMenuItem("File", "command-save-image", true);
                this.setEnableMenuItem("File", "command-new-script", true);
                this.setEnableMenuItem("File", "command-load-script", true);
                this.setEnableMenuItem("File", "command-print-image", true);
                this.setEnableMenu("Adjust Data", true);
                this.setEnableMenu("Normalization", true);
                this.setEnableMenu("Metrics", true);
                this.setEnableMenu("Utilities", true);
                this.setEnableMenu("Analysis", true);
                this.setEnableMenu("Display", true);
                this.setEnableMenu("Sort", true);
                break;
            }
            case 101: {
                this.setEnableMenuItem("File", "command-save-analysis", true);
                this.setEnableMenuItem("File", "command-save-analysis-as", true);
            }
            case 1001: {
                break;
            }
            case 1002: {
                this.setEnableMenuItem("File", "command-load-db", true);
            }
        }
    }

    public void systemDisable(int n) {
        switch (n) {
            case 1000: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
                this.setEnableMenuItem("File", "command-load-file", false);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", false);
                this.setEnableMenuItem("File", "command-new-script", false);
                this.setEnableMenuItem("File", "command-load-script", false);
                this.setEnableMenuItem("File", "command-load-directory", false);
                this.setEnableMenuItem("File", "command-load-stanford", false);
                break;
            }
            case 1003: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-save-analysis", false);
                this.setEnableMenuItem("File", "command-save-analysis-as", false);
                this.setEnableMenuItem("File", "command-new-script", false);
                this.setEnableMenuItem("File", "command-load-script", false);
                this.setEnableMenuItem("File", "command-save-matrix", false);
                this.setEnableMenuItem("File", "command-save-image", false);
                this.setEnableMenuItem("File", "command-print-image", false);
                this.setEnableMenu("Adjust Data", false);
                this.setEnableMenu("Normalization", false);
                this.setEnableMenu("Metrics", false);
                this.setEnableMenu("Utilities", false);
                break;
            }
            case 1001: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
                break;
            }
            case 1002: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
            }
        }
        this.setEnableMenu("Analysis", false);
        this.setEnableMenu("Display", false);
        this.setEnableMenu("Sort", false);
    }

    public void enableNormalizationMenu(boolean bl) {
        this.normalizationMenu.setEnabled(bl);
    }

    private void addLabelMenuItems(JMenu jMenu, ActionManager actionManager, ButtonGroup buttonGroup) {
        Action action;
        int n = -1;
        while ((action = actionManager.getAction("display--label-action" + String.valueOf(n))) != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            buttonGroup.add(jRadioButtonMenuItem);
            if (n < 1) {
                jRadioButtonMenuItem.setSelected(true);
                String string = (String)action.getValue("command-parameter");
                this.displayMenu.labelIndex = Integer.parseInt(string);
            }
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
    }

    public void addLabelMenuItems(String[] stringArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultAction defaultAction = new DefaultAction(this.actionManager, "Label by " + stringArray[i], "display-label-cmd");
            defaultAction.putValue("command-parameter", String.valueOf(i));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
            this.labelGroup.add(jRadioButtonMenuItem);
            if (i == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            this.labelMenu.add(jRadioButtonMenuItem);
        }
    }

    public void addExperimentLabelMenuItems(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            DefaultAction defaultAction = new DefaultAction(this.actionManager, "Label by " + (String)vector.elementAt(i), "display-experiment-label-cmd");
            defaultAction.putValue("command-parameter", (String)vector.elementAt(i));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
            this.experimentLabelGroup.add(jRadioButtonMenuItem);
            if (i == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            this.expLabelSelectionMenu.add(jRadioButtonMenuItem);
        }
    }

    public void addNewExperimentLabelMenuItem(String string) {
        DefaultAction defaultAction = new DefaultAction(this.actionManager, "Label by " + string, "display-experiment-label-cmd");
        defaultAction.putValue("command-parameter", string);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
        this.experimentLabelGroup.add(jRadioButtonMenuItem);
        this.expLabelSelectionMenu.add(jRadioButtonMenuItem);
    }

    public void replaceExperimentLabelMenuItems(String[] stringArray) {
        this.expLabelSelectionMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "Label by " + stringArray[i];
            DefaultAction defaultAction = new DefaultAction(this.actionManager, string, "display-experiment-label-cmd");
            defaultAction.putValue("command-parameter", stringArray[i]);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
            this.experimentLabelGroup.add(jRadioButtonMenuItem);
            this.expLabelSelectionMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(false);
            if (i != 0) continue;
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    public void replaceLabelMenuItems(String[] stringArray) {
        this.labelMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultAction defaultAction = new DefaultAction(this.actionManager, "Label by " + stringArray[i], "display-label-cmd");
            defaultAction.putValue("command-parameter", String.valueOf(i));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
            this.labelGroup.add(jRadioButtonMenuItem);
            if (i == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            this.labelMenu.add(jRadioButtonMenuItem);
        }
    }

    public void addAffyFilterMenuItems() {
        this.filterMenu.addSeparator();
        this.filterMenu.add(this.createJMenuItem("Set Detection Filter", "set-detection-filter-cmd", this.listener));
        this.filterMenu.add(this.createJCheckBoxMenuItem("Use Detection Filter", "use-detection-filter-cmd", this.listener));
        this.filterMenu.add(this.createJMenuItem("Set Fold Filter", "set-fold-filter-cmd", this.listener));
        this.filterMenu.add(this.createJCheckBoxMenuItem("Use Fold Filter", "use-fold-filter-cmd", this.listener));
    }

    public void addAffyNormMenuItems() {
        this.adjustMenu.addSeparator();
        JMenu jMenu = new JMenu("Affymetrix Adjustments");
        jMenu.add(this.createJMenuItem("Divide Genes by Median", "divide-genes-median-cmd", this.listener));
        jMenu.add(this.createJMenuItem("Divide Genes by Mean", "divide-genes-mean-cmd", this.listener));
        this.adjustMenu.add(jMenu);
        this.set_affyNormAddded(true);
    }

    private void addSortMenuItems(JMenu jMenu, ActionManager actionManager, ButtonGroup buttonGroup) {
        Action action;
        int n = 0;
        while ((action = actionManager.getAction("sort-label-action" + String.valueOf(n))) != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
    }

    public void addSortMenuItems(String[] stringArray) {
    }

    public void replaceSortMenuItems(String[] stringArray) {
    }

    private void addAnalysisMenu(JMenu jMenu, ActionManager actionManager) {
        Action action;
        int n = 0;
        while ((action = actionManager.getAction("analysis-action" + String.valueOf(n))) != null) {
            jMenu.add(this.createJMenuItem(action));
            ++n;
        }
    }

    public IDisplayMenu getDisplayMenu() {
        return this.displayMenu;
    }

    public IDistanceMenu getDistanceMenu() {
        return this.distanceMenu;
    }

    private JMenuItem createJMenuItem(Action action) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setActionCommand((String)action.getValue("ActionCommandKey"));
        return jMenuItem;
    }

    private JMenuItem createJMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2, ActionListener actionListener, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.setActionCommand(string2);
        jCheckBoxMenuItem.addActionListener(actionListener);
        jCheckBoxMenuItem.setSelected(bl);
        return jCheckBoxMenuItem;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2, ActionListener actionListener) {
        return this.createJCheckBoxMenuItem(string, string2, actionListener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2, ActionListener actionListener, ButtonGroup buttonGroup, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setSelected(bl);
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jRadioButtonMenuItem;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2, ActionListener actionListener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(string, string2, actionListener, buttonGroup, false);
    }

    private JMenu getJMenu(String string) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu jMenu = this.getMenu(i);
            if (jMenu == null || !jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    private JMenuItem getJMenuItem(String string, String string2) {
        JMenu jMenu = this.getJMenu(string);
        if (jMenu == null) {
            return null;
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getActionCommand().equals(string2)) continue;
            return jMenuItem;
        }
        return null;
    }

    private void setEnableMenu(String string, boolean bl) {
        JMenu jMenu = this.getJMenu(string);
        if (jMenu == null) {
            return;
        }
        jMenu.setEnabled(bl);
    }

    private void setEnableMenuItem(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string, string2);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    boolean get_affyNormAdded() {
        return this.affyNormAdded;
    }

    void set_affyNormAddded(boolean bl) {
        this.affyNormAdded = bl;
    }

    void setLabelIndex(int n) {
        this.displayMenu.labelIndex = n;
    }

    void setElementSize(int n, int n2) {
        this.displayMenu.elementSize.setSize(n, n2);
    }

    void setPaletteStyle(int n) {
        this.displayMenu.paletteStyle = n;
    }

    void setTracing(boolean bl) {
        this.displayMenu.tracing = bl;
    }

    void setDrawBorders(boolean bl) {
        this.displayMenu.drawBorders = bl;
    }

    void setAntiAliasing(boolean bl) {
        this.displayMenu.antialiasing = bl;
    }

    void setGRScale(boolean bl) {
        this.displayMenu.grscale = bl;
    }

    void setDistanceAbsolute(boolean bl) {
        this.distanceMenu.absolute = bl;
    }

    void setDistanceFunction(int n) {
        this.distanceMenu.function = n;
    }

    void setMinRatioScale(float f) {
        this.displayMenu.minRatioScale = f;
    }

    void setMaxRatioScale(float f) {
        this.displayMenu.maxRatioScale = f;
    }

    void setMidRatioValue(float f) {
        this.displayMenu.midRatioValue = f;
    }

    void setMaxCY3Scale(float f) {
        this.displayMenu.maxCY3Scale = f;
    }

    void setMaxCY5Scale(float f) {
        this.displayMenu.maxCY5Scale = f;
    }

    void setPositiveCustomGradient(BufferedImage bufferedImage) {
        this.displayMenu.posCustomColorImage = bufferedImage;
    }

    void setNegativeCustomGradient(BufferedImage bufferedImage) {
        this.displayMenu.negCustomColorImage = bufferedImage;
    }

    void setColorSchemeIndex(int n) {
        this.displayMenu.colorScheme = n;
    }

    int getColorScheme() {
        return this.displayMenu.getColorScheme();
    }

    public BufferedImage getPositiveGradientImage() {
        return this.displayMenu.getPositiveGradientImage();
    }

    public BufferedImage getNegativeGradientImage() {
        return this.displayMenu.getNegativeGradientImage();
    }

    public boolean getColorGradientState() {
        return this.displayMenu.getColorGradientState();
    }

    public void setColorGradientState(boolean bl) {
        this.displayMenu.setColorGradientState(bl);
    }

    public void setNormalizedButtonState(int n) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.normalizationMenu.getMenuComponent(n);
        jRadioButtonMenuItem.setSelected(true);
    }

    public void setUseDoubleGradient(boolean bl) {
        this.displayMenu.setUseDoubleGradient(bl);
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private class DistanceMenu
    implements IDistanceMenu {
        private boolean absolute = false;
        private int function = 0;

        private DistanceMenu() {
        }

        public boolean isAbsoluteDistance() {
            return this.absolute;
        }

        public int getDistanceFunction() {
            return this.function;
        }

        public String getFunctionName(int n) {
            String string;
            switch (n) {
                case 1: {
                    string = "Pearson Correlation";
                    break;
                }
                case 2: {
                    string = "Cosine Correlation";
                    break;
                }
                case 3: {
                    string = "Covariance";
                    break;
                }
                case 4: {
                    string = "Euclidean Distance";
                    break;
                }
                case 5: {
                    string = "Average Dot Product";
                    break;
                }
                case 6: {
                    string = "Pearson Uncentered";
                    break;
                }
                case 7: {
                    string = "Pearson Squared";
                    break;
                }
                case 8: {
                    string = "Manhattan Distance";
                    break;
                }
                case 9: {
                    string = "Spearman Rank Correlation";
                    break;
                }
                case 10: {
                    string = "Kendall's Tau";
                    break;
                }
                case 11: {
                    string = "Mutual Information";
                    break;
                }
                default: {
                    string = "not defined";
                }
            }
            return string;
        }
    }

    private class DisplayMenu
    implements IDisplayMenu {
        private final Dimension elementSize = new Dimension(20, 5);
        private int labelIndex;
        private int paletteStyle = 4;
        private boolean tracing = false;
        private boolean drawBorders = false;
        private boolean antialiasing = true;
        private boolean grscale = true;
        private boolean useColorGradient = false;
        private float minRatioScale = -3.0f;
        private float maxRatioScale = 3.0f;
        private float midRatioValue = 0.0f;
        private float maxCY3Scale = 0.0f;
        private float maxCY5Scale = 0.0f;
        private int colorScheme = 5;
        private BufferedImage negGreenColorImage = this.createGradientImage(Color.green, Color.black);
        private BufferedImage posRedColorImage = this.createGradientImage(Color.black, Color.red);
        private BufferedImage negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
        private BufferedImage posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
        private BufferedImage rainbowImage = this.createRainbowImage();
        private BufferedImage negCustomColorImage;
        private BufferedImage posCustomColorImage;
        private boolean useDoubleGradient = true;

        private DisplayMenu() {
        }

        public int getPaletteStyle() {
            return this.paletteStyle;
        }

        public boolean isGRScale() {
            return this.grscale;
        }

        public Dimension getElementSize() {
            return this.elementSize;
        }

        public boolean getUseDoubleGradient() {
            return this.useDoubleGradient;
        }

        public void setUseDoubleGradient(boolean bl) {
            this.useDoubleGradient = bl;
        }

        public boolean isDrawingBorder() {
            return this.drawBorders;
        }

        public boolean isTracing() {
            return this.tracing;
        }

        public boolean isAntiAliasing() {
            return this.antialiasing;
        }

        public int getLabelIndex() {
            return this.labelIndex;
        }

        public float getMaxRatioScale() {
            return this.maxRatioScale;
        }

        public float getMinRatioScale() {
            return this.minRatioScale;
        }

        public float getMidRatioValue() {
            return this.midRatioValue;
        }

        public float getMaxCY3Scale() {
            return this.maxCY3Scale;
        }

        public float getMaxCY5Scale() {
            return this.maxCY5Scale;
        }

        public int getColorScheme() {
            return this.colorScheme;
        }

        public BufferedImage getPositiveGradientImage() {
            BufferedImage bufferedImage = this.posRedColorImage;
            switch (this.colorScheme) {
                case 5: {
                    break;
                }
                case 6: {
                    bufferedImage = this.posYellowColorImage;
                    break;
                }
                case 7: {
                    if (this.posCustomColorImage == null) break;
                    bufferedImage = this.posCustomColorImage;
                    break;
                }
                case 8: {
                    bufferedImage = this.rainbowImage;
                }
            }
            return bufferedImage;
        }

        public BufferedImage getNegativeGradientImage() {
            BufferedImage bufferedImage = this.negGreenColorImage;
            switch (this.colorScheme) {
                case 5: {
                    break;
                }
                case 6: {
                    bufferedImage = this.negBlueColorImage;
                    break;
                }
                case 7: {
                    if (this.negCustomColorImage == null) break;
                    bufferedImage = this.negCustomColorImage;
                }
            }
            return bufferedImage;
        }

        public BufferedImage createGradientImage(Color color, Color color2) {
            BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawRect(0, 0, 255, 1);
            return bufferedImage;
        }

        public boolean getColorGradientState() {
            return this.useColorGradient;
        }

        public void setColorGradientState(boolean bl) {
            this.useColorGradient = bl;
        }

        private BufferedImage createRainbowImage() {
            Vector vector = this.buildPalette();
            BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.drawScale(graphics2D, vector);
            return bufferedImage;
        }

        private void drawScale(Graphics2D graphics2D, Vector vector) {
            for (int i = 0; i < vector.size(); ++i) {
                graphics2D.setColor((Color)vector.elementAt(i));
                graphics2D.fillRect(i, 0, 1, 1);
            }
        }

        private Vector buildPalette() {
            Vector<Color> vector = new Vector<Color>(256);
            Color color = new Color(0, 0, 0);
            vector.addElement(color);
            for (int i = 1; i < 256; ++i) {
                i = 255 - i;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                if (i < 33) {
                    d = 255.0;
                } else if (i > 32 && i < 108) {
                    d = Math.abs(255.0 * Math.cos((double)(i - 32) * Math.PI / 151.0));
                } else if (i > 107) {
                    d = 0.0;
                }
                if (i < 5) {
                    d2 = 0.0;
                } else if (i > 4 && i < 101) {
                    d2 = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 189.0));
                } else if (i > 100 && i < 229) {
                    d2 = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 294.0));
                } else if (i > 230) {
                    d2 = 0.0;
                }
                if (i < 72) {
                    d3 = 0.0;
                } else if (i > 71 && i < 200) {
                    d3 = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 256.0));
                } else if (i > 199) {
                    d3 = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 175.0));
                }
                color = new Color((float)d / 255.0f, (float)d2 / 255.0f, (float)d3 / 255.0f);
                vector.addElement(color);
                i = 255 - i;
            }
            return vector;
        }
    }
}

