/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.AcknowlegementDialog;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.DatabaseLoginDialog;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.InfoDisplay;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.MevCitationDialog;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.PaperReferencesDialog;
import org.tigr.microarray.mev.SetDatabaseDialog;
import org.tigr.microarray.mev.SingleArrayViewer;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.Query;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.ImageScreen;
import org.tigr.util.awt.MessageDisplay;

public class Manager {
    private static Vector activeComponents;
    private JFrame frame;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newMultipleArrayViewerItem;
    private JMenuItem newSingleArrayViewerItem;
    private JMenuItem newPreferencesItem;
    private JMenuItem loginItem;
    private JMenuItem quitItem;
    private JMenu displayMenu;
    private JRadioButtonMenuItem javaLFItem;
    private JRadioButtonMenuItem windowsLFItem;
    private JRadioButtonMenuItem motifLFItem;
    private JCheckBoxMenuItem toolTipsItem;
    private static JMenu windowMenu;
    private JMenu referencesMenu;
    private JMenuItem systemInfoItem;
    private JMenuItem acknolMenuItem;
    private JMenuItem papersMenuItem;
    private JMenuItem citationMenuItem;
    private JMenuItem aboutMenuItem;
    private ButtonGroup buttonGroup;
    private static EventListener eventListener;
    static /* synthetic */ Class class$org$tigr$microarray$mev$SingleArrayViewer;

    public Manager() {
        try {
            activeComponents = new Vector();
            eventListener = new EventListener();
            this.initializeFrame();
            this.initializeInput();
        }
        catch (Exception exception) {
            System.out.println("Exception (Manager.const()): " + exception);
            exception.printStackTrace();
        }
    }

    public void initializeFrame() {
        this.frame = new JFrame("TIGR MultiExperiment Viewer");
        this.frame.addWindowListener(eventListener);
        this.initializeMenuBar(this.frame);
        this.frame.setSize(this.frame.getPreferredSize());
        this.frame.setResizable(false);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void initializeMenuBar(JFrame jFrame) {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.newMultipleArrayViewerItem = new JMenuItem("New Multiple Array Viewer");
        this.newMultipleArrayViewerItem.addActionListener(eventListener);
        this.newMultipleArrayViewerItem.setMnemonic(77);
        this.fileMenu.add(this.newMultipleArrayViewerItem);
        this.newSingleArrayViewerItem = new JMenuItem("New Single Array Viewer");
        this.newSingleArrayViewerItem.addActionListener(eventListener);
        this.newSingleArrayViewerItem.setMnemonic(83);
        this.fileMenu.add(this.newSingleArrayViewerItem);
        this.fileMenu.addSeparator();
        this.quitItem = new JMenuItem("Quit");
        this.quitItem.addActionListener(eventListener);
        this.quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.fileMenu.add(this.quitItem);
        this.menuBar.add(this.fileMenu);
        this.displayMenu = new JMenu("Display");
        this.buttonGroup = new ButtonGroup();
        this.javaLFItem = new JRadioButtonMenuItem("Metal L&F");
        this.javaLFItem.addActionListener(eventListener);
        this.displayMenu.add(this.javaLFItem);
        this.buttonGroup.add(this.javaLFItem);
        this.javaLFItem.setSelected(true);
        this.windowsLFItem = new JRadioButtonMenuItem("Windows L&F");
        this.windowsLFItem.addActionListener(eventListener);
        this.displayMenu.add(this.windowsLFItem);
        this.buttonGroup.add(this.windowsLFItem);
        this.motifLFItem = new JRadioButtonMenuItem("Motif L&F");
        this.motifLFItem.addActionListener(eventListener);
        this.displayMenu.add(this.motifLFItem);
        this.buttonGroup.add(this.motifLFItem);
        this.toolTipsItem = new JCheckBoxMenuItem("Show ToolTips");
        this.toolTipsItem.addActionListener(eventListener);
        this.displayMenu.add(this.toolTipsItem);
        this.toolTipsItem.setSelected(true);
        this.menuBar.add(this.displayMenu);
        windowMenu = new JMenu("Window");
        windowMenu.setEnabled(false);
        windowMenu.addActionListener(eventListener);
        this.menuBar.add(windowMenu);
        this.referencesMenu = new JMenu("References");
        this.acknolMenuItem = new JMenuItem("Contributions...");
        this.acknolMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.acknolMenuItem);
        this.papersMenuItem = new JMenuItem("Papers / Publications");
        this.papersMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.papersMenuItem);
        this.citationMenuItem = new JMenuItem("Referencing TMeV...");
        this.citationMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.citationMenuItem);
        this.referencesMenu.addSeparator();
        this.systemInfoItem = new JMenuItem("System Info");
        this.systemInfoItem.addActionListener(eventListener);
        this.referencesMenu.add(this.systemInfoItem);
        this.referencesMenu.addSeparator();
        this.aboutMenuItem = new JMenuItem("About MeV");
        this.aboutMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.referencesMenu);
        jFrame.setJMenuBar(this.menuBar);
        this.menuBar.setPreferredSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize().width - 2, this.menuBar.getFontMetrics(this.menuBar.getFont()).getHeight() + 5));
    }

    public boolean selectPreferencesFile() {
        File file = null;
        String string = "";
        boolean bl = false;
        Dimension dimension = this.frame.getToolkit().getScreenSize();
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                if (file.getName().endsWith("Preferences")) {
                    return true;
                }
                if (file.getName().endsWith("preferences")) {
                    return true;
                }
                return file.getName().endsWith(".pref");
            }

            public String getDescription() {
                return "Preference Files";
            }
        });
        jFileChooser.setDialogTitle("Select Preferences File");
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setCurrentDirectory(TMEV.getFile("preferences/"));
        if (jFileChooser.showOpenDialog(this.frame) != 0) {
            System.out.println("No preference file selected");
            return false;
        }
        file = jFileChooser.getSelectedFile();
        if (TMEV.readPreferencesFile(file)) {
            System.out.println("Successfully read preferences file - " + file.getName());
            return true;
        }
        Manager.message(this.frame, "Error in preferences file: " + file.getName());
        TMEV.quit();
        return false;
    }

    public static void addComponent(Component component) {
        activeComponents.addElement(component);
        Manager.updateWindowMenu();
    }

    public static void updateWindowMenu() {
        windowMenu.removeAll();
        windowMenu.setEnabled(activeComponents.size() > 0);
        for (int i = 0; i < activeComponents.size(); ++i) {
            Component component = (Component)activeComponents.elementAt(i);
            JMenuItem jMenuItem = component instanceof SingleArrayViewer ? new JMenuItem(((SingleArrayViewer)component).getFrame().getTitle()) : new JMenuItem(((MultipleArrayViewer)component).getFrame().getTitle());
            jMenuItem.setActionCommand("window-cmd");
            jMenuItem.addActionListener(eventListener);
            windowMenu.add(jMenuItem);
        }
    }

    public static Component getComponent(int n) {
        return (Component)activeComponents.elementAt(n);
    }

    public static void removeComponent(Component component) {
        activeComponents.removeElement(component);
        Manager.updateWindowMenu();
    }

    public void initializeInput() {
        try {
            String string = "Only File";
            if (string.equals("Database")) {
                this.databaseLogin();
                this.systemEnable(1001);
                this.systemEnable(1002);
            } else if (string.equals("File")) {
                this.databaseLogin();
                this.systemEnable(1001);
                this.systemEnable(1002);
            } else if (!string.equals("Only File")) {
                Manager.message(this.frame, "Error: Invalid Preferences File");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception (TMEV.initializeInput()): " + exception);
        }
    }

    public static void createNewMultipleArrayViewer() {
        MultipleArrayViewer multipleArrayViewer = new MultipleArrayViewer();
        Manager.addComponent(multipleArrayViewer);
        TMEV.clearFieldNames();
        multipleArrayViewer.getFrame().setSize(1150, 700);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        multipleArrayViewer.getFrame().setLocation((dimension.width - multipleArrayViewer.getFrame().getSize().width) / 2, (dimension.height - multipleArrayViewer.getFrame().getSize().height) / 2);
        multipleArrayViewer.getFrame().setVisible(true);
    }

    public static void createNewMultipleArrayViewer(MultipleArrayData multipleArrayData, String string) {
        MultipleArrayViewer multipleArrayViewer = new MultipleArrayViewer(multipleArrayData);
        multipleArrayViewer.getFrame().setSize(1150, 700);
        if (string != null) {
            multipleArrayViewer.getFrame().setTitle("TIGR Multiple Array Viewer, " + string);
        }
        Manager.addComponent(multipleArrayViewer);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        multipleArrayViewer.getFrame().setLocation((dimension.width - multipleArrayViewer.getFrame().getSize().width) / 2, (dimension.height - multipleArrayViewer.getFrame().getSize().height) / 2);
        multipleArrayViewer.getFrame().setVisible(true);
    }

    public static void createNewMultipleArrayViewer(MultipleArrayMenubar multipleArrayMenubar, MultipleArrayData multipleArrayData, String string) {
        MultipleArrayViewer multipleArrayViewer = new MultipleArrayViewer(multipleArrayData, multipleArrayMenubar);
        multipleArrayViewer.getFrame().setSize(1150, 700);
        if (string != null) {
            multipleArrayViewer.getFrame().setTitle("TIGR Multiple Array Viewer, " + string);
        }
        Manager.addComponent(multipleArrayViewer);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        multipleArrayViewer.getFrame().setLocation((dimension.width - multipleArrayViewer.getFrame().getSize().width) / 2, (dimension.height - multipleArrayViewer.getFrame().getSize().height) / 2);
        multipleArrayViewer.getFrame().setVisible(true);
    }

    public static void createNewSingleArrayViewer() {
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(new JFrame("Single Array Viewer"));
        Manager.addComponent(singleArrayViewer);
        singleArrayViewer.systemEnable(1001);
        singleArrayViewer.systemEnable(1002);
        singleArrayViewer.getFrame().setSize(650, 650);
        singleArrayViewer.getFrame().setLocation(100, 100);
        singleArrayViewer.getFrame().setVisible(true);
    }

    public static void createNewSingleArrayViewer(ISlideData iSlideData) {
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(new JFrame("Single Array Viewer"), iSlideData);
        Manager.addComponent(singleArrayViewer);
        singleArrayViewer.getFrame().setSize(650, 650);
        singleArrayViewer.getFrame().setLocation(100, 100);
        singleArrayViewer.getFrame().setVisible(true);
        singleArrayViewer.refreshSlide();
    }

    public static void createNewSingleArrayViewer(ISlideData iSlideData, float f, float f2) {
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(new JFrame("Single Array Viewer"), iSlideData);
        Manager.addComponent(singleArrayViewer);
        singleArrayViewer.systemEnable(1001);
        singleArrayViewer.systemEnable(1002);
        singleArrayViewer.setUpperLimits(f, f2);
        singleArrayViewer.panel.setXYScrollbars((long)f, (long)f2);
        singleArrayViewer.getFrame().setSize(650, 650);
        singleArrayViewer.getFrame().setLocation(100, 100);
        singleArrayViewer.getFrame().setVisible(true);
        singleArrayViewer.refreshSlide();
    }

    public static void displaySlideElementInfo(JFrame jFrame, MultipleArrayData multipleArrayData, int n, int n2) {
        new InfoDisplay(jFrame, multipleArrayData, n, n2);
    }

    public static void displaySlideElementInfo(JFrame jFrame, ISlideData iSlideData, ISlideDataElement iSlideDataElement, int n) {
        new InfoDisplay(jFrame, iSlideData, iSlideDataElement, n);
    }

    public void systemDisable(int n) {
        switch (n) {
            case 1000: {
                break;
            }
            case 1003: {
                break;
            }
            case 1001: {
                break;
            }
        }
        for (int i = 0; i < activeComponents.size(); ++i) {
            ((ArrayViewer)activeComponents.elementAt(i)).systemDisable(n);
        }
    }

    public void systemEnable(int n) {
        switch (n) {
            case 1000: {
                break;
            }
            case 1003: {
                break;
            }
            case 1001: {
                break;
            }
        }
        for (int i = 0; i < activeComponents.size(); ++i) {
            ((ArrayViewer)activeComponents.elementAt(i)).systemEnable(n);
        }
    }

    public void databaseLogin() {
        DatabaseLoginDialog databaseLoginDialog = new DatabaseLoginDialog(this.frame);
        databaseLoginDialog.addActionInfoListener(new ActionInfoListener(){

            public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                Hashtable hashtable = actionInfoEvent.getHashtable();
                Manager.this.databaseLoad((String)hashtable.get("username"), (String)hashtable.get("password"));
            }
        });
        databaseLoginDialog.show();
    }

    public void databaseLoad(String string, String string2) {
        SetDatabaseDialog setDatabaseDialog;
        if ((TMEV.getConnection() != null || TMEV.connect(string, string2)) && (setDatabaseDialog = new SetDatabaseDialog(this.frame)).showModal() == 0) {
            this.useDatabase(setDatabaseDialog.getDatabase());
        }
    }

    public void useDatabase(String string) {
        try {
            Query query = new Query("use " + string);
            query.executeUpdate(TMEV.getConnection());
            for (int i = 0; i < activeComponents.size(); ++i) {
                ((ArrayViewer)activeComponents.elementAt(i)).systemEnable(1002);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception (ColumnApplet.useDatabase()): " + exception);
        }
    }

    public static void message(JFrame jFrame, String string) {
        System.out.println(string);
        MessageDisplay messageDisplay = new MessageDisplay(jFrame, string);
        messageDisplay.show();
    }

    public static void message(JFrame jFrame, Exception exception) {
        Manager.message(jFrame, exception.toString());
    }

    public static void exception(JFrame jFrame, String string) {
        System.out.println("EXCEPTION: " + string);
        MessageDisplay messageDisplay = new MessageDisplay(jFrame, string);
        messageDisplay.show();
    }

    public static void exception(JFrame jFrame, Exception exception) {
        Manager.exception(jFrame, exception.toString());
    }

    private void handleItems(Object object) {
    }

    public void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this.frame);
            for (int i = 0; i < activeComponents.size(); ++i) {
                SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EventListener
    implements ActionListener,
    WindowListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Container container;
            Object object = actionEvent.getSource();
            Manager.this.handleItems(object);
            if (object == Manager.this.newMultipleArrayViewerItem) {
                Manager.createNewMultipleArrayViewer();
            } else if (object == Manager.this.newSingleArrayViewerItem) {
                Manager.createNewSingleArrayViewer();
            } else if (object == Manager.this.loginItem) {
                Manager.this.databaseLogin();
            } else if (object == Manager.this.newPreferencesItem) {
                Manager.this.selectPreferencesFile();
            } else if (object == Manager.this.quitItem) {
                TMEV.quit();
            } else if (object == Manager.this.javaLFItem) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception exception) {}
            } else if (object == Manager.this.windowsLFItem) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception exception) {}
            } else if (object == Manager.this.motifLFItem) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception exception) {}
            } else if (object == Manager.this.toolTipsItem) {
                if (Manager.this.toolTipsItem.isSelected()) {
                    ToolTipManager.sharedInstance().setEnabled(true);
                } else {
                    ToolTipManager.sharedInstance().setEnabled(false);
                }
            } else if (object == Manager.this.acknolMenuItem) {
                new AcknowlegementDialog((Frame)Manager.this.frame, AcknowlegementDialog.createAcknowlegementText());
            } else if (object == Manager.this.papersMenuItem) {
                new PaperReferencesDialog((Frame)Manager.this.frame, PaperReferencesDialog.createReferencesText());
            } else if (object == Manager.this.citationMenuItem) {
                new MevCitationDialog((Frame)Manager.this.frame, MevCitationDialog.createCitationText());
            } else if (object == Manager.this.aboutMenuItem) {
                ImageScreen imageScreen = new ImageScreen();
                imageScreen.showImageScreen();
            } else if (object == Manager.this.systemInfoItem) {
                int n = 640;
                int n2 = 550;
                InformationPanel informationPanel = new InformationPanel();
                container = new JFrame("System Information");
                ((JFrame)container).getContentPane().add(informationPanel);
                ((Window)container).setSize(n, n2);
                Dimension dimension = ((Window)container).getToolkit().getScreenSize();
                ((Window)container).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
                ((Frame)container).setResizable(false);
                ((Window)container).setVisible(true);
                informationPanel.Start();
            }
            if (actionEvent.getActionCommand().equals("window-cmd")) {
                int n = windowMenu.getItemCount();
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                for (int i = 0; i < n; ++i) {
                    if (jMenuItem != windowMenu.getItem(i)) continue;
                    container = (JComponent)activeComponents.elementAt(i);
                    ((JComponent)container).requestFocus();
                    container.setLocation(container.getLocation());
                    if (container.getClass() == (class$org$tigr$microarray$mev$SingleArrayViewer == null ? (class$org$tigr$microarray$mev$SingleArrayViewer = Manager.class$("org.tigr.microarray.mev.SingleArrayViewer")) : class$org$tigr$microarray$mev$SingleArrayViewer)) {
                        ((SingleArrayViewer)container).getFrame().requestFocus();
                        break;
                    }
                    ((MultipleArrayViewer)container).getFrame().requestFocus();
                    break;
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (TMEV.activeSave) {
                JOptionPane.showMessageDialog(Manager.this.frame, "Analayis save is in progress. MeV will close when complete.", "Analysis Save in Progress", 1);
            }
            Manager.this.frame.dispose();
            while (TMEV.activeSave) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            System.exit(0);
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

