/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GeneAnnotationImportDialog
extends AlgorithmDialog {
    private JComboBox dataKeyBox;
    private JComboBox annFileKeyBox;
    private String[] dataAnnKeys;
    private String[] annFileKeys;
    private ColumnNamesPanel fieldSelectionPanel;
    private int result = 2;

    public GeneAnnotationImportDialog(JFrame jFrame, String[] stringArray, String[] stringArray2) {
        super(jFrame, "Append Gene Annotation", true);
        this.dataAnnKeys = stringArray;
        this.annFileKeys = stringArray2;
        JLabel jLabel = new JLabel("Gene Identifier (from current data):");
        this.dataKeyBox = new JComboBox<String>(stringArray);
        JLabel jLabel2 = new JLabel("Corresponding Gene Identifier from Input File:");
        this.annFileKeyBox = new JComboBox<String>(stringArray2);
        String string = "<html><body>Note: The Gene identifiers from the loaded data and the input annoation<br>";
        string = string + "file should correspond to the same annoation type.   These identifiers<br>";
        string = string + "are used to map annotation in the file to the proper genes loaded in MeV.</html>";
        JLabel jLabel3 = new JLabel(string);
        this.fieldSelectionPanel = new ColumnNamesPanel(stringArray2);
        ParameterPanel parameterPanel = new ParameterPanel("Annotation Key Selection");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 10, 0, 10), 0, 0));
        parameterPanel.add((Component)this.dataKeyBox, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 10), 0, 0));
        parameterPanel.add((Component)jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(25, 10, 0, 10), 0, 0));
        parameterPanel.add((Component)this.annFileKeyBox, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 20, 10), 0, 0));
        parameterPanel.add((Component)jLabel3, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 20, 10), 0, 0));
        parameterPanel.add((Component)this.fieldSelectionPanel, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 20, 0), 0, 0));
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.addContent((Component)parameterPanel);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getFileAnnotationKey() {
        return (String)this.annFileKeyBox.getSelectedItem();
    }

    public String getDataAnnotationKey() {
        return (String)this.dataKeyBox.getSelectedItem();
    }

    private void resetControls() {
        this.dataKeyBox.setSelectedIndex(0);
        this.annFileKeyBox.setSelectedIndex(0);
        this.fieldSelectionPanel.resetControls();
    }

    public String[] getSelectedAnnotationFields() {
        return this.fieldSelectionPanel.getSelectedColNames();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[3];
        String[] stringArray3 = new String[5];
        stringArray2[0] = "UID";
        stringArray2[1] = "GB";
        stringArray2[2] = "TC";
        stringArray3[0] = "UID";
        stringArray3[1] = "R";
        stringArray3[2] = "C";
        stringArray3[3] = "Tigr TC";
        stringArray3[4] = "GenBank";
        GeneAnnotationImportDialog geneAnnotationImportDialog = new GeneAnnotationImportDialog(new JFrame(), stringArray2, stringArray3);
        geneAnnotationImportDialog.showModal();
        System.exit(0);
    }

    private class ColumnNamesPanel
    extends JPanel {
        JCheckBox[] columnNameBoxes;
        JButton selectAllButton;
        JButton clearAllButton;

        ColumnNamesPanel(String[] stringArray) {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder("Select Annotation Fields to Append"));
            this.setBackground(Color.white);
            this.columnNameBoxes = new JCheckBox[stringArray.length];
            boolean bl = true;
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                bl = !stringArray[i].equals("UID") && !stringArray[i].equals("R") && !stringArray[i].equals("C");
                this.columnNameBoxes[i] = new JCheckBox(stringArray[i], bl);
                this.columnNameBoxes[i].setOpaque(false);
                this.columnNameBoxes[i].setFocusPainted(false);
            }
            JPanel jPanel = this.createCheckBoxPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setPreferredSize(new Dimension(450, 150));
            JButton jButton = new JButton("Select All");
            JButton jButton2 = new JButton("Clear All");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < columnNameBoxes.length; ++i) {
                        columnNameBoxes[i].setSelected(true);
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ ColumnNamesPanel this$1;
                {
                    this.this$1 = columnNamesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.this$1.columnNameBoxes.length; ++i) {
                        this.this$1.columnNameBoxes[i].setSelected(false);
                    }
                }
            });
            this.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 50.0, 10.0, 17, 3, new Insets(5, 10, 5, 0), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 100.0, 90.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        private JPanel createCheckBoxPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.setLayout(new GridBagLayout());
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                jPanel.add((Component)this.columnNameBoxes[i], new GridBagConstraints(0, i, 1, 1, 100.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            }
            return jPanel;
        }

        public int[] getSelectedCols() {
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                vector.add(new Integer(i + 1));
            }
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)vector.get(i);
            }
            return nArray;
        }

        public String[] getSelectedColNames() {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                vector.add(this.columnNameBoxes[i].getText());
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            return stringArray;
        }

        public void resetControls() {
            boolean bl = true;
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                bl = !this.columnNameBoxes[i].getText().equals("UID") && !this.columnNameBoxes[i].getText().equals("R") && !this.columnNameBoxes[i].getText().equals("C");
                this.columnNameBoxes[i].setSelected(bl);
            }
        }
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (GeneAnnotationImportDialog.this.getSelectedAnnotationFields().length < 1) {
                    JOptionPane.showMessageDialog((Component)((Object)GeneAnnotationImportDialog.this), "You must select at least one annotation field to import.", "Empty Annotation Field Selection", 0);
                    return;
                }
                GeneAnnotationImportDialog.this.result = 0;
                GeneAnnotationImportDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                GeneAnnotationImportDialog.this.result = 2;
                GeneAnnotationImportDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    GeneAnnotationImportDialog.this.resetControls();
                    GeneAnnotationImportDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)GeneAnnotationImportDialog.this), "Gene Annotation Import");
                    GeneAnnotationImportDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(600, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            GeneAnnotationImportDialog.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            GeneAnnotationImportDialog.this.result = -1;
            GeneAnnotationImportDialog.this.dispose();
        }
    }
}

