/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.midas.engine.IterativeLinReg;
import org.tigr.midas.engine.IterativeLogMean;
import org.tigr.midas.engine.RatioStats;
import org.tigr.midas.engine.TotInt;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.util.math.LinearEquation;

public class FloatSlideData
implements ISlideData,
Serializable {
    public static final long serialVersionUID = 10201060001L;
    private String name;
    private String filename;
    private float[] currentCY3;
    private float[] currentCY5;
    private float[] trueCY3;
    private float[] trueCY5;
    private static boolean isNonZero = true;
    private int normalizedState = 0;
    private int sortState = 0;
    private ISlideMetaData slideMetaData;
    private SpotInformationData spotInfoData;
    private boolean abbrName = false;
    private int dataType = 0;
    private char[] detection;
    private String sampleLabelKey = "Default Slide Name";
    private Hashtable sampleLabels;
    private Vector sampleLabelKeys;

    public FloatSlideData(ISlideMetaData iSlideMetaData) {
        this(iSlideMetaData, iSlideMetaData.getSize());
        this.sampleLabelKeys = new Vector();
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
    }

    public FloatSlideData(ISlideMetaData iSlideMetaData, int n) {
        this.slideMetaData = iSlideMetaData;
        this.trueCY3 = new float[n];
        this.trueCY5 = new float[n];
        this.detection = new char[n];
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
    }

    public ISlideMetaData getSlideMetaData() {
        return this.slideMetaData;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setSpotInformationData(String[] stringArray, String[][] stringArray2) {
        this.spotInfoData = new SpotInformationData(stringArray, stringArray2);
    }

    public void setSpotInformationData(SpotInformationData spotInformationData) {
        this.spotInfoData = spotInformationData;
    }

    public SpotInformationData getSpotInformationData() {
        return this.spotInfoData;
    }

    public int getSize() {
        return this.slideMetaData.getSize();
    }

    public void setSlideDataLabels(Vector vector, Hashtable hashtable) {
        this.sampleLabelKeys = vector;
        this.sampleLabels = hashtable;
    }

    public void setSlideDataName(String string) {
        String string2;
        this.name = string;
        this.sampleLabelKey = string2 = "Default Slide Name";
        this.sampleLabelKeys.addElement(string2);
        this.sampleLabels.put(string2, string);
    }

    public void toggleNameLength() {
        this.abbrName = !this.abbrName;
    }

    public String getSlideDataName() {
        String string = (String)this.sampleLabels.get(this.sampleLabelKey);
        if (string == null) {
            return " ";
        }
        if (!this.abbrName) {
            return string;
        }
        if (string.length() < 26) {
            return string;
        }
        return string.substring(0, 25) + "...";
    }

    public String getFullSlideDataName() {
        String string = (String)this.sampleLabels.get(this.sampleLabelKey);
        if (string == null) {
            return " ";
        }
        return string;
    }

    public void setSlideFileName(String string) {
        this.filename = string;
    }

    public String getSlideFileName() {
        if (!this.abbrName) {
            return this.filename;
        }
        if (this.filename.length() < 26) {
            return this.filename;
        }
        return this.filename.substring(0, 25) + "...";
    }

    public void setIntensities(int n, float f, float f2) {
        this.trueCY3[n] = f;
        this.trueCY5[n] = f2;
    }

    public void setCurrentIntensities(int n, float f, float f2) {
        if (this.currentCY3 != null && this.currentCY5 != null) {
            this.currentCY3[n] = f;
            this.currentCY5[n] = f2;
        }
    }

    public float getCY3(int n) {
        if (this.normalizedState == 0) {
            return this.trueCY3[n];
        }
        return this.currentCY3[n];
    }

    public float getCY5(int n) {
        if (this.normalizedState == 0) {
            return this.trueCY5[n];
        }
        return this.currentCY5[n];
    }

    public float getMaxRatio() {
        return this.getMaxRatio(0);
    }

    public float getMinRatio() {
        return this.getMinRatio(0);
    }

    public float getMaxRatio(int n) {
        float f = Float.MIN_VALUE;
        int n2 = this.getSize();
        for (int i = 0; i < n2; ++i) {
            float f2 = this.getRatio(i, n);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxRatio(int n, int n2, int n3) {
        float[] fArray;
        float[] fArray2;
        if (n == n2) {
            throw new IllegalArgumentException("The indices should not be equals.");
        }
        float f = Float.MIN_VALUE;
        if (n == 1) {
            fArray2 = this.trueCY5;
            fArray = this.trueCY3;
        } else {
            fArray2 = this.trueCY3;
            fArray = this.trueCY5;
        }
        int n4 = this.getSize();
        for (int i = 0; i < n4; ++i) {
            float f2 = FloatSlideData.getRatio(fArray2[i], fArray[i], n3);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMinRatio(int n) {
        int n2;
        float f = Float.MAX_VALUE;
        int n3 = n2 = this.getSize();
        while (--n3 >= 0) {
            float f2 = this.getRatio(n3, n);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMinRatio(int n, int n2, int n3) {
        float[] fArray;
        float[] fArray2;
        if (n == n2) {
            throw new IllegalArgumentException("The indices should not be equals.");
        }
        float f = Float.MAX_VALUE;
        if (n == 1) {
            fArray2 = this.trueCY5;
            fArray = this.trueCY3;
        } else {
            fArray2 = this.trueCY3;
            fArray = this.trueCY5;
        }
        int n4 = this.getSize();
        for (int i = 0; i < n4; ++i) {
            float f2 = FloatSlideData.getRatio(fArray2[i], fArray[i], n3);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public final float getRatio(int n, int n2) {
        if (this.normalizedState == 0) {
            if (this.dataType == 1) {
                return this.trueCY5[n];
            }
            return FloatSlideData.getRatio(this.trueCY5[n], this.trueCY3[n], n2);
        }
        if (this.dataType == 1) {
            return this.currentCY5[n];
        }
        return FloatSlideData.getRatio(this.currentCY5[n], this.currentCY3[n], n2);
    }

    public void setNonZero(boolean bl) {
        isNonZero = bl;
    }

    public static final float getRatio(float f, float f2, int n) {
        float f3;
        if (f2 < 0.0f || f < 0.0f) {
            return Float.NaN;
        }
        if (isNonZero) {
            if (f2 == 0.0f && f == 0.0f) {
                return Float.NaN;
            }
            f3 = f == 0.0f ? 1.0f / f2 : (f2 == 0.0f ? f : f / f2);
        } else {
            if (f2 == 0.0f) {
                return Float.NaN;
            }
            if (f == 0.0f) {
                return Float.NaN;
            }
            f3 = f / f2;
        }
        if (n == 1) {
            f3 = (float)(Math.log(f3) / Math.log(2.0));
        }
        return f3;
    }

    public float getMaxCY3() {
        if (this.normalizedState == 0) {
            return this.getMaxCY(this.trueCY3);
        }
        return this.getMaxCY(this.currentCY3);
    }

    public float getMaxCY5() {
        if (this.normalizedState == 0) {
            return this.getMaxCY(this.trueCY5);
        }
        return this.getMaxCY(this.currentCY5);
    }

    private float getMaxCY(float[] fArray) {
        int n;
        float f = 0.0f;
        int n2 = n = this.getSize();
        while (--n2 >= 0) {
            if (!(fArray[n2] > f)) continue;
            f = fArray[n2];
        }
        return f;
    }

    public float getMinCY3() {
        if (this.normalizedState == 0) {
            return this.getMinIntensity(this.trueCY3, true);
        }
        return this.getMinIntensity(this.currentCY3, true);
    }

    public float getMinCY5() {
        if (this.normalizedState == 0) {
            return this.getMinIntensity(this.trueCY5, true);
        }
        return this.getMinIntensity(this.currentCY5, true);
    }

    private float getMinIntensity(float[] fArray, boolean bl) {
        int n;
        float f = Float.MAX_VALUE;
        int n2 = n = this.getSize();
        while (--n2 >= 0) {
            float f2 = fArray[n2];
            if (!bl) {
                if (!(f2 < f) || f2 == 0.0f) continue;
                f = f2;
                continue;
            }
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public int getNormalizedState() {
        return this.normalizedState;
    }

    public void setNormalizedState(int n) {
        this.normalizedState = n;
    }

    public int getSortState() {
        return this.sortState;
    }

    public void setSortState(int n) {
        this.sortState = n;
    }

    public void setDetection(int n, String string) {
        this.detection[n] = string.charAt(0);
    }

    public String getDetection(int n) {
        return String.valueOf(this.detection[n]);
    }

    public float getMaxIntensity(int n) {
        switch (n) {
            case 0: {
                return this.getMaxCY3();
            }
            case 1: {
                return this.getMaxCY5();
            }
        }
        return Float.NaN;
    }

    public float getMinIntensity(int n, boolean bl) {
        return this.getMinIntensity(this.getIntensities(n), bl);
    }

    private float[] getIntensities(int n) {
        switch (n) {
            case 0: {
                return this.trueCY3;
            }
            case 1: {
                return this.trueCY5;
            }
        }
        return null;
    }

    public float getMaxProduct(int n, int n2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = this.getIntensities(n);
        float[] fArray2 = this.getIntensities(n2);
        int n3 = this.getSize();
        for (int i = 0; i < n3; ++i) {
            f = fArray[i] * fArray2[i];
            if (!(f > f2)) continue;
            f2 = f;
        }
        return f2;
    }

    public float getMinProduct(int n, int n2, boolean bl) {
        return this.getMinProduct(n, n2, bl, 0);
    }

    public float getMinProduct(int n, int n2, boolean bl, int n3) {
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float[] fArray = this.getIntensities(n);
        float[] fArray2 = this.getIntensities(n2);
        int n4 = this.getSize();
        for (int i = 0; i < n4; ++i) {
            f = fArray[i] * fArray2[i];
            if (!(f >= (float)n3)) continue;
            if (!bl) {
                if (!(f < f2) || f == 0.0f) continue;
                f2 = f;
                continue;
            }
            if (!(f < f2)) continue;
            f2 = f;
        }
        return f2;
    }

    public ISlideDataElement getSlideDataElement(int n) {
        ISlideDataElement iSlideDataElement = this.slideMetaData.toSlideDataElement(n);
        iSlideDataElement.setIntensity(0, this.getCY3(n));
        iSlideDataElement.setIntensity(1, this.getCY5(n));
        iSlideDataElement.setTrueIntensity(0, this.getCY3(n));
        iSlideDataElement.setTrueIntensity(1, this.getCY5(n));
        iSlideDataElement.setDetection(this.getDetection(n));
        return iSlideDataElement;
    }

    public void addSlideDataElement(ISlideDataElement iSlideDataElement) {
        this.throwNotImplemented("addSlideDataElement");
    }

    private void createDataCopy() {
        if (this.currentCY3 == null || this.currentCY5 == null) {
            this.currentCY3 = new float[this.trueCY3.length];
            this.currentCY5 = new float[this.trueCY5.length];
            System.arraycopy(this.trueCY3, 0, this.currentCY3, 0, this.currentCY3.length);
            System.arraycopy(this.trueCY5, 0, this.currentCY5, 0, this.currentCY5.length);
        }
    }

    public void createCurrentIntensityArrays() {
        if (this.currentCY3 == null || this.currentCY5 == null) {
            this.currentCY3 = new float[this.trueCY3.length];
            this.currentCY5 = new float[this.trueCY5.length];
            System.arraycopy(this.trueCY3, 0, this.currentCY3, 0, this.currentCY3.length);
            System.arraycopy(this.trueCY5, 0, this.currentCY5, 0, this.currentCY5.length);
        }
    }

    public void applyNormalization(int n, Properties properties) {
        this.createDataCopy();
        switch (n) {
            case 0: {
                this.applyNoNormalization();
                break;
            }
            case 1: {
                this.applyTotalIntensity();
                break;
            }
            case 2: {
                this.applyLeastSquares();
                break;
            }
            case 3: {
                this.applyLinearRegression(properties);
                break;
            }
            case 4: {
                this.applyRatioStatistics(properties);
                break;
            }
            case 5: {
                this.applyRatioStatistics(properties);
                break;
            }
            case 6: {
                this.applyIterativeLog(properties);
                break;
            }
            case 7: {
                this.applyLowess(10);
            }
        }
        this.setNormalizedState(n);
    }

    public void applyNormalizationList(int n) {
        this.createDataCopy();
        switch (n) {
            case 101: {
                this.applyTotalIntensity();
                break;
            }
            case 102: {
                this.applyLeastSquares();
                break;
            }
            case 103: {
                this.applyLinearRegression(new Properties());
                break;
            }
            case 104: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 105: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 106: {
                this.applyIterativeLog(new Properties());
                break;
            }
            case 107: {
                this.applyLowess(10);
            }
        }
        this.setNormalizedState(n);
    }

    private void applyNoNormalization() {
        if (this.trueCY3 != null && this.trueCY5 != null) {
            System.arraycopy(this.trueCY3, 0, this.currentCY3, 0, this.trueCY3.length);
            System.arraycopy(this.trueCY5, 0, this.currentCY5, 0, this.trueCY5.length);
        }
    }

    public void applyTotalIntensity() {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        columnWorker = new TotInt(columnWorker, "Cy3", false).getFileTotIntColumnWorker();
        this.setNormalizedIntensities(columnWorker, blArray);
        this.normalizedState = 1;
    }

    public void applyLinearRegression(Properties properties) {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        try {
            String string = (String)properties.get("mode");
            float f = Float.parseFloat((String)properties.get("standard-deviation"));
            columnWorker = new IterativeLinReg(columnWorker, f, string, "Cy3").getIterLinRegColumnWorker();
            this.setNormalizedIntensities(columnWorker, blArray);
            this.normalizedState = 3;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
            exception.printStackTrace();
        }
    }

    public void applyRatioStatistics(Properties properties) {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        try {
            int n = Integer.parseInt((String)properties.get("confidence-interval"));
            columnWorker = new RatioStats(columnWorker, false, n, "Cy3").getRatioStatsColumnWorker();
            this.setNormalizedIntensities(columnWorker, blArray);
            this.normalizedState = 3;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
            exception.printStackTrace();
        }
    }

    public void applyIterativeLog(Properties properties) {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        try {
            float f = Float.parseFloat((String)properties.get("standard-deviation"));
            columnWorker = new IterativeLogMean(columnWorker, f, "Cy3").getIterLogMeanColumnWorker();
            this.setNormalizedIntensities(columnWorker, blArray);
            this.normalizedState = 6;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
        }
    }

    private ColumnWorker constructColumnWorker(boolean[] blArray) {
        int n;
        int n2 = n = this.getSize();
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        String[] stringArray = new String[n];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getSlideDataElement(i).getRow(1);
            int n4 = this.getSlideDataElement(i).getColumn(1);
            float f = this.trueCY3[i];
            float f2 = this.trueCY5[i];
            if (this.dataType == 1) {
                f = 100000.0f;
                if ((f2 = (float)(100000.0 * Math.pow(2.0, f2))) == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                    f2 = 0.0f;
                    f = 0.0f;
                }
            }
            if (f == 0.0f || f2 == 0.0f) continue;
            blArray[i] = true;
            fArray[n] = f;
            fArray2[n] = f2;
            stringArray[n] = Integer.toString(n3) + "_" + Integer.toString(n4);
            ++n;
        }
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        System.arraycopy(fArray, 0, fArray3, 0, n);
        System.arraycopy(fArray2, 0, fArray4, 0, n);
        System.arraycopy(stringArray, 0, stringArray, 0, n);
        return new ColumnWorker(fArray3, fArray4, stringArray);
    }

    private void setNormalizedIntensities(ColumnWorker columnWorker, boolean[] blArray) {
        float[] fArray = columnWorker.getColumnOneArray();
        float[] fArray2 = columnWorker.getColumnTwoArray();
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                if (this.dataType == 1) {
                    this.currentCY3[i] = 1.0f;
                    this.currentCY5[i] = (float)(Math.log(fArray2[n] / fArray[n]) / Math.log(2.0));
                } else {
                    this.currentCY3[i] = fArray[n];
                    this.currentCY5[i] = fArray2[n];
                }
                ++n;
                continue;
            }
            this.currentCY3[i] = this.trueCY3[i];
            this.currentCY5[i] = this.trueCY5[i];
        }
    }

    private final float applyTotalIntensity(float f, float f2, float f3) {
        if (f > 0.0f) {
            return f * f2 / f3;
        }
        return 0.0f;
    }

    private float getSumIntensity(int n) {
        float f = 0.0f;
        float[] fArray = this.getIntensities(n);
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f;
    }

    private float getSumNonZeroIntensity(int n) {
        float f = 0.0f;
        float[] fArray = this.getIntensities(n);
        for (int i = 0; i < fArray.length; ++i) {
            if (!this.slideMetaData.hasNoZeros(i)) continue;
            f += fArray[i];
        }
        return f;
    }

    private void applyLeastSquares() {
        if (this.getNormalizedState() != 2) {
            LinearEquation linearEquation = this.getRegressionEquation(true);
            int n = this.getSize();
            for (int i = 0; i < n; ++i) {
                this.currentCY5[i] = this.applyLeastSquares(this.trueCY5[i], linearEquation);
            }
        }
    }

    private float applyLeastSquares(float f, LinearEquation linearEquation) {
        if (f > 0.0f) {
            return (float)(((double)f - linearEquation.getYIntercept()) * (1.0 / linearEquation.getSlope()));
        }
        return 0.0f;
    }

    private LinearEquation getRegressionEquation(boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 1.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        float[] fArray = bl ? this.trueCY3 : this.currentCY3;
        float[] fArray2 = bl ? this.trueCY5 : this.currentCY5;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            d = fArray[i];
            d2 = fArray2[i];
            if (d == 0.0 || d2 == 0.0) continue;
            d3 += d9;
            d4 += d9 * d;
            d5 += d9 * d2;
            d6 += d9 * d * d;
            d7 += d9 * d2 * d2;
            d8 += d9 * d * d2;
        }
        d10 = d3 * d6 - d4 * d4;
        d11 = (d6 * d5 - d4 * d8) / d10;
        d12 = (d8 * d3 - d4 * d5) / d10;
        d15 = Math.sqrt(d13 * d6 / d10);
        d16 = Math.sqrt(d13 * d3 / d10);
        d14 = (d3 * d8 - d4 * d5) / Math.sqrt(d10 * (d3 * d7) - d5 * d5);
        LinearEquation linearEquation = new LinearEquation(d12, d11, d14);
        return linearEquation;
    }

    private void applyLowess(int n) {
        this.throwNotImplemented("applyLowess");
    }

    private void throwNotImplemented(String string) {
        throw new RuntimeException("Method '" + string + "' is not supported");
    }

    public Vector getSlideDataKeys() {
        return this.sampleLabelKeys;
    }

    public Hashtable getSlideDataLabels() {
        return this.sampleLabels;
    }

    public void setDataLabelKey(String string) {
        this.sampleLabelKey = string;
    }

    public void addNewSampleLabel(String string, String string2) {
        if (!this.sampleLabelKeys.contains(string)) {
            this.sampleLabelKeys.addElement(string);
        }
        this.sampleLabels.put(string, string2);
    }
}

