/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.file;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.file.FieldNotFoundException;
import org.tigr.util.StringSplitter;

public class MevFileParser {
    public static final int INVALID_FILE = 0;
    public static final int MEV_FILE = 1;
    public static final String UNIQUE_ID_STRING = "UID";
    private Vector columnHeaders;
    private Vector rawLines;
    private IntVector dataLinesMap;
    private boolean mevFileLoaded;

    public static File selectFile(Component component) {
        return MevFileParser.selectFile(new File(System.getProperty("user.dir")), component);
    }

    public static File selectFile(File file, Component component) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setDialogTitle("Select an mev file");
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".mev");
            }

            public String getDescription() {
                return "TIGR MeV Files (*.mev)";
            }
        });
        if (jFileChooser.showOpenDialog(component) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static int validate(File file) {
        IntVector intVector = new IntVector();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = new String();
        BufferedReader bufferedReader = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
                if (!string.startsWith("#") && !string.startsWith("\"#")) {
                    if (!bl) {
                        bl = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            if (string2.equals(UNIQUE_ID_STRING)) {
                                bl2 = true;
                            }
                            for (int i = 0; i < vector2.size(); ++i) {
                                String string3 = (String)vector2.elementAt(i);
                                if (!string2.equals(string3)) continue;
                                bl3 = false;
                                return 0;
                            }
                            vector2.add(string2);
                        }
                    } else {
                        intVector.add(n);
                    }
                }
                ++n;
            }
            if (intVector.size() > 0) {
                bl4 = true;
            }
        }
        catch (IOException iOException) {
            return 0;
        }
        if (bl2 && bl3 && bl4 && bl5) {
            return 1;
        }
        return 0;
    }

    public void loadFile(File file) {
        this.dataLinesMap = new IntVector();
        this.rawLines = new Vector();
        this.columnHeaders = new Vector();
        String string = new String();
        BufferedReader bufferedReader = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                this.rawLines.add(string);
                if (!string.startsWith("#") && !string.startsWith("\"#")) {
                    if (!bl) {
                        bl = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                        while (stringTokenizer.hasMoreTokens()) {
                            this.columnHeaders.add(stringTokenizer.nextToken());
                        }
                    } else {
                        this.dataLinesMap.add(n);
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.mevFileLoaded = false;
            return;
        }
        this.mevFileLoaded = true;
    }

    public boolean isMevFileLoaded() {
        return this.mevFileLoaded;
    }

    public Vector getColumnHeaders() {
        return this.columnHeaders;
    }

    public Vector getColumnAt(int n) {
        return this.getColumnAt(n, false);
    }

    public Vector getColumnAt(int n, boolean bl) {
        Vector vector = new Vector(this.dataLinesMap.size() + (bl ? 1 : 0));
        if (n >= this.columnHeaders.size() || n < 0) {
            throw new IndexOutOfBoundsException("Column Index out of bounds.");
        }
        if (bl) {
            vector.add(this.columnHeaders.elementAt(n));
        }
        for (int i = 0; i < this.dataLinesMap.size(); ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getElementAtIndex(i));
            for (int j = 0; j < n; ++j) {
                stringTokenizer.nextToken();
            }
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public Vector getColumnNamed(String string) throws FieldNotFoundException {
        return this.getColumnNamed(string, false);
    }

    public Vector getColumnNamed(String string, boolean bl) throws FieldNotFoundException {
        Vector vector = this.getColumnHeaders();
        if (vector.contains(string)) {
            return this.getColumnAt(vector.indexOf(string), bl);
        }
        throw new FieldNotFoundException("Field " + string + " not found.");
    }

    public String getLineAt(int n) {
        return (String)this.rawLines.elementAt(n);
    }

    public String getElementAtIndex(int n) {
        return this.getLineAt(this.dataLinesMap.intElementAt(n));
    }

    public String getElementAtRC(int n, int n2) {
        return new String();
    }

    public String getElementById(String string) throws FieldNotFoundException {
        String string2 = null;
        try {
            string2 = this.getElementByField(UNIQUE_ID_STRING, string);
            return string2;
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            throw new FieldNotFoundException("Unique Identifier field (UID) not found.");
        }
    }

    public String getElementByField(String string, String string2) throws FieldNotFoundException {
        Vector vector = this.getColumnNamed(string);
        if (vector == null) {
            throw new FieldNotFoundException("Field " + string + " not found.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string2)) continue;
            return this.getElementAtIndex(i);
        }
        return null;
    }

    public Vector getElementsByField(String string, String string2) throws FieldNotFoundException {
        Vector vector = this.getColumnNamed(string);
        Vector<String> vector2 = null;
        if (vector == null) {
            throw new FieldNotFoundException("Field " + string + " not found.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string2)) continue;
            if (vector2 == null) {
                vector2 = new Vector<String>();
            }
            vector2.add(this.getElementAtIndex(i));
        }
        return vector2;
    }

    public String[][] getDataMatrix() {
        return this.getDataMatrix(false);
    }

    public String[][] getDataMatrix(boolean bl) {
        Vector vector = this.getColumnHeaders();
        int n = bl ? 1 : 0;
        String[][] stringArray = new String[this.dataLinesMap.size() + n][vector.size()];
        if (bl) {
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[0][i] = (String)vector.elementAt(i);
            }
        }
        StringSplitter stringSplitter = new StringSplitter('\t');
        for (int i = n; i < stringArray.length; ++i) {
            String string = this.getElementAtIndex(i - n);
            stringSplitter.init(string);
            for (int j = 0; j < stringArray[i].length; ++j) {
                try {
                    stringArray[i][j] = stringSplitter.nextToken();
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    stringArray[i][j] = "";
                }
            }
        }
        return stringArray;
    }

    private static class IntVector
    extends Vector {
        private IntVector() {
        }

        public void add(int n) {
            super.add(new Integer(n));
        }

        public int intElementAt(int n) {
            return (Integer)super.elementAt(n);
        }
    }
}

