/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.file;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.file.FieldNotFoundException;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.file.agilent.ColumnMismatchException;
import org.tigr.microarray.mev.file.agilent.MeVerizer;

public class AgilentMevFileParser {
    public static final int INVALID_FILE = 0;
    public static final int MEV_FILE = 1;
    public static String mHeaderLine = "UID\tIA\tIB\tR\tC\tMR\tMC\tFlagA\tFlagB\tBGA\tBGB\tSDIA\tSDIB\tSDBGA\tSDBGB\tMedianA\tMedianB";
    public static String columnDefLine = "FeatureNum\tgDyeNormSignal\trDyeNormSignal\tRow\tCol\tMR\tMC\tgIsFeatNonUnifOL\trIsFeatNonUnifOL\tgBGMedianSignal\trBGMedianSignal\tgPixSDev\trPixSDev\tgBGPixSDev\trBGPixSDev\tgMedianSignal\trMedianSignal";
    public static String replacement = "1";
    public static final String UNIQUE_ID_STRING = "UID";
    private Vector columnHeaders;
    private Vector rawLines;
    private IntVector dataLinesMap;
    private boolean mevFileLoaded;

    public SpotInformationData getSpotInformation() {
        if (this.isMevFileLoaded()) {
            int n;
            String[][] stringArray = this.getDataMatrix();
            Vector vector = this.getColumnHeaders();
            if (vector.size() < 9) {
                return null;
            }
            int n2 = vector.size() - 9;
            String[][] stringArray2 = new String[stringArray.length][n2];
            for (int i = 0; i < stringArray2.length; ++i) {
                for (n = 0; n < stringArray2[i].length; ++n) {
                    stringArray2[i][n] = stringArray[i][n + 9];
                }
            }
            String[] stringArray3 = new String[vector.size() - 9];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray3[n] = (String)vector.elementAt(n + 9);
            }
            return new SpotInformationData(stringArray3, stringArray2);
        }
        return null;
    }

    public static File selectFile(Component component) {
        return AgilentMevFileParser.selectFile(new File(System.getProperty("user.dir")), component);
    }

    public static File selectFile(File file, Component component) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setDialogTitle("Select an Agilent Oligo Feature Extraction file");
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "Agilent Oligo Feature Extraction Files (*.txt)";
            }
        });
        if (jFileChooser.showOpenDialog(component) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static int validate(File file) {
        IntVector intVector = new IntVector();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = new String();
        BufferedReader bufferedReader = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        String string2 = null;
        try {
            MeVerizer meVerizer = new MeVerizer(mHeaderLine, columnDefLine);
            meVerizer.parseExtract(file, true, replacement);
            string2 = meVerizer.getFileString();
        }
        catch (ColumnMismatchException columnMismatchException) {
            columnMismatchException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader = new BufferedReader(new StringReader(string2));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
                if (!string.startsWith("#")) {
                    if (!bl) {
                        bl = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string3 = stringTokenizer.nextToken();
                            if (string3.equals(UNIQUE_ID_STRING)) {
                                bl2 = true;
                            }
                            for (int i = 0; i < vector2.size(); ++i) {
                                String string4 = (String)vector2.elementAt(i);
                                if (!string3.equals(string4)) continue;
                                bl3 = false;
                                return 0;
                            }
                            vector2.add(string3);
                        }
                    } else {
                        intVector.add(n);
                    }
                }
                ++n;
            }
            if (intVector.size() > 0) {
                bl4 = true;
            }
        }
        catch (IOException iOException) {
            return 0;
        }
        if (bl2 && bl3 && bl4 && bl5) {
            return 1;
        }
        return 0;
    }

    public void loadFile(File file) {
        this.dataLinesMap = new IntVector();
        this.rawLines = new Vector();
        this.columnHeaders = new Vector();
        String string = new String();
        BufferedReader bufferedReader = null;
        boolean bl = false;
        String string2 = null;
        try {
            MeVerizer meVerizer = new MeVerizer(mHeaderLine, columnDefLine);
            meVerizer.parseExtract(file, true, replacement);
            string2 = meVerizer.getFileString();
        }
        catch (ColumnMismatchException columnMismatchException) {
            columnMismatchException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader = new BufferedReader(new StringReader(string2));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                this.rawLines.add(string);
                if (!string.startsWith("#")) {
                    if (!bl) {
                        bl = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                        while (stringTokenizer.hasMoreTokens()) {
                            this.columnHeaders.add(stringTokenizer.nextToken());
                        }
                    } else {
                        this.dataLinesMap.add(n);
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.mevFileLoaded = false;
            return;
        }
        this.mevFileLoaded = true;
    }

    public boolean isMevFileLoaded() {
        return this.mevFileLoaded;
    }

    public Vector getColumnHeaders() {
        return this.columnHeaders;
    }

    public Vector getColumnAt(int n) {
        return this.getColumnAt(n, false);
    }

    public Vector getColumnAt(int n, boolean bl) {
        Vector vector = new Vector(this.dataLinesMap.size() + (bl ? 1 : 0));
        if (n >= this.columnHeaders.size() || n < 0) {
            throw new IndexOutOfBoundsException("Column Index out of bounds.");
        }
        if (bl) {
            vector.add(this.columnHeaders.elementAt(n));
        }
        for (int i = 0; i < this.dataLinesMap.size(); ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getElementAtIndex(i));
            for (int j = 0; j < n; ++j) {
                stringTokenizer.nextToken();
            }
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public Vector getColumnNamed(String string) throws FieldNotFoundException {
        return this.getColumnNamed(string, false);
    }

    public Vector getColumnNamed(String string, boolean bl) throws FieldNotFoundException {
        Vector vector = this.getColumnHeaders();
        if (vector.contains(string)) {
            return this.getColumnAt(vector.indexOf(string), bl);
        }
        throw new FieldNotFoundException("Field " + string + " not found.");
    }

    public String getLineAt(int n) {
        return (String)this.rawLines.elementAt(n);
    }

    public String getElementAtIndex(int n) {
        return this.getLineAt(this.dataLinesMap.intElementAt(n));
    }

    public String getElementAtRC(int n, int n2) {
        return new String();
    }

    public String getElementById(String string) throws FieldNotFoundException {
        String string2 = null;
        try {
            string2 = this.getElementByField(UNIQUE_ID_STRING, string);
            return string2;
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            throw new FieldNotFoundException("Unique Identifier field (UID) not found.");
        }
    }

    public String getElementByField(String string, String string2) throws FieldNotFoundException {
        Vector vector = this.getColumnNamed(string);
        if (vector == null) {
            throw new FieldNotFoundException("Field " + string + " not found.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string2)) continue;
            return this.getElementAtIndex(i);
        }
        return null;
    }

    public Vector getElementsByField(String string, String string2) throws FieldNotFoundException {
        Vector vector = this.getColumnNamed(string);
        Vector<String> vector2 = null;
        if (vector == null) {
            throw new FieldNotFoundException("Field " + string + " not found.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string2)) continue;
            if (vector2 == null) {
                vector2 = new Vector<String>();
            }
            vector2.add(this.getElementAtIndex(i));
        }
        return vector2;
    }

    public String[][] getDataMatrix() {
        return this.getDataMatrix(false);
    }

    public String[][] getDataMatrix(boolean bl) {
        int n;
        Vector vector = this.getColumnHeaders();
        int n2 = bl ? 1 : 0;
        String[][] stringArray = new String[this.dataLinesMap.size() + n2][vector.size()];
        if (bl) {
            for (n = 0; n < vector.size(); ++n) {
                stringArray[0][n] = (String)vector.elementAt(n);
            }
        }
        for (n = n2; n < stringArray.length; ++n) {
            String string = this.getElementAtIndex(n - n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            for (int i = 0; i < stringArray[n].length; ++i) {
                stringArray[n][i] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    private static class IntVector
    extends Vector {
        private IntVector() {
        }

        public void add(int n) {
            super.add(new Integer(n));
        }

        public int intElementAt(int n) {
            return (Integer)super.elementAt(n);
        }
    }
}

