/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 * StatsTools.java
 *
 * Created on August 22, 2002, 5:49 PM
 * @author  wliang
 * @version
 */

package org.tigr.midas.math;

import java.io.*;
import java.util.*;
import org.tigr.midas.util.*;
//import drasys.or.prob.*; Mod for MeV, don't need this package

public class StatsTools {
    
    private float[] wholeX;
    private float[] wholeY;
    private int dataSize;
    private float a;
    private float b;
    private float xMean;
    private float yMean;
    private float xVariance;
    private float xSD;
    private float yVariance;
    private float xyCovariance;
    private float correlationCoeff;
    private float xRegressionCoeff;
    private float yRegressionCoeff;
    private int dF;
    private float tVal;
    private float pVal;
    
    public StatsTools(){
    }
    
    public void computeMeanSD(float[] wholeX){
        
        this.wholeX = wholeX;
        
        float sumX = 0;
        float sumX2 = 0;
        
        dataSize = wholeX.length;
        for (int i = 0; i < dataSize; i++){
            sumX += wholeX[i];
            sumX2 += wholeX[i] * wholeX[i];
        }
        
        xMean = sumX / dataSize;
        xVariance = sumX2 - dataSize * xMean * xMean;
        xSD = (float)Math.sqrt(xVariance / (dataSize - 1));
    }
    
    public void computeMeanSDforNonZero(float[] wholeX){
        
        this.wholeX = wholeX;
        
        float sumX = 0;
        float sumX2 = 0;
        int nonZeroCount = 0;
        
        dataSize = wholeX.length;
        for (int i = 0; i < dataSize; i++){
            if (wholeX[i] != 0){
                sumX += wholeX[i];
                sumX2 += wholeX[i] * wholeX[i];
                nonZeroCount++;
            }
        }
        dataSize = nonZeroCount;
        xMean = sumX / dataSize;
        xVariance = sumX2 - dataSize * xMean * xMean;
        xSD = (float)Math.sqrt(xVariance / (dataSize - 1));
    }
    
    public void linearRegression(float[] wholeX, float[] wholeY) {
        
        // Y = a + bX
        this.wholeX = wholeX;
        this.wholeY = wholeY;
        
        float sumX = 0;
        float sumY = 0;
        float sumX2 = 0;
        float sumY2 = 0;
        float sumXY = 0;
        
        dataSize = wholeX.length;
        
        for (int i = 0; i < dataSize; i++){
            sumX += wholeX[i];
            sumX2 += wholeX[i] * wholeX[i];
            sumY += wholeY[i];
            sumY2 += wholeY[i] * wholeY[i];
            sumXY += wholeX[i] * wholeY[i];
        }
        
        xMean = sumX / dataSize;
        yMean = sumY / dataSize;
        
        //a = (sumX2 * sumY - sumX * sumXY) / (dataSize * sumX2 - sumX * sumX);
        b = (sumXY - sumX * sumY / dataSize) / (sumX2 - sumX * sumX / dataSize);
        a = yMean - b * xMean;
        xVariance = sumX2 - dataSize * xMean * xMean;
        yVariance = sumY2 - dataSize * yMean * yMean;
        xyCovariance = sumXY - dataSize * xMean * yMean;
        correlationCoeff = (float)Math.sqrt((dataSize * sumXY - sumX * sumY) * (dataSize * sumXY - sumX * sumY) / ((dataSize * sumX2 - sumX * sumX) * (dataSize * sumY2 - sumY * sumY)));
        float r = (float)Math.sqrt(xyCovariance * xyCovariance / (xVariance * yVariance));
        xRegressionCoeff = (float)Math.sqrt(xyCovariance / yVariance);
        yRegressionCoeff = (float)Math.sqrt(xyCovariance / xVariance);
    }
  
    /*
    public void ttest(float[] wholeX, float nullHypoVal) {
        dF = wholeX.length - 1;
        computeMeanSD(wholeX);
        tVal = (xMean - nullHypoVal) * (float)Math.sqrt(wholeX.length) / getXSD();
        StudentsTDistribution tDist = new StudentsTDistribution(dF);
        pVal = (float)tDist.pdf(tVal);
        logger.log("xMean = " + xMean + ", dF = " + dF + ", tVal = " + tVal + ", pVal = " + pVal);
    }
     **/
    
    
    public float getIntercept(){
        return a;
    }
    
    public float getSlope(){
        return b;
    }
    
    public float getXMean(){
        return xMean;
    }
    
    public float getYMean(){
        return yMean;
    }
    
    public float getXVariance(){
        return xVariance;
    }
    
    public int getDataSize(){
        return dataSize;
    }
    
    public float getCorrelationCoeff(){
        return correlationCoeff;
    }
    
    public float getXRegressionCoeff(){
        return xRegressionCoeff;
    }
    
    public float getYRessionCoeff(){
        return yRegressionCoeff;
    }
    
    public float getXSD(){
        return xSD;
    }
    
    public static void main(String args[]) {
        //float[] x = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, 0, 0, 0};
        float[] y = {55.95f, 68.24f, 52.73f, 21.50f, 23.78f};
        
        StatsTools l = new StatsTools();
        // ttest(y, 0.0f); Mod for MeV eliminate need for or124.jar
        /*
        l.computeMeanSD(y);
        logger.log("xMean = " + l.getXMean());
        logger.log("xVariance = " + l.getXVariance());
        logger.log("xSD = " + l.getXSD());
        logger.log("********************");
        l.computeMeanSDforNonZero(y);
        logger.log("xMean = " + l.getXMean());
        logger.log("xVariance = " + l.getXVariance());
        logger.log("xSD = " + l.getXSD());
        logger.log("********************");
        l.linearRegression(x, y);
        logger.log("a = " + l.getIntercept());
        logger.log("b = " + l.getSlope());
        logger.log("xMean = " + l.getXMean());
        logger.log("yMean = " + l.getYMean());
        logger.log("dataSize = " + l.getDataSize());
        logger.log("corr Coeff = " + l.getCorrelationCoeff());
        logger.log("xReg Coeff = " + l.getXRegressionCoeff());
        logger.log("yReg Coeff = " + l.getYRessionCoeff());
        logger.log("xVariance = " + l.getXVariance());
        logger.log("xSD = " + l.getXSD());
         */
        
/*        
        try{
            ColumnWorker cw = new ColumnWorker("W:\\DataFiles0\\32K\\flipdye_block_sa12\\locfit\\CAG-108.pre");
            cw.setColumns(0, 1);
            l.computeMeanSD(cw.getColumnOneArray());
            logger.log("xMean = " + l.getXMean());
            logger.log("SD = " + l.getXSD());
        }catch(FileNotFoundException fex){
            fex.printStackTrace();
        }catch(Exception ex){
            ex.printStackTrace();
        }
 **/
        /*  Mod for MeV break reliance on or124.jar
        NormalDistribution normDist = new NormalDistribution();
        System.out.println("Z-distribution, Prob(-1<x<1) = " + normDist.probability(-1.0, 1.0));
        StudentsTDistribution tDist = new StudentsTDistribution(4);
        System.out.println("t-distribution, t = 4.7911, p-Value = " + tDist.pdf(4.7911));
        System.out.println("t-distribution, t = 4.7911, p-Value(-4.7911, 4.7911) = " + tDist.probability(-4.7911, 4.7911));
        */
        
         }
    
}
