## Rd2dvi -- Convert man pages (*.Rd help files) via LaTeX to DVI/PDF.
##
## Examples:
##  R CMD Rd2dvi /path/to/Rsrc/src/library/base/man/Normal.Rd
##  R CMD Rd2dvi `grep -l "\\keyword{distr" \
##                  /path/to/Rsrc/src/library/stats/man/*.Rd | sort | uniq`

revision='$Rev: 51856 $'
version=`set - ${revision}; echo ${2}`
version="Rd2dvi: ${R_VERSION} (r${version})

Copyright (C) 2000-2009 The R Core Development Team.
This is free software; see the GNU General Public License version 2
or later for copying conditions.  There is NO warranty."

usage="Usage: R CMD Rd2dvi [options] files

Generate DVI (or PDF) output from the Rd sources specified by files, by
either giving the paths to the files, or the path to a directory with
the sources of a package, or an installed package.

Unless specified via option '--output', the basename of the output file
equals the basename of argument 'files' if this specifies a package
or a single file, and 'Rd2' otherwise.

The Rd sources are assumed to be ASCII unless they contain \encoding
declarations (which take priority) or --encoding is supplied or if using
package sources, if the package DESCRIPTION file has an Encoding field.
The output encoding defaults to the package encoding then to 'UTF-8'.

Options:
  -h, --help		print short help message and exit
  -v, --version		print version info and exit
      --batch		no interaction
      --debug		turn on shell debugging (set -x)
      --no-clean	do not remove created temporary files
      --no-preview	do not preview generated DVI/PDF file
      --encoding=enc    use 'enc' as the default input encoding
      --outputEncoding=outenc use 'outenc' as the default output encoding
      --os=NAME		use OS subdir 'NAME' (unix or windows)
      --OS=NAME		the same as '--os'
  -o, --output=FILE	write output to FILE
      --pdf		generate PDF output
      --title=NAME	use NAME as the title of the document
  -V, --verbose		report on what is done
      --no-index	don't index output
      --no-description	don't typeset the description of a package
      --internals	typeset 'internal' documentation (usually skipped)

The output papersize is set by the environment variable R_PAPERSIZE.
The DVI previewer is set by the environment variable xdvi.
The PDF previewer is set by the environment variable R_PDFVIEWER.

Report bugs to <r-bugs@r-project.org>."

## workaround the export of CDPATH, which may cause 'cd ${build_dir}' to echo
unset CDPATH

start_dir=`pwd`
build_dir=".Rd2dvi${$}"

title=""
batch=false
clean=true
debug=false
only_meta=false
out_ext="dvi"
output=""
verbose=false
enc=unknown
outenc=latin1
index=true
description=true
internals=no

if test "${R_OSTYPE}" = "windows"; then
  echo=echo
  preview=${xdvi-open}
  OSdir=windows
else
  ## Need a `safe' echo which does not interpret backslash-escaped
  ## characters in SysV style.
  ## FIXME: R_SHARE_DIR might contain a space.
  echo="sh ${R_SHARE_DIR}/sh/echo.sh"
  preview=${xdvi-xdvi}
  OSdir=unix
fi

while test -n "${1}"; do
  case ${1} in
    -h|--help)
      ${echo} "${usage}"; exit 0 ;;
    -v|--version)
      ${echo} "${version}"; exit 0 ;;
    --batch)
      batch=true ;;
    --debug)
      debug=true ;;
    --no-clean)
      clean=false ;;
    --no-preview)
      preview=false ;;
    --pdf)
      out_ext="pdf";
      ## allow for --no-preview --pdf
      if test "${preview}" != "false"; then
	if test -n "${R_PDFVIEWER}"; then
	    preview=${R_PDFVIEWER}
	elif test "${R_OSTYPE}" = "windows"; then
	    preview=open
	else
	    preview=false
	fi
      fi
      R_RD4DVI=${R_RD4PDF-"times,hyper"}
      R_LATEXCMD="${R_PDFLATEXCMD}"
      ;;
    --title=*)
      title=`echo "${1}" | ${SED} -e 's/[^=]*=//'` ;;
    -o)
      if test -n "`echo ${2} | ${SED} 's/^-.*//'`"; then
	output="${2}"; shift
      else
	echo "ERROR: option '${1}' requires an argument"
	exit 1
      fi
      ;;
    --only-meta)
      only_meta=true ;;
    --output=*)
      output=`echo "${1}" | ${SED} -e 's/[^=]*=//'` ;;
    --OS=*|--os=*)
      OSdir=`echo "${1}" | ${SED} -e 's/[^=]*=//'` ;;
    --encoding=*)
      enc=`echo "${1}" | ${SED} -e 's/[^=]*=//'` ;;
    --outputEncoding=*)
      outenc=`echo "${1}" | ${SED} -e 's/[^=]*=//'` ;;
    --build-dir=*)
      build_dir=`echo "${1}" | ${SED} -e 's/[^=]*=//'` ;;
    -V|--verbose)
      verbose=${echo} ;;
    --no-index)
      index=false ;;
    --no-description)
      description=false ;;
    --internals)
      internals="yes" ;;
    --|*)
      break ;;
  esac
  shift
done

if ${debug}; then set -x; fi

do_cleanup () {
  if ${clean}; then
    cd ${start_dir}
    rm -rf ${build_dir}
  else
    echo "You may want to clean up by 'rm -rf ${build_dir}'"
  fi
}

if test -d "${1}"; then
  if test -f ${1}/DESCRIPTION; then
    echo "Hmm ... looks like a package"
    dir=${1}
    test -z "${output}" && output="`basename ${1}`.${out_ext}"
  elif test -f ${1}/DESCRIPTION.in && \
       test -n "`grep '^Priority: *base' ${1}/DESCRIPTION.in`"; then
    echo "Hmm ... looks like a package from the R distribution"
    dir=${1}
    test -z "${output}" && output="`basename ${1}`.${out_ext}"
  else
    if test -d ${1}/man; then
      dir=${1}/man
    else
      dir=${1}
    fi
  fi
else
  if test ${#} -eq 1 ; then
    if test -z "${output}"; then
      output=`basename "${1}"`
      output="`echo ${output} | ${SED} 's/[Rr]d$//'`${out_ext}"
    fi
  fi
fi

## Prepare for building the documentation.
if test -z "${output}"; then
  output="Rd2.${out_ext}"
fi
if test -f ${output}; then
  echo "file '${output}' exists; please remove first"
  exit 1
fi
if test -d ${build_dir}; then
  rm -rf ${build_dir} || echo "cannot write to build dir" && exit 2
fi
mkdir ${build_dir}

echo "tools:::.Rd2dvi(\"${1}\",  \"${build_dir}/Rd2.tex\", \
\"$title\", \"$batch\", \"$description\", \"$only_meta\",\
\"$enc\", \"$outenc\", \"${dir-$@}\", \"OSdir\", \"$internals\", \"$index\")" \
  | LC_ALL=C ${R_HOME}/bin/R --slave --vanilla || exit 11

## <FIXME>
## Need to do something smarter about the exit status in batch mode.
status=0
## <FIXME>


R_TEXOPTS=
if test "${R_OSTYPE}" = "windows"; then
  miktex=`latex --version | grep ^MiKTeX | wc -l`
  if test "${miktex}" = "1"; then
    R_TEXOPTS=--include-directory=${R_HOME}/share/texmf
  fi
fi

echo "Creating ${out_ext} output from LaTeX ..."
cd ${build_dir}
if test "${out_ext}" = pdf; then
  ${R_PDFLATEXCMD} ${R_TEXOPTS} Rd2 || status=1
  if test $status -gt 0; then
    echo "Error in running pdflatex command ('${R_PDFLATEXCMD}')"
    do_cleanup
    exit 1
  fi
  if test "${index}" != "false"; then
    ## OK for R_MAKEINDEXCMD to fail.
    ${R_MAKEINDEXCMD} Rd2
    ${R_PDFLATEXCMD} ${R_TEXOPTS} Rd2 || status=1
    if test $status -gt 0; then
      echo "Error in running pdflatex command ('${R_PDFLATEXCMD}')"
      do_cleanup
      exit 1
    fi
  fi
  ${R_PDFLATEXCMD} ${R_TEXOPTS} Rd2 &&
  ${R_PDFLATEXCMD} ${R_TEXOPTS} Rd2 || status=1
  if test $status -gt 0; then
    echo "Error in running pdflatex command ('${R_PDFLATEXCMD}')"
    do_cleanup
    exit 1
  fi
else
  ${R_LATEXCMD} ${R_TEXOPTS} Rd2 || status=1
  if test $status -gt 0; then
    echo "Error in running latex command ('${R_LATEXCMD}')"
    do_cleanup
    exit 1
  fi
  if test "${index}" != "false"; then
    ## OK for R_MAKEINDEXCMD to fail.
    ${R_MAKEINDEXCMD} Rd2
    ${R_LATEXCMD} ${R_TEXOPTS} Rd2 || status=1
    if test $status -gt 0; then
      echo "Error in running latex command ('${R_LATEXCMD}')"
      do_cleanup
      exit 1
    fi
  fi
  ${R_LATEXCMD} ${R_TEXOPTS} Rd2 || status=1
  if test $status -gt 0; then
    echo "Error in running latex command ('${R_LATEXCMD}')"
    do_cleanup
    exit 1
  fi
fi
if test ! -f Rd2.${out_ext}; then
  echo "Error: no output file was created"
  do_cleanup
  exit 1
fi
cd ${start_dir}
echo "Saving output to '${output}' ..."
cp ${build_dir}/Rd2.${out_ext} ${output}
echo "Done"

do_cleanup
${preview} ${output}
exit ${status}

### Local Variables: ***
### mode: sh ***
### sh-indentation: 2 ***
### End: ***
