/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;

public class PFixedWidthStroke
implements Stroke,
Serializable {
    private static PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static GeneralPath TEMP_PATH = new GeneralPath(1);
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private float width;
    private int join;
    private int cap;
    private float miterlimit;
    private float[] dash;
    private float dash_phase;
    public static final int[] RasterizerCaps = new int[]{30, 10, 20};
    public static final int[] RasterizerCorners = new int[]{50, 10, 40};

    public PFixedWidthStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float f) {
        this(f, 2, 0, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float f, int n, int n2) {
        this(f, n, n2, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float f, int n, int n2, float f2) {
        this(f, n, n2, f2, null, 0.0f);
    }

    public PFixedWidthStroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (n2 == 0) {
            if (f2 < 1.0f) {
                throw new IllegalArgumentException("miter limit < 1");
            }
        } else if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (fArray != null) {
            if (f3 < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean bl = true;
            for (int i = 0; i < fArray.length; ++i) {
                float f4 = fArray[i];
                if ((double)f4 > 0.0) {
                    bl = false;
                    continue;
                }
                if (!((double)f4 < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (bl) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = f;
        this.cap = n;
        this.join = n2;
        this.miterlimit = f2;
        if (fArray != null) {
            this.dash = (float[])fArray.clone();
        }
        this.dash_phase = f3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public Shape createStrokedShape(Shape shape) {
        PathStroker pathStroker;
        FillAdapter fillAdapter = new FillAdapter();
        PathStroker pathStroker2 = new PathStroker((PathConsumer)fillAdapter);
        float f = 1.0f;
        if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
            f = this.width / (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = 1.0;
        if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
            if (rectangle2D.getWidth() != 0.0) {
                d = (rectangle2D.getWidth() - (double)f) / rectangle2D.getWidth();
            }
        } else if (rectangle2D.getHeight() != 0.0) {
            d = (rectangle2D.getHeight() - (double)f) / rectangle2D.getHeight();
        }
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.scaleAboutPoint(d, rectangle2D.getCenterX(), rectangle2D.getCenterY());
        pathStroker2.setPenDiameter(f);
        PathIterator pathIterator = shape.getPathIterator(TEMP_TRANSFORM);
        pathStroker2.setPenT4(null);
        pathStroker2.setCaps(RasterizerCaps[this.cap]);
        pathStroker2.setCorners(RasterizerCorners[this.join], this.miterlimit);
        if (this.dash != null) {
            PathDasher pathDasher = new PathDasher((PathConsumer)pathStroker2);
            pathDasher.setDash(this.dash, this.dash_phase);
            pathDasher.setDashT4(null);
            pathStroker = pathDasher;
        } else {
            pathStroker = pathStroker2;
        }
        try {
            pathStroker.beginPath();
            boolean bl = false;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(fArray);
                if (bl) {
                    bl = false;
                    if (n != 0) {
                        pathStroker.beginSubpath(f2, f3);
                    }
                }
                switch (n) {
                    case 0: {
                        f2 = fArray[0];
                        f3 = fArray[1];
                        pathStroker.beginSubpath(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        pathStroker.appendLine(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        pathStroker.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        pathStroker.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        pathStroker.closedSubpath();
                        bl = true;
                    }
                }
                pathIterator.next();
            }
            pathStroker.endPath();
        }
        catch (PathException pathException) {
            throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
        }
        return fillAdapter.getShape();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PFixedWidthStroke)) {
            return false;
        }
        PFixedWidthStroke pFixedWidthStroke = (PFixedWidthStroke)object;
        if (this.width != pFixedWidthStroke.width) {
            return false;
        }
        if (this.join != pFixedWidthStroke.join) {
            return false;
        }
        if (this.cap != pFixedWidthStroke.cap) {
            return false;
        }
        if (this.miterlimit != pFixedWidthStroke.miterlimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dash_phase != pFixedWidthStroke.dash_phase) {
                return false;
            }
            if (!Arrays.equals(this.dash, pFixedWidthStroke.dash)) {
                return false;
            }
        } else if (pFixedWidthStroke.dash != null) {
            return false;
        }
        return true;
    }

    public float[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getLineWidth() {
        return this.width;
    }

    public float getMiterLimit() {
        return this.miterlimit;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.width);
        n = n * 31 + this.join;
        n = n * 31 + this.cap;
        n = n * 31 + Float.floatToIntBits(this.miterlimit);
        if (this.dash != null) {
            n = n * 31 + Float.floatToIntBits(this.dash_phase);
            for (int i = 0; i < this.dash.length; ++i) {
                n = n * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return n;
    }

    static /* synthetic */ GeneralPath access$000() {
        return TEMP_PATH;
    }

    public class FillAdapter
    implements PathConsumer {
        boolean closed;
        GeneralPath path = PFixedWidthStroke.access$000();

        public FillAdapter() {
            this.path.reset();
        }

        public Shape getShape() {
            return this.path;
        }

        public void beginPath() {
        }

        public void beginSubpath(float f, float f2) {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
            this.path.moveTo(f, f2);
        }

        public void appendLine(float f, float f2) {
            this.path.lineTo(f, f2);
        }

        public void appendQuadratic(float f, float f2, float f3, float f4) {
            this.path.quadTo(f, f2, f3, f4);
        }

        public void appendCubic(float f, float f2, float f3, float f4, float f5, float f6) {
            this.path.curveTo(f, f2, f3, f4, f5, f6);
        }

        public void closedSubpath() {
            this.closed = true;
        }

        public void endPath() {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
        }

        public void useProxy(FastPathProducer fastPathProducer) throws PathException {
            fastPathProducer.sendTo((PathConsumer)this);
        }

        public long getCPathConsumer() {
            return 0L;
        }

        public void dispose() {
        }

        public PathConsumer getConsumer() {
            return null;
        }
    }
}

