/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import edu.umd.cs.piccolox.swt.SWTShapeManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PSWTPath
extends PNode {
    public static final String PROPERTY_SHAPE = "shape";
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    private Paint strokePaint = DEFAULT_STROKE_PAINT;
    Shape shape;
    double[] shapePts;

    public static PSWTPath createRectangle(float f, float f2, float f3, float f4) {
        TEMP_RECTANGLE.setFrame(f, f2, f3, f4);
        PSWTPath pSWTPath = new PSWTPath(TEMP_RECTANGLE);
        pSWTPath.setPaint(Color.white);
        return pSWTPath;
    }

    public static PSWTPath createEllipse(float f, float f2, float f3, float f4) {
        TEMP_ELLIPSE.setFrame(f, f2, f3, f4);
        PSWTPath pSWTPath = new PSWTPath(TEMP_ELLIPSE);
        pSWTPath.setPaint(Color.white);
        return pSWTPath;
    }

    public static PSWTPath createPolyline(Point2D[] point2DArray) {
        PSWTPath pSWTPath = new PSWTPath();
        pSWTPath.setPathToPolyline(point2DArray);
        pSWTPath.setPaint(Color.white);
        return pSWTPath;
    }

    public static PSWTPath createPolyline(float[] fArray, float[] fArray2) {
        PSWTPath pSWTPath = new PSWTPath();
        pSWTPath.setPathToPolyline(fArray, fArray2);
        pSWTPath.setPaint(Color.white);
        return pSWTPath;
    }

    public PSWTPath() {
    }

    public PSWTPath(Shape shape) {
        this();
        this.setShape(shape);
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokeColor(Paint paint) {
        Paint paint2 = this.strokePaint;
        this.strokePaint = paint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", paint2, this.strokePaint);
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        return super.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (super.intersects(rectangle2D)) {
            if (this.getPaint() != null && this.shape.intersects(rectangle2D)) {
                return true;
            }
            if (this.strokePaint != null) {
                return BASIC_STROKE.createStrokedShape(this.shape).intersects(rectangle2D);
            }
        }
        return false;
    }

    public void updateBoundsFromPath() {
        if (this.shape == null) {
            this.resetBounds();
        } else {
            Rectangle2D rectangle2D = this.shape.getBounds2D();
            super.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        Paint paint = this.getPaint();
        SWTGraphics2D sWTGraphics2D = (SWTGraphics2D)pPaintContext.getGraphics();
        if (paint != null) {
            sWTGraphics2D.setBackground((Color)paint);
            if (this.shape instanceof Rectangle2D) {
                sWTGraphics2D.fillRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Ellipse2D) {
                sWTGraphics2D.fillOval(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Arc2D) {
                sWTGraphics2D.fillArc(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else if (this.shape instanceof RoundRectangle2D) {
                sWTGraphics2D.fillRoundRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else {
                sWTGraphics2D.fillPolygon(this.shapePts);
            }
        }
        if (this.strokePaint != null) {
            sWTGraphics2D.setColor((Color)this.strokePaint);
            if (this.shape instanceof Rectangle2D) {
                sWTGraphics2D.drawRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Ellipse2D) {
                sWTGraphics2D.drawOval(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3]);
            } else if (this.shape instanceof Arc2D) {
                sWTGraphics2D.drawArc(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else if (this.shape instanceof RoundRectangle2D) {
                sWTGraphics2D.drawRoundRect(this.shapePts[0], this.shapePts[1], this.shapePts[2], this.shapePts[3], this.shapePts[4], this.shapePts[5]);
            } else {
                sWTGraphics2D.drawPolyline(this.shapePts);
            }
        }
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        if (this.shape instanceof Rectangle2D) {
            this.shapePts = new double[4];
            this.shapePts[0] = ((Rectangle2D)this.shape).getX();
            this.shapePts[1] = ((Rectangle2D)this.shape).getY();
            this.shapePts[2] = ((Rectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((Rectangle2D)this.shape).getHeight();
        } else if (this.shape instanceof Ellipse2D) {
            this.shapePts = new double[4];
            this.shapePts[0] = ((Ellipse2D)this.shape).getX();
            this.shapePts[1] = ((Ellipse2D)this.shape).getY();
            this.shapePts[2] = ((Ellipse2D)this.shape).getWidth();
            this.shapePts[3] = ((Ellipse2D)this.shape).getHeight();
        } else if (this.shape instanceof Arc2D) {
            this.shapePts = new double[6];
            this.shapePts[0] = ((Arc2D)this.shape).getX();
            this.shapePts[1] = ((Arc2D)this.shape).getY();
            this.shapePts[2] = ((Arc2D)this.shape).getWidth();
            this.shapePts[3] = ((Arc2D)this.shape).getHeight();
            this.shapePts[4] = ((Arc2D)this.shape).getAngleStart();
            this.shapePts[5] = ((Arc2D)this.shape).getAngleExtent();
        } else if (this.shape instanceof RoundRectangle2D) {
            this.shapePts = new double[6];
            this.shapePts[0] = ((RoundRectangle2D)this.shape).getX();
            this.shapePts[1] = ((RoundRectangle2D)this.shape).getY();
            this.shapePts[2] = ((RoundRectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((RoundRectangle2D)this.shape).getHeight();
            this.shapePts[4] = ((RoundRectangle2D)this.shape).getArcWidth();
            this.shapePts[5] = ((RoundRectangle2D)this.shape).getArcHeight();
        } else {
            this.shapePts = SWTShapeManager.shapeToPolyline(this.shape);
        }
        this.firePropertyChange(262144, "path", null, this.shape);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathToRectangle(float f, float f2, float f3, float f4) {
        TEMP_RECTANGLE.setFrame(f, f2, f3, f4);
        this.setShape(TEMP_RECTANGLE);
    }

    public void setPathToEllipse(float f, float f2, float f3, float f4) {
        TEMP_ELLIPSE.setFrame(f, f2, f3, f4);
        this.setShape(TEMP_ELLIPSE);
    }

    public void setPathToPolyline(Point2D[] point2DArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
        for (int i = 1; i < point2DArray.length; ++i) {
            generalPath.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
        }
        this.setShape(generalPath);
    }

    public void setPathToPolyline(float[] fArray, float[] fArray2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(fArray[0], fArray2[0]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i], fArray2[i]);
        }
        this.setShape(generalPath);
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("path=" + (this.shape == null ? "null" : this.shape.toString()));
        stringBuffer.append(",strokePaint=" + (this.strokePaint == null ? "null" : this.strokePaint.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

