/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.handles;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.ListIterator;

public class PBoundsHandle
extends PHandle {
    private PBasicInputEventHandler handleCursorHandler;

    public static void addBoundsHandlesTo(PNode pNode) {
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createEastLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createWestLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createNorthLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createSouthLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createNorthEastLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createNorthWestLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createSouthEastLocator(pNode)));
        pNode.addChild(new PBoundsHandle(PBoundsLocator.createSouthWestLocator(pNode)));
    }

    public static void addStickyBoundsHandlesTo(PNode pNode, PCamera pCamera) {
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createEastLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createWestLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createNorthLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createSouthLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createNorthEastLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createNorthWestLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createSouthEastLocator(pNode)));
        pCamera.addChild(new PBoundsHandle(PBoundsLocator.createSouthWestLocator(pNode)));
    }

    public static void removeBoundsHandlesFrom(PNode pNode) {
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        ListIterator listIterator = pNode.getChildrenIterator();
        while (listIterator.hasNext()) {
            PNode pNode2 = (PNode)listIterator.next();
            if (!(pNode2 instanceof PBoundsHandle)) continue;
            arrayList.add(pNode2);
        }
        pNode.removeChildren(arrayList);
    }

    public PBoundsHandle(PBoundsLocator pBoundsLocator) {
        super(pBoundsLocator);
    }

    protected void installHandleEventHandlers() {
        super.installHandleEventHandlers();
        this.handleCursorHandler = new PBasicInputEventHandler(){
            boolean cursorPushed = false;

            public void mouseEntered(PInputEvent pInputEvent) {
                if (!this.cursorPushed) {
                    pInputEvent.pushCursor(PBoundsHandle.this.getCursorFor(((PBoundsLocator)PBoundsHandle.this.getLocator()).getSide()));
                    this.cursorPushed = true;
                }
            }

            public void mouseExited(PInputEvent pInputEvent) {
                PPickPath pPickPath = pInputEvent.getInputManager().getMouseFocus();
                if (this.cursorPushed && (pPickPath == null || pPickPath.getPickedNode() != PBoundsHandle.this)) {
                    pInputEvent.popCursor();
                    this.cursorPushed = false;
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (this.cursorPushed) {
                    pInputEvent.popCursor();
                    this.cursorPushed = false;
                }
            }
        };
        this.addInputEventListener(this.handleCursorHandler);
    }

    public PBasicInputEventHandler getHandleCursorEventHandler() {
        return this.handleCursorHandler;
    }

    public void startHandleDrag(Point2D point2D, PInputEvent pInputEvent) {
        PBoundsLocator pBoundsLocator = (PBoundsLocator)this.getLocator();
        pBoundsLocator.getNode().startResizeBounds();
    }

    public void dragHandle(PDimension pDimension, PInputEvent pInputEvent) {
        PBoundsLocator pBoundsLocator = (PBoundsLocator)this.getLocator();
        PNode pNode = pBoundsLocator.getNode();
        PBounds pBounds = pNode.getBounds();
        PNode pNode2 = this.getParent();
        if (pNode2 != pNode && pNode2 instanceof PCamera) {
            ((PCamera)pNode2).localToView(pDimension);
        }
        this.localToGlobal(pDimension);
        pNode.globalToLocal(pDimension);
        double d = pDimension.getWidth();
        double d2 = pDimension.getHeight();
        switch (pBoundsLocator.getSide()) {
            case 1: {
                pBounds.setRect(pBounds.x, pBounds.y + d2, pBounds.width, pBounds.height - d2);
                break;
            }
            case 5: {
                pBounds.setRect(pBounds.x, pBounds.y, pBounds.width, pBounds.height + d2);
                break;
            }
            case 3: {
                pBounds.setRect(pBounds.x, pBounds.y, pBounds.width + d, pBounds.height);
                break;
            }
            case 7: {
                pBounds.setRect(pBounds.x + d, pBounds.y, pBounds.width - d, pBounds.height);
                break;
            }
            case 8: {
                pBounds.setRect(pBounds.x + d, pBounds.y + d2, pBounds.width - d, pBounds.height - d2);
                break;
            }
            case 6: {
                pBounds.setRect(pBounds.x + d, pBounds.y, pBounds.width - d, pBounds.height + d2);
                break;
            }
            case 2: {
                pBounds.setRect(pBounds.x, pBounds.y + d2, pBounds.width + d, pBounds.height - d2);
                break;
            }
            case 4: {
                pBounds.setRect(pBounds.x, pBounds.y, pBounds.width + d, pBounds.height + d2);
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if (pBounds.width < 0.0) {
            bl = true;
            pBounds.width = -pBounds.width;
            pBounds.x -= pBounds.width;
        }
        if (pBounds.height < 0.0) {
            bl2 = true;
            pBounds.height = -pBounds.height;
            pBounds.y -= pBounds.height;
        }
        if (bl || bl2) {
            this.flipSiblingBoundsHandles(bl, bl2);
        }
        pNode.setBounds(pBounds);
    }

    public void endHandleDrag(Point2D point2D, PInputEvent pInputEvent) {
        PBoundsLocator pBoundsLocator = (PBoundsLocator)this.getLocator();
        pBoundsLocator.getNode().endResizeBounds();
    }

    public void flipSiblingBoundsHandles(boolean bl, boolean bl2) {
        ListIterator listIterator = this.getParent().getChildrenIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof PBoundsHandle)) continue;
            ((PBoundsHandle)e).flipHandleIfNeeded(bl, bl2);
        }
    }

    public void flipHandleIfNeeded(boolean bl, boolean bl2) {
        PBoundsLocator pBoundsLocator = (PBoundsLocator)this.getLocator();
        if (bl || bl2) {
            switch (pBoundsLocator.getSide()) {
                case 1: {
                    if (!bl2) break;
                    pBoundsLocator.setSide(5);
                    break;
                }
                case 5: {
                    if (!bl2) break;
                    pBoundsLocator.setSide(1);
                    break;
                }
                case 3: {
                    if (!bl) break;
                    pBoundsLocator.setSide(7);
                    break;
                }
                case 7: {
                    if (!bl) break;
                    pBoundsLocator.setSide(3);
                    break;
                }
                case 8: {
                    if (bl && bl2) {
                        pBoundsLocator.setSide(4);
                        break;
                    }
                    if (bl) {
                        pBoundsLocator.setSide(2);
                        break;
                    }
                    if (!bl2) break;
                    pBoundsLocator.setSide(6);
                    break;
                }
                case 6: {
                    if (bl && bl2) {
                        pBoundsLocator.setSide(2);
                        break;
                    }
                    if (bl) {
                        pBoundsLocator.setSide(4);
                        break;
                    }
                    if (!bl2) break;
                    pBoundsLocator.setSide(8);
                    break;
                }
                case 2: {
                    if (bl && bl2) {
                        pBoundsLocator.setSide(6);
                        break;
                    }
                    if (bl) {
                        pBoundsLocator.setSide(8);
                        break;
                    }
                    if (!bl2) break;
                    pBoundsLocator.setSide(4);
                    break;
                }
                case 4: {
                    if (bl && bl2) {
                        pBoundsLocator.setSide(8);
                        break;
                    }
                    if (bl) {
                        pBoundsLocator.setSide(6);
                        break;
                    }
                    if (!bl2) break;
                    pBoundsLocator.setSide(2);
                }
            }
        }
        this.setLocator(pBoundsLocator);
    }

    public Cursor getCursorFor(int n) {
        switch (n) {
            case 1: {
                return new Cursor(8);
            }
            case 5: {
                return new Cursor(9);
            }
            case 3: {
                return new Cursor(11);
            }
            case 7: {
                return new Cursor(10);
            }
            case 8: {
                return new Cursor(6);
            }
            case 6: {
                return new Cursor(4);
            }
            case 2: {
                return new Cursor(7);
            }
            case 4: {
                return new Cursor(5);
            }
        }
        return null;
    }
}

