/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox;

import edu.umd.cs.piccolo.PCanvas;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class PFrame
extends JFrame {
    private PCanvas canvas;
    private GraphicsDevice graphicsDevice;
    private DisplayMode originalDisplayMode;
    private EventListener escapeFullScreenModeListener;

    public PFrame() {
        this(false, null);
    }

    public PFrame(boolean bl, PCanvas pCanvas) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), bl, pCanvas);
    }

    public PFrame(GraphicsDevice graphicsDevice, boolean bl, PCanvas pCanvas) {
        super(graphicsDevice.getDefaultConfiguration());
        this.graphicsDevice = graphicsDevice;
        try {
            this.originalDisplayMode = this.graphicsDevice.getDisplayMode();
        }
        catch (InternalError internalError) {
            internalError.printStackTrace();
        }
        this.setBounds(this.getDefaultFrameBounds());
        this.setBackground(null);
        try {
            this.setDefaultCloseOperation(3);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.canvas = pCanvas == null ? new PCanvas() : pCanvas;
        this.getContentPane().add(this.canvas);
        this.validate();
        this.setFullScreenMode(bl);
        this.canvas.requestFocus();
        this.beforeInitialize();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PFrame.this.initialize();
                PFrame.this.repaint();
            }
        });
    }

    public PCanvas getCanvas() {
        return this.canvas;
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(100, 100, 400, 400);
    }

    public void setFullScreenMode(boolean bl) {
        if (bl) {
            this.addEscapeFullScreenModeListener();
            if (this.isDisplayable()) {
                this.dispose();
            }
            this.setUndecorated(true);
            this.setResizable(false);
            this.graphicsDevice.setFullScreenWindow(this);
            if (this.graphicsDevice.isDisplayChangeSupported()) {
                this.chooseBestDisplayMode(this.graphicsDevice);
            }
            this.validate();
        } else {
            this.removeEscapeFullScreenModeListener();
            if (this.isDisplayable()) {
                this.dispose();
            }
            this.setUndecorated(false);
            this.setResizable(true);
            this.graphicsDevice.setFullScreenWindow(null);
            this.validate();
            this.setVisible(true);
        }
    }

    protected void chooseBestDisplayMode(GraphicsDevice graphicsDevice) {
        DisplayMode displayMode = this.getBestDisplayMode(graphicsDevice);
        if (displayMode != null) {
            graphicsDevice.setDisplayMode(displayMode);
        }
    }

    protected DisplayMode getBestDisplayMode(GraphicsDevice graphicsDevice) {
        Iterator iterator = this.getPreferredDisplayModes(graphicsDevice).iterator();
        while (iterator.hasNext()) {
            DisplayMode displayMode = (DisplayMode)iterator.next();
            DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
            for (int i = 0; i < displayModeArray.length; ++i) {
                if (displayModeArray[i].getWidth() != displayMode.getWidth() || displayModeArray[i].getHeight() != displayMode.getHeight() || displayModeArray[i].getBitDepth() != displayMode.getBitDepth()) continue;
                return displayMode;
            }
        }
        return null;
    }

    protected Collection getPreferredDisplayModes(GraphicsDevice graphicsDevice) {
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        arrayList.add(graphicsDevice.getDisplayMode());
        return arrayList;
    }

    public void addEscapeFullScreenModeListener() {
        this.removeEscapeFullScreenModeListener();
        this.escapeFullScreenModeListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PFrame.this.setFullScreenMode(false);
                }
            }
        };
        this.canvas.addKeyListener((KeyListener)this.escapeFullScreenModeListener);
    }

    public void removeEscapeFullScreenModeListener() {
        if (this.escapeFullScreenModeListener != null) {
            this.canvas.removeKeyListener((KeyListener)this.escapeFullScreenModeListener);
            this.escapeFullScreenModeListener = null;
        }
    }

    public void beforeInitialize() {
    }

    public void initialize() {
    }

    public static void main(String[] stringArray) {
        new PFrame();
    }
}

