/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.utils.CommandExecutionException;

public class ProcessRunner {
    private boolean stdoutFinished;
    private boolean stderrFinished;
    private String[] stdout;
    private String[] stderr;
    private boolean redirect = false;
    private boolean unrecoverableException = false;
    private final Log log = LogFactory.getLog(ProcessRunner.class);

    public synchronized void redirectStderr(boolean redirect) {
        this.redirect = redirect;
    }

    public synchronized String[] runCommmand(String command) throws CommandExecutionException, IOException {
        final Process process = System.getProperty("os.name").contains("Windows") ? new ProcessBuilder("cmd.exe", "/c", command).start() : new ProcessBuilder("/bin/sh", "-c", command).start();
        this.log.debug("Executing native runtime process [" + command + "]");
        new Thread(){

            public void run() {
                ProcessRunner.this.log.debug("Monitoring stdout for native runtime process...");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                ArrayList<String> output = new ArrayList<String>();
                try {
                    String outputLine;
                    while ((outputLine = reader.readLine()) != null) {
                        output.add(outputLine);
                    }
                }
                catch (IOException e) {
                    ProcessRunner.this.log.debug("Encountered an error reading from process stdout,");
                    ProcessRunner.this.unrecoverableException = true;
                }
                ProcessRunner.this.log.debug("Finished monitoring stdout of runtime process, read " + output.size() + " lines");
                ProcessRunner.this.updateStdout(output.toArray(new String[output.size()]));
                ProcessRunner.this.stdoutStreamFinished();
            }
        }.start();
        new Thread(){

            public void run() {
                ProcessRunner.this.log.debug("Monitoring stderr for native runtime process...");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                ArrayList<String> errors = new ArrayList<String>();
                try {
                    String errorLine;
                    while ((errorLine = reader.readLine()) != null) {
                        errors.add(errorLine);
                    }
                }
                catch (IOException e) {
                    ProcessRunner.this.unrecoverableException = true;
                }
                ProcessRunner.this.log.debug("Finished monitoring stderr of runtime process, read " + errors.size() + " lines");
                ProcessRunner.this.updateStderr(errors.toArray(new String[errors.size()]));
                ProcessRunner.this.stderrStreamFinished();
            }
        }.start();
        try {
            if (this.isComplete()) {
                int exitCode = -1;
                while (exitCode < 0) {
                    try {
                        exitCode = process.waitFor();
                    }
                    catch (InterruptedException e) {}
                }
                if (exitCode > 0) {
                    this.log.error("Return code was " + exitCode + " for " + command + ", throwing an exception");
                    throw new CommandExecutionException(this.stderr);
                }
                if (this.redirect) {
                    this.log.debug("Return code was " + exitCode + " for " + command + ", redirecting stderr");
                    ArrayList<String> result = new ArrayList<String>();
                    result.addAll(Arrays.asList(this.stdout));
                    if (this.stderr.length > 0) {
                        result.add("");
                        result.add("***** THIS OPERATION PRODUCED ERRORS/WARNINGS.  OUTPUT FOR DEBUGGING: *****");
                        result.addAll(Arrays.asList(this.stderr));
                        result.add("***************************************************************************");
                    }
                    String[] stringArray = result.toArray(new String[result.size()]);
                    return stringArray;
                }
                this.log.debug("Return code was " + exitCode + " for " + command + ", returning stdout");
                ArrayList<String> result = new ArrayList<String>();
                result.addAll(Arrays.asList(this.stdout));
                String[] stringArray = result.toArray(new String[result.size()]);
                return stringArray;
            }
            try {
                throw new IOException("Unrecoverable error whilst processing an external process (" + command + ")");
            }
            catch (Exception e) {
                throw new CommandExecutionException("An unrecoverable exception occurred whilst executing the external process (" + command + ")", e);
            }
        }
        finally {
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            process.destroy();
        }
    }

    private synchronized void stdoutStreamFinished() {
        this.stdoutFinished = true;
        this.notifyAll();
    }

    private synchronized void stderrStreamFinished() {
        this.stderrFinished = true;
        this.notifyAll();
    }

    private synchronized void updateStdout(String[] stdout) {
        this.stdout = stdout;
    }

    private synchronized void updateStderr(String[] stderr) {
        this.stderr = stderr;
    }

    private synchronized boolean isComplete() {
        this.log.debug("Checking completion of the process...");
        while (!this.stdoutFinished || !this.stderrFinished) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.unrecoverableException) {
            this.unrecoverableException = false;
            this.log.debug("Process completed with unrecoverable exception");
            return false;
        }
        this.log.debug("Process completed normally");
        return true;
    }
}

