/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;

public class MAGETABUtils {
    private static Log log = LogFactory.getLog(MAGETABUtils.class);

    public static boolean endsWithEscapedNewline(String line) {
        return line.split("\"").length % 2 != 0;
    }

    public static String digestHeader(String header) {
        String quals;
        String main;
        if (header.contains("[")) {
            main = header.substring(0, header.indexOf(91));
            quals = header.substring(header.indexOf("["), header.length());
        } else if (header.contains("(")) {
            main = header.substring(0, header.indexOf(40));
            quals = header.substring(header.indexOf("("), header.length());
        } else {
            main = header;
            quals = "";
        }
        main = main.trim();
        main = main.replaceAll("\\s", "");
        main = main.replaceAll("\"", "");
        main = main.toLowerCase();
        header = main + quals;
        return header;
    }

    public static File locateIDF(File mageTabFile) throws ParseException {
        for (File f : mageTabFile.listFiles()) {
            if (!f.getName().endsWith(".idf") && !f.getName().endsWith(".idf.txt")) continue;
            return f;
        }
        throw new ParseException("Could not determine the location of an IDF file  (*.idf, *.idf.txt) in directory " + mageTabFile.getName());
    }

    public static File locateSDRF(File mageTabFile) throws ParseException {
        for (File f : mageTabFile.listFiles()) {
            if (!f.getName().endsWith(".sdrf") && !f.getName().endsWith(".sdrf.txt")) continue;
            return f;
        }
        throw new ParseException("Could not determine the location of an SDRF file  (*.sdrf, *.sdrf.txt) in directory " + mageTabFile.getName());
    }

    public static boolean validateMAGETABDocument(MAGETABInvestigation investigation) throws IOException {
        return true;
    }
}

