/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.parser;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.handler.HandlerMode;
import uk.ac.ebi.arrayexpress2.magetab.handler.HandlerPool;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.FactorValueNodeHandler;
import uk.ac.ebi.arrayexpress2.magetab.parser.AbstractParser;
import uk.ac.ebi.arrayexpress2.magetab.utils.MAGETABUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDRFParser
extends AbstractParser<SDRF> {
    private final ExecutorService service;
    private MAGETABInvestigation investigation;
    private HandlerMode mode;
    private HandlerPool handlers;
    private final Map<Integer, Class<? extends SDRFHandler>> handlerIndex;
    private double percentage = 0.0;
    private Log log = LogFactory.getLog(this.getClass());

    public SDRFParser() {
        this(Executors.newCachedThreadPool());
    }

    public SDRFParser(ExecutorService service) {
        this.service = service;
        this.handlerIndex = new HashMap<Integer, Class<? extends SDRFHandler>>();
        this.handlers = HandlerPool.getInstance();
    }

    public synchronized MAGETABInvestigation getInvestigation() {
        if (this.investigation == null) {
            this.investigation = new MAGETABInvestigation();
        }
        return this.investigation;
    }

    public synchronized void setInvestigation(MAGETABInvestigation investigation) {
        this.investigation = investigation;
    }

    public HandlerMode getParsingMode() {
        return this.mode;
    }

    public void setParsingMode(HandlerMode mode) {
        this.mode = mode;
    }

    @Override
    public SDRF parse(URL sdrfSource) throws ParseException {
        this.log.info("Starting SDRF parsing...");
        Future<String[][]> tabulatorTask = this.service.submit(this.createTabulatorTask(sdrfSource));
        try {
            String[][] sdrfTable = tabulatorTask.get();
            HashSet<Future<MAGETABInvestigation>> tasks = new HashSet<Future<MAGETABInvestigation>>();
            String[] headers = sdrfTable[0];
            int rowCount = sdrfTable.length - 1;
            int hplCount = this.countHandlersRequired(headers);
            int handlerCount = rowCount * hplCount;
            this.getInvestigation().SDRF.setNumberOfTasks(handlerCount);
            this.percentage = 100.0 / (double)handlerCount;
            this.log.debug("Starting tasks to handle and import SDRF...");
            for (int i = 1; i < sdrfTable.length; ++i) {
                int n = (i - 1) * hplCount;
                int columnIndex = 0;
                String[] row = sdrfTable[i];
                for (int nextStartPos : this.handlerIndex.keySet()) {
                    Future<MAGETABInvestigation> task;
                    int taskIndex = n + columnIndex;
                    if (this.handlerIndex.get(nextStartPos) == FactorValueNodeHandler.class) {
                        task = this.service.submit(this.createSpecialParserTaskForFactorValues(headers, row, nextStartPos, taskIndex));
                    } else {
                        String[] headerData = Arrays.copyOfRange(headers, nextStartPos, headers.length);
                        String[] rowData = Arrays.copyOfRange(row, nextStartPos, row.length);
                        task = this.service.submit(this.createHandlerTask(headerData, rowData, taskIndex));
                    }
                    tasks.add(task);
                    ++columnIndex;
                }
            }
            for (Future future : tasks) {
                future.get();
            }
            this.log.info("SDRF parsing and syntactic validation finished");
            return this.getInvestigation().SDRF;
        }
        catch (InterruptedException e) {
            this.getInvestigation().SDRF.setStatus(Status.FAILED);
            throw new ParseException("The SDRF file could not be imported; import was interrupted", e);
        }
        catch (ExecutionException e) {
            this.getInvestigation().SDRF.setStatus(Status.FAILED);
            throw new ParseException("The SDRF file could not be imported", e.getCause());
        }
        catch (ParseException e) {
            this.getInvestigation().SDRF.setStatus(Status.FAILED);
            throw new ParseException("The SDRF file could not be parsed", e);
        }
    }

    private Callable<String[][]> createTabulatorTask(final URL sdrfSource) {
        return new Callable<String[][]>(){

            @Override
            public String[][] call() throws Exception {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(sdrfSource.openConnection().getInputStream()));
                boolean doneHeader = false;
                ArrayList tempStore = null;
                while ((line = reader.readLine()) != null) {
                    String[] tokens;
                    line = SDRFParser.this.removeWhitespaceNullsAndComments(line);
                    if (doneHeader) {
                        if (line.equals("") || line.startsWith("#")) continue;
                        tokens = line.split("\t");
                        if (tokens.length != ((List)tempStore.get(0)).size()) {
                            throw new IllegalLineLengthException("Wrong number of elements! Expected " + ((List)tempStore.get(0)).size() + " but got " + tokens.length);
                        }
                        ArrayList<String> entry = new ArrayList<String>();
                        entry.addAll(Arrays.asList(tokens));
                        tempStore.add(entry);
                        continue;
                    }
                    if (line.equals("")) continue;
                    tempStore = new ArrayList();
                    tokens = line.split("\t");
                    ArrayList<String> headers = new ArrayList<String>();
                    for (String header : tokens) {
                        headers.add(MAGETABUtils.digestHeader(header));
                    }
                    tempStore.add(headers);
                    doneHeader = true;
                }
                reader.close();
                if (tempStore != null) {
                    String[][] tabulated = new String[tempStore.size()][];
                    for (int i = 0; i < tabulated.length; ++i) {
                        List row = (List)tempStore.get(i);
                        tabulated[i] = new String[row.size()];
                        tabulated[i] = row.toArray(new String[row.size()]);
                    }
                    return tabulated;
                }
                return new String[0][0];
            }
        };
    }

    private Callable<MAGETABInvestigation> createHandlerTask(final String[] headerData, final String[] rowData, int taskIndex) {
        final int localIndex = taskIndex;
        return new Callable<MAGETABInvestigation>(){

            @Override
            public MAGETABInvestigation call() throws ParseException {
                String tag = MAGETABUtils.digestHeader(headerData[0]);
                SDRFParser.this.log.debug("Handler for tag '" + tag + "' located at index " + localIndex);
                try {
                    SDRFHandler handler = SDRFParser.this.handlers.getSDRFHandler(tag, headerData, rowData, SDRFParser.this.getInvestigation(), localIndex, SDRFParser.this.percentage);
                    handler.setHandlerMode(SDRFParser.this.mode);
                    String row = "";
                    for (String s : rowData) {
                        row = row.concat(s + "; ");
                    }
                    SDRFParser.this.log.debug("Handling data with " + handler.toString() + "; tag = " + tag + ", line data = " + row);
                    handler.handle();
                    SDRFParser.this.handlers.relinquishSDRFHandler(handler);
                    return SDRFParser.this.getInvestigation();
                }
                catch (ParseException e) {
                    if (e.getCause() != null) {
                        throw new ParseException(e.getMessage(), e.getCause());
                    }
                    if (e.getMessage() != null && !e.getMessage().equals("")) {
                        throw new ParseException(e.getMessage());
                    }
                    throw new ParseException("A problem with parsing was encountered");
                }
                catch (ObjectConversionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof ParseException) {
                            throw (ParseException)e.getCause();
                        }
                        throw new ParseException(e.getMessage(), e.getCause());
                    }
                    if (e.getMessage() != null && !e.getMessage().equals("")) {
                        throw new ParseException(e.getMessage());
                    }
                    throw new ParseException("A problem with parsing was encountered");
                }
                catch (NullPointerException e) {
                    throw new ParseException(e);
                }
            }
        };
    }

    private Callable<MAGETABInvestigation> createSpecialParserTaskForFactorValues(final String[] headerData, final String[] rowData, int startIndex, int taskIndex) {
        final int localStartIndex = startIndex;
        final int localTaskIndex = taskIndex;
        return new Callable<MAGETABInvestigation>(){

            @Override
            public MAGETABInvestigation call() throws Exception {
                String tag = MAGETABUtils.digestHeader(headerData[0]);
                try {
                    SDRFHandler handler = SDRFParser.this.handlers.getSDRFHandler(tag, headerData, rowData, SDRFParser.this.getInvestigation(), localTaskIndex, SDRFParser.this.percentage);
                    handler.setHandlerMode(HandlerMode.READ_ONLY);
                    if (handler instanceof FactorValueNodeHandler) {
                        FactorValueNodeHandler fvnHandler = (FactorValueNodeHandler)handler;
                        fvnHandler.setStartIndex(localStartIndex);
                        fvnHandler.handle();
                        SDRFParser.this.handlers.relinquishSDRFHandler(fvnHandler);
                        return SDRFParser.this.getInvestigation();
                    }
                    throw new ParseException("Don't use a FactorValue handler method call if you're not handling FactorValues!");
                }
                catch (ParseException e) {
                    if (e.getCause() != null) {
                        throw new ParseException(e.getMessage(), e.getCause());
                    }
                    if (e.getMessage() != null && !e.getMessage().equals("")) {
                        throw new ParseException(e.getMessage());
                    }
                    throw new ParseException("A problem with parsing was encountered");
                }
                catch (ObjectConversionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof ParseException) {
                            throw (ParseException)e.getCause();
                        }
                        throw new ParseException(e.getMessage(), e.getCause());
                    }
                    if (e.getMessage() != null && !e.getMessage().equals("")) {
                        throw new ParseException(e.getMessage());
                    }
                    throw new ParseException("A problem with parsing was encountered");
                }
                catch (NullPointerException e) {
                    throw new ParseException(e);
                }
            }
        };
    }

    private int countHandlersRequired(String[] headers) throws ParseException {
        SDRFHandler handler;
        int handlerCount = 0;
        for (int index = 0; index < headers.length; index += handler.assess()) {
            ++handlerCount;
            String tag = MAGETABUtils.digestHeader(headers[index]);
            String[] headerData = Arrays.copyOfRange(headers, index, headers.length);
            MAGETABInvestigation investigation = new MAGETABInvestigation();
            String[] rowData = new String[headerData.length];
            for (int i = 0; i < rowData.length; ++i) {
                rowData[i] = "";
            }
            handler = this.handlers.getSDRFHandler(tag, headerData, rowData, investigation, -1, 0.0);
            handler.setHandlerMode(HandlerMode.READ_ONLY);
            this.handlerIndex.put(index, handler.getClass());
        }
        return handlerCount;
    }

    private String removeWhitespaceNullsAndComments(String line) {
        if ((line = line.trim()) == null) {
            return "";
        }
        if (line.startsWith("#")) {
            return "";
        }
        return line;
    }

    @Override
    public int getProgress() {
        return this.getInvestigation().SDRF.getProgress();
    }
}

