/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.parser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.IDF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.handler.HandlerMode;
import uk.ac.ebi.arrayexpress2.magetab.parser.AbstractParser;
import uk.ac.ebi.arrayexpress2.magetab.parser.IDFParser;
import uk.ac.ebi.arrayexpress2.magetab.parser.SDRFParser;
import uk.ac.ebi.arrayexpress2.magetab.utils.MAGETABUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAGETABParser
extends AbstractParser<MAGETABInvestigation> {
    private final ExecutorService service;
    private HandlerMode mode;
    private boolean shutdownOnCompletion = true;
    private boolean greenLight;
    private Log log = LogFactory.getLog(this.getClass());

    public MAGETABParser() {
        this(HandlerMode.READ_ONLY);
    }

    public MAGETABParser(HandlerMode parsingMode) {
        this.service = Executors.newCachedThreadPool();
        this.mode = parsingMode;
    }

    public HandlerMode getParsingMode() {
        return this.mode;
    }

    public void setParsingMode(HandlerMode mode) {
        this.mode = mode;
    }

    public boolean getShutdownOnCompletion() {
        return this.shutdownOnCompletion;
    }

    public void setShutdownOnCompletion(boolean shutdownOnCompletion) {
        this.shutdownOnCompletion = shutdownOnCompletion;
    }

    @Override
    public MAGETABInvestigation parse(URL magetabSource) throws ParseException {
        this.log.debug("Creating new investigation, and monitoring progress");
        MAGETABInvestigation investigation = new MAGETABInvestigation();
        return this.parse(magetabSource, investigation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAGETABInvestigation parse(final URL magetabSource, MAGETABInvestigation investigation) throws ParseException {
        try {
            this.log.info("Importing MAGE-TAB from  " + magetabSource.toString());
            this.greenLight = true;
            this.monitorProgress(investigation);
            this.updateProgress(0);
            this.log.debug("Setting up IDF import...");
            final IDFParser idfParser = new IDFParser(this.service);
            idfParser.setInvestigation(investigation);
            idfParser.setParsingMode(this.mode);
            Future<IDF> idfParse = this.service.submit(new Callable<IDF>(){

                @Override
                public IDF call() throws ParseException {
                    try {
                        return idfParser.parse(magetabSource);
                    }
                    catch (ParseException e) {
                        MAGETABParser.this.greenLight = false;
                        throw e;
                    }
                }
            });
            this.log.debug("IDF import started");
            while (this.greenLight && investigation.IDF.getStatus().ordinal() <= Status.READING.ordinal()) {
                IDF iDF = investigation.IDF;
                synchronized (iDF) {
                    try {
                        investigation.IDF.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            this.log.debug("Setting up SDRF import(s)");
            HashSet<Future<SDRF>> sdrfParse = new HashSet<Future<SDRF>>();
            for (String string : investigation.IDF.sdrfFile) {
                File magetabFilePath = new File(magetabSource.getFile());
                File sdrfFilePath = new File(magetabFilePath.getParentFile(), string);
                final URL sdrfSource = magetabSource.getPort() == -1 ? new URL(magetabSource.getProtocol(), magetabSource.getHost(), sdrfFilePath.toString()) : new URL(magetabSource.getProtocol(), magetabSource.getHost(), magetabSource.getPort(), sdrfFilePath.toString());
                this.log.debug("Attempting parse from " + sdrfSource.toString());
                final SDRFParser sdrfParser = new SDRFParser(this.service);
                sdrfParser.setInvestigation(investigation);
                sdrfParser.setParsingMode(this.mode);
                sdrfParse.add(this.service.submit(new Callable<SDRF>(){

                    @Override
                    public SDRF call() throws Exception {
                        try {
                            return sdrfParser.parse(sdrfSource);
                        }
                        catch (ParseException e) {
                            MAGETABParser.this.greenLight = false;
                            throw e;
                        }
                    }
                }));
            }
            this.log.debug("SDRF import(s) started");
            idfParse.get();
            for (Future future : sdrfParse) {
                future.get();
            }
            this.log.debug("All import tasks completed, doing a validation of objects before returning...");
            this.log.debug("Validating MAGE-TAB contents");
            this.validateContent(investigation);
            if (this.getProgress() != 100) {
                this.log.debug("Finished import, progress should be 100% but wasn't, fixing");
                this.updateProgress(100);
            }
            this.log.info("MAGE-TAB parsing and syntactic validation finished");
            MAGETABInvestigation mAGETABInvestigation = investigation;
            return mAGETABInvestigation;
        }
        catch (ExecutionException e) {
            throw this.terminateService(e.getCause());
        }
        catch (Exception e) {
            throw this.terminateService(e);
        }
        finally {
            this.greenLight = false;
            if (this.shutdownOnCompletion) {
                this.service.shutdownNow();
            }
        }
    }

    private void validateContent(MAGETABInvestigation investigation) throws ParseException {
        try {
            if (!MAGETABUtils.validateMAGETABDocument(investigation)) {
                throw new ParseException("The source MAGE-TAB documents failed validation, so no loading was performed");
            }
        }
        catch (IOException e) {
            throw new ParseException("The source MAGE-TAB documents could not be validated, due to a problem executing the content validation process.  No loading was performed.");
        }
    }

    protected void monitorProgress(final MAGETABInvestigation investigation) {
        this.service.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (MAGETABParser.this.greenLight && investigation.getProgress() < 100 && investigation.getStatus() != Status.FAILED) {
                    MAGETABParser.this.log.debug("Investigation progress now " + investigation.getProgress() + ", status " + (Object)((Object)investigation.getStatus()) + ", updating importer");
                    MAGETABParser.this.updateProgress(investigation.getProgress());
                    try {
                        MAGETABInvestigation mAGETABInvestigation = investigation;
                        synchronized (mAGETABInvestigation) {
                            investigation.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (investigation.getStatus() != Status.FAILED) {
                    if (!MAGETABParser.this.greenLight) {
                        MAGETABParser.this.log.debug("Parsing exited normally following greenlight termination, halting progress monitor");
                    } else {
                        MAGETABParser.this.log.debug("Parsing exited due to 100% completion, halting progress monitor");
                    }
                } else {
                    MAGETABParser.this.log.error("Parsing exited due to a failed status, halting progress monitor");
                }
                MAGETABParser.this.updateProgress(investigation.getProgress());
            }
        });
    }

    private ParseException terminateService(Throwable cause) {
        this.log.error("Encountered an error while importing - terminating all MAGE-TAB import tasks...");
        long start = System.currentTimeMillis();
        List<Runnable> stubbornTasks = this.service.shutdownNow();
        try {
            int timeout = 10;
            boolean terminated = this.service.awaitTermination(timeout, TimeUnit.SECONDS);
            if (terminated && stubbornTasks.size() == 0) {
                long end = System.currentTimeMillis();
                double time = (end - start) / 1000L;
                this.log.error("All import tasks exited after " + time + "s.");
            } else {
                this.log.error("Failed to terminate all import tasks after " + timeout + "s.  There are " + stubbornTasks.size() + " tasks suspended");
            }
        }
        catch (InterruptedException e1) {
            this.log.error("Interrupted whilst waiting for import tasks to terminate.  There may be dead threads.");
        }
        if (cause instanceof ParseException) {
            return (ParseException)cause;
        }
        return new ParseException(cause);
    }
}

