/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.IDF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.handler.HandlerMode;
import uk.ac.ebi.arrayexpress2.magetab.handler.HandlerPool;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.IDFHandler;
import uk.ac.ebi.arrayexpress2.magetab.parser.AbstractParser;
import uk.ac.ebi.arrayexpress2.magetab.utils.MAGETABUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDFParser
extends AbstractParser<IDF> {
    private final ExecutorService service;
    private MAGETABInvestigation investigation;
    private HandlerMode mode;
    private HandlerPool handlers;
    private final Set<String> tagsDone;
    private double percentage;
    private Log log = LogFactory.getLog(this.getClass());

    public IDFParser() {
        this(Executors.newCachedThreadPool());
    }

    public IDFParser(ExecutorService service) {
        this.service = service;
        this.mode = HandlerMode.READ_ONLY;
        this.tagsDone = new HashSet<String>();
        this.handlers = HandlerPool.getInstance();
    }

    public synchronized MAGETABInvestigation getInvestigation() {
        if (this.investigation == null) {
            this.investigation = new MAGETABInvestigation();
        }
        return this.investigation;
    }

    public synchronized void setInvestigation(MAGETABInvestigation investigation) {
        this.investigation = investigation;
    }

    public synchronized HandlerMode getParsingMode() {
        return this.mode;
    }

    public synchronized void setParsingMode(HandlerMode mode) {
        this.mode = mode;
    }

    @Override
    public IDF parse(URL idfSource) throws ParseException {
        this.log.info("Starting IDF parsing...");
        this.tagsDone.clear();
        try {
            String line;
            HashSet<Future<MAGETABInvestigation>> tasks = new HashSet<Future<MAGETABInvestigation>>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(idfSource.openConnection().getInputStream()));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("") || line.startsWith("#")) continue;
                lines.add(line);
            }
            reader.close();
            this.getInvestigation().IDF.setNumberOfTasks(lines.size());
            this.percentage = 100.0 / (double)lines.size();
            this.log.debug("Starting tasks to handle and import IDF...");
            for (int i = 0; i < lines.size(); ++i) {
                String string = (String)lines.get(i);
                Future<MAGETABInvestigation> f = this.service.submit(this.createHandlerTask(string, i));
                tasks.add(f);
            }
            for (Future future : tasks) {
                future.get();
            }
            this.log.info("IDF parsing and syntactic validation finished");
            return this.getInvestigation().IDF;
        }
        catch (InterruptedException e) {
            this.getInvestigation().IDF.setStatus(Status.FAILED);
            throw new ParseException("The IDF file could not be imported; import was interrupted", e);
        }
        catch (ExecutionException e) {
            this.getInvestigation().IDF.setStatus(Status.FAILED);
            throw new ParseException("The IDF file could not be imported", e.getCause());
        }
        catch (IOException e) {
            this.getInvestigation().IDF.setStatus(Status.FAILED);
            throw new ParseException("An IO exception occurred whilst attempting to access the IDF file", e);
        }
    }

    private Callable<MAGETABInvestigation> createHandlerTask(final String lineData, int taskIndex) {
        final int localTaskIndex = taskIndex;
        return new Callable<MAGETABInvestigation>(){

            @Override
            public MAGETABInvestigation call() throws ParseException {
                String[] tokens = lineData.split("\t");
                String tag = tokens[0];
                tag = MAGETABUtils.digestHeader(tag);
                if (IDFParser.this.tagsDone.contains(tag)) {
                    throw new ParseException(tag + " is a duplicate tag, and already has a handler assigned");
                }
                try {
                    IDFParser.this.tagsDone.add(tag);
                    IDFHandler handler = IDFParser.this.handlers.getIDFHandler(tag, lineData, IDFParser.this.getInvestigation(), localTaskIndex, IDFParser.this.percentage);
                    if (handler != null) {
                        handler.setHandlerMode(IDFParser.this.mode);
                        handler.handle();
                        IDFParser.this.handlers.relinquishIDFHandler(handler);
                    }
                    return IDFParser.this.investigation;
                }
                catch (ParseException e) {
                    if (e.getCause() != null) {
                        throw new ParseException(e.getMessage(), e.getCause());
                    }
                    if (e.getMessage() != null && !e.getMessage().equals("")) {
                        throw new ParseException(e.getMessage());
                    }
                    throw new ParseException("A problem with parsing was encountered");
                }
                catch (ObjectConversionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof ParseException) {
                            throw (ParseException)e.getCause();
                        }
                        throw new ParseException(e.getMessage(), e.getCause());
                    }
                    if (e.getMessage() != null && !e.getMessage().equals("")) {
                        throw new ParseException(e.getMessage());
                    }
                    throw new ParseException("A problem with parsing was encountered");
                }
                catch (NullPointerException e) {
                    throw new ParseException("There was no handler for the tag '" + tag + "'", e);
                }
            }
        };
    }

    @Override
    public int getProgress() {
        return this.getInvestigation().IDF.getProgress();
    }
}

