/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ArrayDataMatrixNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ArrayDataNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.DerivedArrayDataMatrixNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.DerivedArrayDataNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ExtractNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.HybridizationNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ImageNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.LabeledExtractNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.NormalizationNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ProtocolNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SampleNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ScanNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SourceNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ParameterValueHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.PerformerHandler;

public class ProtocolHandler
extends AbstractAttributeHandler {
    public ProtocolHandler() {
        this.setTag("protocolref");
    }

    public String handlesTag() {
        return "* Protocol REF";
    }

    public boolean canHandle(String tag) {
        return tag.endsWith(this.getTag());
    }

    public void read() throws ParseException {
        if (!this.headers[0].endsWith(this.getTag())) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '* " + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new IllegalLineLengthException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        this.readValues();
        this.getLog().debug("SDRF Handler finished reading");
    }

    public void write() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].endsWith(this.getTag())) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '* " + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
        this.getLog().debug("SDRF Handler finished writing");
    }

    public void validate() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].endsWith(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '* " + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("SDRF Handler finished validating");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            AbstractAttributeHandler handler;
            if (this.headers[i].equals("termsourceref")) continue;
            if (this.headers[i].startsWith("parametervalue")) {
                handler = new ParameterValueHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("performer")) {
                handler = new PerformerHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("date") || this.headers[i].startsWith("comment")) continue;
            return i - 1;
        }
        return this.values.length - 1;
    }

    public void readValues() throws ParseException {
        if (this.headers[0].endsWith(this.tag)) {
            if (this.values[0] != null && !this.values[0].equals("")) {
                ProtocolNode protocol = new ProtocolNode();
                protocol.setNodeType(this.headers[0]);
                protocol.setNodeName(this.values[0]);
                this.addNextNodeForCompilation(protocol);
                for (int i = 1; i < this.values.length; ++i) {
                    AbstractAttributeHandler handler;
                    if (this.headers[i].equals("termsourceref")) {
                        protocol.termSourceREF = this.values[i];
                        continue;
                    }
                    if (this.headers[i].startsWith("parametervalue")) {
                        handler = new ParameterValueHandler();
                        i += this.handleAttribute(protocol, handler, this.headers, this.values, i);
                        continue;
                    }
                    if (this.headers[i].equals("performer")) {
                        handler = new PerformerHandler();
                        i += this.handleAttribute(protocol, handler, this.headers, this.values, i);
                        continue;
                    }
                    if (this.headers[i].equals("date")) {
                        protocol.date = this.values[i];
                        continue;
                    }
                    if (this.headers[i].startsWith("comment")) {
                        String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                        protocol.comments.put(type, this.values[i]);
                        continue;
                    }
                    if (this.parentNode instanceof SourceNode) {
                        SourceNode sourceNode = (SourceNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : sourceNode.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            sourceNode.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof SampleNode) {
                        SampleNode sampleNode = (SampleNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : sampleNode.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            sampleNode.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof ExtractNode) {
                        ExtractNode extract = (ExtractNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : extract.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            extract.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof LabeledExtractNode) {
                        LabeledExtractNode labeledExtract = (LabeledExtractNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : labeledExtract.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            labeledExtract.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof HybridizationNode) {
                        HybridizationNode hyb = (HybridizationNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : hyb.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            hyb.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof ScanNode) {
                        ScanNode scanNode = (ScanNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : scanNode.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            scanNode.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof NormalizationNode) {
                        NormalizationNode norm = (NormalizationNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : norm.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            norm.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof ArrayDataNode) {
                        ArrayDataNode ad = (ArrayDataNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : ad.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            ad.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof DerivedArrayDataNode) {
                        DerivedArrayDataNode dad = (DerivedArrayDataNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : dad.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            dad.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof ArrayDataMatrixNode) {
                        ArrayDataMatrixNode adm = (ArrayDataMatrixNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : adm.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            adm.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof DerivedArrayDataMatrixNode) {
                        DerivedArrayDataMatrixNode dadm = (DerivedArrayDataMatrixNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : dadm.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            dadm.protocols.add(protocol);
                        }
                    } else if (this.parentNode instanceof ImageNode) {
                        ImageNode image = (ImageNode)this.parentNode;
                        boolean seenBefore = false;
                        for (ProtocolNode p : image.protocols) {
                            if (!p.getNodeName().equals(protocol.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            image.protocols.add(protocol);
                        }
                    } else {
                        throw new UnmatchedTagException("Protocols can be applied to SourceNode, SampleNode, Extract or LabeledExtract nodes, but the parent here was a " + this.parentNode.getClass().getName());
                    }
                    return;
                }
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }
}

