/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ProtocolNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.PerformerAttribute;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;

public class PerformerHandler
extends AbstractAttributeHandler {
    public PerformerHandler() {
        this.setTag("performer");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            if (this.headers[i].startsWith("comment")) continue;
            return i - 1;
        }
        return this.values.length - 1;
    }

    public void readValues() throws UnmatchedTagException {
        if (this.headers[0].equals(this.tag)) {
            if (this.values[0] != null && !this.values[0].equals("")) {
                PerformerAttribute performer = new PerformerAttribute();
                performer.setNodeType(this.headers[0]);
                performer.setNodeName(this.values[0]);
                this.addNextNodeForCompilation(performer);
                for (int i = 1; i < this.values.length; ++i) {
                    if (!this.headers[i].startsWith("comment")) {
                        if (this.parentNode instanceof ProtocolNode) {
                            ProtocolNode protocol = (ProtocolNode)this.parentNode;
                            if (protocol.performer == null || protocol.performer.getNodeName() == null || !protocol.performer.getNodeName().equals(performer.getNodeName())) {
                                protocol.performer = performer;
                            }
                        } else {
                            throw new UnmatchedTagException("Performer can be applied to SourceNode, SampleNode, Extract or LabeledExtract nodes, but the parent here was a " + this.parentNode.getClass().getName());
                        }
                        return;
                    }
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                    performer.comment.put(type, this.values[i]);
                }
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }
}

