/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ProtocolNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.ParameterValueAttribute;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.UnitAttribute;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;

public class ParameterValueHandler
extends AbstractAttributeHandler {
    public ParameterValueHandler() {
        this.setTag("parametervalue");
    }

    public String handlesTag() {
        return "parametervalue[]";
    }

    public boolean canHandle(String tag) {
        return tag.startsWith(this.getTag());
    }

    public void read() throws ParseException {
        if (!this.headers[0].startsWith(this.getTag())) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '*" + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new IllegalLineLengthException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        this.readValues();
    }

    public void write() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].startsWith(this.getTag())) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
    }

    public void validate() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].startsWith(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("SDRF Handler finished validating");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            if (this.headers[i].startsWith("unit") || this.headers[i].startsWith("comment")) continue;
            return i - 1;
        }
        return this.values.length - 1;
    }

    public void readValues() throws UnmatchedTagException {
        if (this.headers[0].startsWith(this.tag)) {
            if (this.values[0] != null && !this.values[0].equals("")) {
                ParameterValueAttribute parameterValue = new ParameterValueAttribute();
                String type = this.headers[0].substring(this.headers[0].lastIndexOf("[") + 1, this.headers[0].lastIndexOf("]"));
                parameterValue.setNodeType(this.headers[0]);
                parameterValue.setNodeName(this.values[0]);
                parameterValue.type = type;
                this.addNextNodeForCompilation(parameterValue);
                for (int i = 1; i < this.values.length; ++i) {
                    if (this.headers[i].startsWith("unit")) {
                        String unit_type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                        UnitAttribute unit = new UnitAttribute();
                        unit.setNodeName(this.values[i]);
                        unit.type = unit_type;
                        parameterValue.unit = unit;
                        continue;
                    }
                    if (this.headers[i].startsWith("comment")) {
                        String comment_type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                        parameterValue.comment.put(comment_type, this.values[i]);
                        continue;
                    }
                    if (!(this.parentNode instanceof ProtocolNode)) {
                        throw new UnmatchedTagException("ParameterValue can be applied to SourceNode, SampleNode, Extract or LabeledExtract nodes, but the parent here was a " + this.parentNode.getClass().getName());
                    }
                    ProtocolNode protocol = (ProtocolNode)this.parentNode;
                    protocol.parameterValues.add(parameterValue);
                    return;
                }
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }
}

