/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ExtractNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.LabeledExtractNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SampleNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SourceNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.MaterialTypeAttribute;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;

public class MaterialTypeHandler
extends AbstractAttributeHandler {
    public MaterialTypeHandler() {
        this.setTag("materialtype");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            if (this.headers[i].equals("termsourceref")) continue;
            return i - 1;
        }
        return this.values.length - 1;
    }

    public void readValues() throws UnmatchedTagException {
        if (this.headers[0].equals(this.tag)) {
            if (this.values[0] != null && !this.values[0].equals("")) {
                MaterialTypeAttribute materialType = new MaterialTypeAttribute();
                materialType.setNodeType(this.headers[0]);
                materialType.setNodeName(this.values[0]);
                this.addNextNodeForCompilation(materialType);
                for (int i = 1; i < this.values.length; ++i) {
                    if (!this.headers[i].equals("termsourceref")) {
                        if (this.parentNode instanceof SourceNode) {
                            SourceNode sourceNode = (SourceNode)this.parentNode;
                            if (sourceNode.materialType == null || sourceNode.materialType.getNodeName() == null || !sourceNode.materialType.getNodeName().equals(materialType.getNodeName())) {
                                sourceNode.materialType = materialType;
                            }
                        } else if (this.parentNode instanceof SampleNode) {
                            SampleNode sampleNode = (SampleNode)this.parentNode;
                            if (sampleNode.materialType == null || sampleNode.materialType.getNodeName() == null || !sampleNode.materialType.getNodeName().equals(materialType.getNodeName())) {
                                sampleNode.materialType = materialType;
                            }
                        } else if (this.parentNode instanceof ExtractNode) {
                            ExtractNode extract = (ExtractNode)this.parentNode;
                            if (extract.materialType == null || extract.materialType.getNodeName() == null || !extract.materialType.getNodeName().equals(materialType.getNodeName())) {
                                extract.materialType = materialType;
                            }
                        } else if (this.parentNode instanceof LabeledExtractNode) {
                            LabeledExtractNode labeledExtract = (LabeledExtractNode)this.parentNode;
                            if (labeledExtract.materialType == null || labeledExtract.materialType.getNodeName() == null || !labeledExtract.materialType.getNodeName().equals(materialType.getNodeName())) {
                                labeledExtract.materialType = materialType;
                            }
                        } else {
                            throw new UnmatchedTagException("MaterialType can be applied to SourceNode, SampleNode, Extract or LabeledExtract nodes, but the parent here was a " + this.parentNode.getClass().getName());
                        }
                        return;
                    }
                    materialType.termSourceREF = this.values[i];
                }
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }
}

