/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ExtractNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.LabeledExtractNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SampleNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SourceNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.CharacteristicsAttribute;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.UnitAttribute;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;

public class CharacteristicsHandler
extends AbstractAttributeHandler {
    public CharacteristicsHandler() {
        this.setTag("characteristics");
    }

    public String handlesTag() {
        return "characteristics[]";
    }

    public boolean canHandle(String tag) {
        return tag.startsWith(this.getTag());
    }

    public void read() throws ParseException {
        if (!this.headers[0].startsWith(this.getTag())) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '*" + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new IllegalLineLengthException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        this.readValues();
        this.getLog().debug("SDRF Handler finished reading");
    }

    public void write() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].startsWith(this.getTag())) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
        this.getLog().debug("SDRF Handler finished writing");
    }

    public void validate() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].startsWith(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("SDRF Handler finished validating");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            if (this.headers[i].startsWith("unit") || this.headers[i].equals("termsourceref")) continue;
            return i - 1;
        }
        return this.values.length - 1;
    }

    public void readValues() throws UnmatchedTagException {
        if (this.headers[0].startsWith(this.tag)) {
            if (this.values[0] != null && !this.values[0].equals("")) {
                CharacteristicsAttribute characteristics = new CharacteristicsAttribute();
                String type = this.headers[0].substring(this.headers[0].lastIndexOf("[") + 1, this.headers[0].lastIndexOf("]"));
                characteristics.setNodeType(this.headers[0]);
                characteristics.setNodeName(this.values[0]);
                characteristics.type = type;
                this.addNextNodeForCompilation(characteristics);
                for (int i = 1; i < this.values.length; ++i) {
                    if (this.headers[i].startsWith("unit")) {
                        String unit_type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                        UnitAttribute unit = new UnitAttribute();
                        unit.setNodeName(this.values[i]);
                        unit.type = unit_type;
                        characteristics.unit = unit;
                        continue;
                    }
                    if (this.headers[i].equals("termsourceref")) {
                        characteristics.termSourceREF = this.values[i];
                        continue;
                    }
                    if (this.parentNode instanceof SourceNode) {
                        SourceNode sourceNode = (SourceNode)this.parentNode;
                        boolean seenBefore = false;
                        for (CharacteristicsAttribute c : sourceNode.characteristics) {
                            if (!c.type.equals(characteristics.type) || !c.getNodeName().equals(characteristics.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            sourceNode.characteristics.add(characteristics);
                        }
                    } else if (this.parentNode instanceof SampleNode) {
                        SampleNode sampleNode = (SampleNode)this.parentNode;
                        boolean seenBefore = false;
                        for (CharacteristicsAttribute c : sampleNode.characteristics) {
                            if (!c.type.equals(characteristics.type) || !c.getNodeName().equals(characteristics.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            sampleNode.characteristics.add(characteristics);
                        }
                    } else if (this.parentNode instanceof ExtractNode) {
                        ExtractNode extract = (ExtractNode)this.parentNode;
                        boolean seenBefore = false;
                        for (CharacteristicsAttribute c : extract.characteristics) {
                            if (!c.type.equals(characteristics.type) || !c.getNodeName().equals(characteristics.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            extract.characteristics.add(characteristics);
                        }
                    } else if (this.parentNode instanceof LabeledExtractNode) {
                        LabeledExtractNode labeledExtract = (LabeledExtractNode)this.parentNode;
                        boolean seenBefore = false;
                        for (CharacteristicsAttribute c : labeledExtract.characteristics) {
                            if (!c.type.equals(characteristics.type) || !c.getNodeName().equals(characteristics.getNodeName())) continue;
                            seenBefore = true;
                        }
                        if (!seenBefore) {
                            labeledExtract.characteristics.add(characteristics);
                        }
                    } else {
                        throw new UnmatchedTagException("Characteristics can be applied to SourceNode, SampleNode, Extract or LabeledExtract nodes, but the parent here was a " + this.parentNode.getClass().getName());
                    }
                    return;
                }
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }
}

