/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SourceNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFBiomaterialHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.CharacteristicsHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.MaterialTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProtocolHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProviderHandler;

public class SourceHandler
extends AbstractSDRFHandler
implements SDRFBiomaterialHandler {
    public SourceHandler() {
        this.setTag("sourcename");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            AbstractAttributeHandler handler;
            if (this.headers[i].startsWith("characteristics")) {
                handler = new CharacteristicsHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("provider")) {
                handler = new ProviderHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("materialtype")) {
                handler = new MaterialTypeHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("description") || this.headers[i].startsWith("comment")) continue;
            if (this.headers[i].endsWith("protocolref")) {
                handler = new ProtocolHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].startsWith("arraydesign")) {
                handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            return i;
        }
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues() throws ParseException {
        if (this.headers[0].equals(this.tag)) {
            SourceNode sourceNode;
            SDRF sDRF = this.investigation.SDRF;
            synchronized (sDRF) {
                sourceNode = this.investigation.SDRF.lookupNode(this.values[0], SourceNode.class);
                if (sourceNode == null) {
                    sourceNode = new SourceNode();
                    sourceNode.setNodeType(this.headers[0]);
                    sourceNode.setNodeName(this.values[0]);
                    this.investigation.SDRF.sourceNodes.add(sourceNode);
                    this.investigation.SDRF.storeNode(sourceNode);
                    this.addNextNodeForCompilation(sourceNode);
                }
            }
            for (int i = 1; i < this.values.length; ++i) {
                AbstractAttributeHandler handler;
                if (this.headers[i].startsWith("characteristics")) {
                    handler = new CharacteristicsHandler();
                    i += this.handleAttribute(sourceNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].equals("provider")) {
                    handler = new ProviderHandler();
                    i += this.handleAttribute(sourceNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].equals("materialtype")) {
                    handler = new MaterialTypeHandler();
                    i += this.handleAttribute(sourceNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].equals("description")) {
                    sourceNode.description = this.values[i];
                    continue;
                }
                if (this.headers[i].startsWith("comment")) {
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1 + 1, this.headers[i].lastIndexOf("]"));
                    sourceNode.comments.put(type, this.values[i]);
                    continue;
                }
                if (this.headers[i].endsWith("protocolref")) {
                    handler = new ProtocolHandler();
                    i += this.handleAttribute(sourceNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].startsWith("arraydesign")) {
                    handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                    i += this.handleAttribute(sourceNode, handler, this.headers, this.values, i);
                    continue;
                }
                sourceNode.setChildNodeType(this.headers[i]);
                sourceNode.addChildNodeValue(this.values[i]);
                return;
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }

    public String getMaterialName() {
        return "source";
    }
}

