/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ScanNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFDatatypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProtocolHandler;

public class ScanHandler
extends AbstractSDRFHandler
implements SDRFDatatypeHandler {
    public ScanHandler() {
        this.setTag("scanname");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            AbstractAttributeHandler handler;
            if (this.headers[i].startsWith("comment")) continue;
            if (this.headers[i].endsWith("protocolref")) {
                handler = new ProtocolHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].startsWith("arraydesign")) {
                handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            return i;
        }
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues() throws ParseException {
        if (this.headers[0].equals(this.tag)) {
            ScanNode scanNode;
            SDRF sDRF = this.investigation.SDRF;
            synchronized (sDRF) {
                scanNode = this.investigation.SDRF.lookupNode(this.values[0], ScanNode.class);
                if (scanNode == null) {
                    scanNode = new ScanNode();
                    scanNode.setNodeType(this.headers[0]);
                    scanNode.setNodeName(this.values[0]);
                    this.investigation.SDRF.storeNode(scanNode);
                    this.addNextNodeForCompilation(scanNode);
                }
            }
            for (int i = 1; i < this.values.length; ++i) {
                AbstractAttributeHandler handler;
                if (this.headers[i].startsWith("comment")) {
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                    scanNode.comments.put(type, this.values[i]);
                    continue;
                }
                if (this.headers[i].endsWith("protocolref")) {
                    handler = new ProtocolHandler();
                    i += this.handleAttribute(scanNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].startsWith("arraydesign")) {
                    handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                    i += this.handleAttribute(scanNode, handler, this.headers, this.values, i);
                    continue;
                }
                scanNode.setChildNodeType(this.headers[i]);
                scanNode.addChildNodeValue(this.values[i]);
                return;
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }

    public String getDatatypeName() {
        return "scan";
    }
}

