/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SampleNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFBiomaterialHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.CharacteristicsHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.MaterialTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProtocolHandler;

public class SampleHandler
extends AbstractSDRFHandler
implements SDRFBiomaterialHandler {
    public SampleHandler() {
        this.setTag("samplename");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            AbstractAttributeHandler handler;
            if (this.headers[i].startsWith("characteristics")) {
                handler = new CharacteristicsHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("materialtype")) {
                handler = new MaterialTypeHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].equals("description") || this.headers[i].startsWith("comment")) continue;
            if (this.headers[i].endsWith("protocolref")) {
                handler = new ProtocolHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].startsWith("arraydesign")) {
                handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            return i;
        }
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues() throws ParseException {
        if (this.headers[0].equals(this.tag)) {
            SampleNode sampleNode;
            SDRF sDRF = this.investigation.SDRF;
            synchronized (sDRF) {
                sampleNode = this.investigation.SDRF.lookupNode(this.values[0], SampleNode.class);
                if (sampleNode == null) {
                    sampleNode = new SampleNode();
                    sampleNode.setNodeType(this.headers[0]);
                    sampleNode.setNodeName(this.values[0]);
                    this.investigation.SDRF.storeNode(sampleNode);
                    this.addNextNodeForCompilation(sampleNode);
                }
            }
            for (int i = 1; i < this.values.length; ++i) {
                AbstractAttributeHandler handler;
                if (this.headers[i].startsWith("characteristics")) {
                    handler = new CharacteristicsHandler();
                    i += this.handleAttribute(sampleNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].equals("materialtype")) {
                    handler = new MaterialTypeHandler();
                    i += this.handleAttribute(sampleNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].equals("description")) {
                    sampleNode.description = this.values[i];
                    continue;
                }
                if (this.headers[i].startsWith("comment")) {
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                    sampleNode.comments.put(type, this.values[i]);
                    continue;
                }
                if (this.headers[i].endsWith("protocolref")) {
                    handler = new ProtocolHandler();
                    i += this.handleAttribute(sampleNode, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].startsWith("arraydesign")) {
                    handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                    i += this.handleAttribute(sampleNode, handler, this.headers, this.values, i);
                    continue;
                }
                sampleNode.setChildNodeType(this.headers[i]);
                sampleNode.addChildNodeValue(this.values[i]);
                return;
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }

    public String getMaterialName() {
        return "sample";
    }
}

