/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.NormalizationNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFDatatypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProtocolHandler;

public class NormalizationHandler
extends AbstractSDRFHandler
implements SDRFDatatypeHandler {
    public NormalizationHandler() {
        this.setTag("normalizationname");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            AbstractAttributeHandler handler;
            if (this.headers[i].startsWith("comment")) continue;
            if (this.headers[i].endsWith("protocolref")) {
                handler = new ProtocolHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].startsWith("arraydesign")) {
                handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            return i;
        }
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues() throws ParseException {
        if (this.headers[0].equals(this.tag)) {
            NormalizationNode norm;
            SDRF sDRF = this.investigation.SDRF;
            synchronized (sDRF) {
                norm = this.investigation.SDRF.lookupNode(this.values[0], NormalizationNode.class);
                if (norm == null) {
                    norm = new NormalizationNode();
                    norm.setNodeType(this.headers[0]);
                    norm.setNodeName(this.values[0]);
                    this.investigation.SDRF.storeNode(norm);
                    this.addNextNodeForCompilation(norm);
                }
            }
            for (int i = 1; i < this.values.length; ++i) {
                AbstractAttributeHandler handler;
                if (this.headers[i].startsWith("comment")) {
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                    norm.comments.put(type, this.values[i]);
                    continue;
                }
                if (this.headers[i].endsWith("protocolref")) {
                    handler = new ProtocolHandler();
                    i += this.handleAttribute(norm, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].startsWith("arraydesign")) {
                    handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                    i += this.handleAttribute(norm, handler, this.headers, this.values, i);
                    continue;
                }
                norm.setChildNodeType(this.headers[i]);
                norm.addChildNodeValue(this.values[i]);
                return;
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }

    public String getDatatypeName() {
        return "normalization";
    }
}

