/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import java.util.Arrays;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.HybridizationNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.InconsistentEntryCountException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.FactorValueHandler;

public class FactorValueNodeHandler
extends AbstractSDRFHandler {
    protected int startIndex;

    public FactorValueNodeHandler() {
        this.setTag("factorvalue");
    }

    public String handlesTag() {
        return "factorvalue[]";
    }

    public boolean canHandle(String tag) {
        return tag.startsWith(this.getTag());
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void read() throws ParseException {
        if (!this.headers[0].startsWith(this.tag)) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new IllegalLineLengthException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        this.readValues();
    }

    public void write() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].startsWith(this.getTag())) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.getTag() + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
    }

    public void validate() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].startsWith(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("SDRF Handler finished validating");
    }

    public int assess() {
        String[] headerData = Arrays.copyOfRange(this.headers, this.startIndex, this.headers.length);
        String[] valuesData = Arrays.copyOfRange(this.values, this.startIndex, this.values.length);
        return this.assessAttribute(new FactorValueHandler(), headerData, valuesData, this.startIndex);
    }

    public void readValues() throws ParseException {
        for (int i = this.startIndex; i > 0; --i) {
            if (!this.headers[i].equals("hybridizationname")) continue;
            HybridizationNode hyb = this.investigation.SDRF.lookupNode(this.values[i], HybridizationNode.class);
            if (hyb == null) {
                throw new InconsistentEntryCountException("Got a Factor Value entry at row " + this.startIndex + ", but there is no prior Hybridization Name");
            }
            String[] headerData = Arrays.copyOfRange(this.headers, this.startIndex, this.headers.length);
            String[] valuesData = Arrays.copyOfRange(this.values, this.startIndex, this.values.length);
            FactorValueHandler handler = new FactorValueHandler();
            this.handleAttribute(hyb, handler, headerData, valuesData, this.headers.length);
        }
        throw new InconsistentEntryCountException("Got a Factor Value entry at row " + this.startIndex + ", but there is no prior Hybridization Name");
    }

    protected void writeValues() throws ObjectConversionException {
    }
}

