/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.DerivedArrayDataNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFDatatypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProtocolHandler;

public class DerivedArrayDataHandler
extends AbstractSDRFHandler
implements SDRFDatatypeHandler {
    public DerivedArrayDataHandler() {
        this.setTag("derivedarraydatafile");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            int j;
            AbstractAttributeHandler handler;
            if (this.headers[i].startsWith("comment")) continue;
            if (this.headers[i].endsWith("protocolref")) {
                handler = new ProtocolHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].startsWith("arraydesign")) {
                handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            for (j = i; j < this.headers.length && this.headers[j].startsWith("factorvalue"); ++j) {
            }
            i = j;
            return i;
        }
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues() throws ParseException {
        if (this.headers[0].equals(this.tag)) {
            DerivedArrayDataNode dadf;
            SDRF sDRF = this.investigation.SDRF;
            synchronized (sDRF) {
                dadf = this.investigation.SDRF.lookupNode(this.values[0], DerivedArrayDataNode.class);
                if (dadf == null) {
                    dadf = new DerivedArrayDataNode();
                    dadf.setNodeType(this.headers[0]);
                    dadf.setNodeName(this.values[0]);
                    this.investigation.SDRF.storeNode(dadf);
                    this.addNextNodeForCompilation(dadf);
                }
            }
            for (int i = 1; i < this.values.length; ++i) {
                int j;
                if (this.headers[i].startsWith("comment")) {
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                    dadf.comments.put(type, this.values[i]);
                    continue;
                }
                if (this.headers[i].endsWith("protocolref")) {
                    ProtocolHandler handler = new ProtocolHandler();
                    i += this.handleAttribute(dadf, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].startsWith("arraydesign")) {
                    ArrayDesignHandler handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                    i += this.handleAttribute(dadf, handler, this.headers, this.values, i);
                    continue;
                }
                for (j = i; j < this.headers.length && this.headers[j].startsWith("factorvalue"); ++j) {
                }
                i = j;
                if (i >= this.headers.length) continue;
                dadf.setChildNodeType(this.headers[i]);
                dadf.addChildNodeValue(this.values[i]);
                return;
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }

    public String getDatatypeName() {
        return "processedData";
    }
}

