/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.ArrayDataNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.AbstractSDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFDatatypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AbstractAttributeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ArrayDesignRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.ProtocolHandler;

public class ArrayDataHandler
extends AbstractSDRFHandler
implements SDRFDatatypeHandler {
    public ArrayDataHandler() {
        this.setTag("arraydatafile");
    }

    public int assess() {
        for (int i = 1; i < this.values.length; ++i) {
            int j;
            AbstractAttributeHandler handler;
            if (this.headers[i].startsWith("comment")) continue;
            if (this.headers[i].endsWith("protocolref")) {
                handler = new ProtocolHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            if (this.headers[i].startsWith("arraydesign")) {
                handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                i += this.assessAttribute(handler, this.headers, this.values, i);
                continue;
            }
            for (j = i; j < this.headers.length && this.headers[j].startsWith("factorvalue"); ++j) {
            }
            i = j;
            return i;
        }
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readValues() throws ParseException {
        if (this.headers[0].equals(this.tag)) {
            ArrayDataNode adf;
            SDRF sDRF = this.investigation.SDRF;
            synchronized (sDRF) {
                adf = this.investigation.SDRF.lookupNode(this.values[0], ArrayDataNode.class);
                if (adf == null) {
                    adf = new ArrayDataNode();
                    adf.setNodeType(this.headers[0]);
                    adf.setNodeName(this.values[0]);
                    this.investigation.SDRF.storeNode(adf);
                    this.addNextNodeForCompilation(adf);
                }
            }
            for (int i = 1; i < this.values.length; ++i) {
                int j;
                if (this.headers[i].startsWith("comment")) {
                    String type = this.headers[i].substring(this.headers[i].lastIndexOf("[") + 1, this.headers[i].lastIndexOf("]"));
                    adf.comments.put(type, this.values[i]);
                    continue;
                }
                if (this.headers[i].endsWith("protocolref")) {
                    ProtocolHandler handler = new ProtocolHandler();
                    i += this.handleAttribute(adf, handler, this.headers, this.values, i);
                    continue;
                }
                if (this.headers[i].startsWith("arraydesign")) {
                    ArrayDesignHandler handler = this.headers[i].endsWith("file") ? new ArrayDesignFileHandler() : new ArrayDesignRefHandler();
                    i += this.handleAttribute(adf, handler, this.headers, this.values, i);
                    continue;
                }
                for (j = i; j < this.headers.length && this.headers[j].startsWith("factorvalue"); ++j) {
                }
                i = j;
                if (i >= this.headers.length) continue;
                adf.setChildNodeType(this.headers[i]);
                adf.addChildNodeValue(this.values[i]);
                return;
            }
        } else {
            throw new UnmatchedTagException("This handler starts at tag: " + this.tag + ", not " + this.headers[0]);
        }
    }

    public String getDatatypeName() {
        return "rawData";
    }
}

