/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.sdrf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SDRFNode;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.AbstractReadWriteValidateHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.attribute.AttributeHandler;

public abstract class AbstractSDRFHandler
extends AbstractReadWriteValidateHandler
implements SDRFHandler {
    protected MAGETABInvestigation investigation;
    protected String[] headers;
    protected String[] values;
    protected List<SDRFNode> nodesToCompile = new ArrayList<SDRFNode>();

    public void setInvestigation(MAGETABInvestigation investigation) {
        this.investigation = investigation;
    }

    public void setData(String[] headers, String[] values) {
        this.headers = headers;
        this.values = values;
    }

    public void handle() throws ParseException, ObjectConversionException {
        try {
            super.handle();
            if (this.getTaskIndex() != -1) {
                this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.PERSISTING);
                this.investigation.SDRF.increaseProgressBy(this.increase);
            }
        }
        catch (ParseException e) {
            if (this.getTaskIndex() != -1) {
                this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.FAILED);
            }
            throw e;
        }
        catch (ObjectConversionException e) {
            if (this.getTaskIndex() != -1) {
                this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.FAILED);
            }
            throw e;
        }
    }

    public void read() throws ParseException {
        if (this.headers.length < 1) {
            throw new ParseException("Nothing to parse!");
        }
        if (!this.headers[0].equals(this.tag)) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new IllegalLineLengthException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        this.readValues();
        this.getLog().debug("SDRF Handler finished reading");
    }

    public void write() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].equals(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
        this.getLog().debug("SDRF Handler finished writing");
    }

    public void validate() throws ObjectConversionException {
        if (this.headers.length < 1) {
            throw new ObjectConversionException("Nothing to convert!");
        }
        if (!this.headers[0].equals(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + this.headers[0] + "'");
        }
        if (this.headers.length != this.values.length) {
            throw new ObjectConversionException("Too many tokens on this line - expected: " + this.headers.length + " found: " + this.values.length);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.SDRF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("SDRF Handler finished validating");
    }

    protected void readValues() throws ParseException {
    }

    protected void writeValues() throws ObjectConversionException {
    }

    protected void validateValues() throws ObjectConversionException {
    }

    protected synchronized void addNextNodeForCompilation(SDRFNode node) {
        this.nodesToCompile.add(node);
    }

    protected synchronized SDRFNode getNextNodeForCompilation() {
        if (this.nodesToCompile.size() > 0) {
            SDRFNode node = this.nodesToCompile.get(0);
            this.nodesToCompile.remove(node);
            return node;
        }
        return null;
    }

    protected int assessAttribute(AttributeHandler handler, String[] headers, String[] values, int startIndex) {
        String[] headerData = Arrays.copyOfRange(headers, startIndex, headers.length);
        String[] valuesData = Arrays.copyOfRange(values, startIndex, values.length);
        handler.setData(headerData, valuesData);
        return handler.assess();
    }

    protected int handleAttribute(SDRFNode parentNode, AttributeHandler handler, String[] headers, String[] values, int startIndex) throws ParseException {
        String[] headerData = Arrays.copyOfRange(headers, startIndex, headers.length);
        String[] valuesData = Arrays.copyOfRange(values, startIndex, values.length);
        handler.setParentNode(parentNode);
        handler.setData(headerData, valuesData);
        handler.setInvestigation(this.investigation);
        handler.setHandlerMode(this.getHandlerMode());
        handler.setTaskIndex(-1);
        int endIndex = handler.assess();
        try {
            handler.handle();
            return endIndex;
        }
        catch (ObjectConversionException e) {
            throw new ParseException("An error occurred whilst adding attributes to SDRFNodes in the datamodel", e);
        }
    }
}

