/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl;

import java.util.Arrays;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.AbstractIDFHandler;
import uk.ac.ebi.arrayexpress2.magetab.utils.MAGETABUtils;

public class CommentHandler
extends AbstractIDFHandler {
    private String lastType;

    public CommentHandler() {
        this.setTag("comment");
    }

    public String handlesTag() {
        return "comment[]";
    }

    public boolean canHandle(String tag) {
        return tag.startsWith(this.getTag()) && !tag.matches("comment[arrayexpressaccession]");
    }

    public synchronized void read() throws ParseException {
        String[] tokens = this.line.split("\t");
        int numTokens = tokens.length - 1;
        String header = MAGETABUtils.digestHeader(tokens[0]);
        String[] values = Arrays.copyOfRange(tokens, 1, tokens.length);
        if (!header.startsWith(this.tag)) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + header + "'");
        }
        if (numTokens > this.allowedLength) {
            throw new IllegalLineLengthException("Too many tokens on this line - allowed: " + (this.allowedLength < Integer.MAX_VALUE ? Integer.valueOf(this.allowedLength) : "unlimited") + " found: " + numTokens);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        String type = header.substring(header.indexOf("["), header.lastIndexOf("]"));
        this.readType(type);
        if (values.length > 0) {
            int i = 0;
            for (String value : values) {
                if (i < this.allowedLength) {
                    this.readValue(value);
                    ++i;
                    continue;
                }
                throw new ParseException("Cardinality breach - " + tokens[0] + " fields can contain " + this.allowedLength + " values only");
            }
        } else {
            this.readEmptyValue();
        }
        this.getLog().debug("IDF Handler finished reading");
    }

    public synchronized void write() throws ObjectConversionException {
        String[] tokens = this.line.split("\t");
        int numTokens = tokens.length - 1;
        String header = MAGETABUtils.digestHeader(tokens[0]);
        if (!header.startsWith(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + header + "'");
        }
        if (numTokens > this.allowedLength) {
            throw new ObjectConversionException("Too many tokens on this line - allowed: " + (this.allowedLength < Integer.MAX_VALUE ? Integer.valueOf(this.allowedLength) : "unlimited") + " found: " + numTokens);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
        this.getLog().debug("IDF Handler finished writing");
    }

    public void validate() throws ObjectConversionException {
        String[] tokens = this.line.split("\t");
        int numTokens = tokens.length - 1;
        String header = MAGETABUtils.digestHeader(tokens[0]);
        if (!header.startsWith(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + header + "'");
        }
        if (numTokens > this.allowedLength) {
            throw new ObjectConversionException("Too many tokens on this line - allowed: " + (this.allowedLength < Integer.MAX_VALUE ? Integer.valueOf(this.allowedLength) : "unlimited") + " found: " + numTokens);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("IDF Handler finished validating");
    }

    public void readType(String type) {
        this.lastType = type;
    }

    public void readValue(String value) throws ParseException {
        this.investigation.IDF.addComment(this.lastType, value);
    }
}

