/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler.idf;

import java.util.Arrays;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.exception.IllegalLineLengthException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ObjectConversionException;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.exception.UnmatchedTagException;
import uk.ac.ebi.arrayexpress2.magetab.handler.AbstractReadWriteValidateHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.IDFHandler;
import uk.ac.ebi.arrayexpress2.magetab.utils.MAGETABUtils;

public abstract class AbstractIDFHandler
extends AbstractReadWriteValidateHandler
implements IDFHandler {
    protected MAGETABInvestigation investigation;
    protected String line;

    public void setInvestigation(MAGETABInvestigation investigation) {
        this.investigation = investigation;
    }

    public synchronized void setData(String line) {
        this.getLog().debug("Updating handler [" + this.toString() + "] with data: " + line);
        this.line = line == null || line.equals("") ? line : line.trim();
    }

    public void handle() throws ParseException, ObjectConversionException {
        try {
            super.handle();
            this.investigation.IDF.increaseProgressBy(this.increase);
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.COMPLETE);
        }
        catch (ParseException e) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.FAILED);
            throw e;
        }
        catch (ObjectConversionException e) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.FAILED);
            throw e;
        }
    }

    public synchronized void read() throws ParseException {
        String[] tokens = this.line.split("\t");
        int numTokens = tokens.length - 1;
        String header = MAGETABUtils.digestHeader(tokens[0]);
        String[] values = Arrays.copyOfRange(tokens, 1, tokens.length);
        if (!header.equals(this.tag)) {
            throw new UnmatchedTagException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + header + "'");
        }
        if (numTokens > this.allowedLength) {
            throw new IllegalLineLengthException("Too many tokens on this line - allowed: " + (this.allowedLength < Integer.MAX_VALUE ? Integer.valueOf(this.allowedLength) : "unlimited") + " found: " + numTokens);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.READING);
        }
        if (values.length > 0) {
            int i = 0;
            for (String value : values) {
                if (i < this.allowedLength) {
                    this.readValue(value);
                    ++i;
                    continue;
                }
                throw new ParseException("Cardinality breach - " + tokens[0] + " fields can contain " + this.allowedLength + " values only");
            }
        } else {
            this.readEmptyValue();
        }
        this.getLog().debug("IDF Handler finished reading");
    }

    public synchronized void write() throws ObjectConversionException {
        String[] tokens = this.line.split("\t");
        int numTokens = tokens.length - 1;
        String header = MAGETABUtils.digestHeader(tokens[0]);
        if (!header.equals(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + header + "'");
        }
        if (numTokens > this.allowedLength) {
            throw new ObjectConversionException("Too many tokens on this line - allowed: " + (this.allowedLength < Integer.MAX_VALUE ? Integer.valueOf(this.allowedLength) : "unlimited") + " found: " + numTokens);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.COMPILING);
        }
        this.writeValues();
        this.getLog().debug("IDF Handler finished writing");
    }

    public void validate() throws ObjectConversionException {
        String[] tokens = this.line.split("\t");
        int numTokens = tokens.length - 1;
        String header = MAGETABUtils.digestHeader(tokens[0]);
        if (!header.equals(this.tag)) {
            throw new ObjectConversionException("Tag is wrong for handler - this handler accepts '" + this.tag + "' but got '" + header + "'");
        }
        if (numTokens > this.allowedLength) {
            throw new ObjectConversionException("Too many tokens on this line - allowed: " + (this.allowedLength < Integer.MAX_VALUE ? Integer.valueOf(this.allowedLength) : "unlimited") + " found: " + numTokens);
        }
        if (this.getTaskIndex() != -1) {
            this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.VALIDATING);
        }
        this.validateValues();
        this.getLog().debug("IDF Handler finished validating");
    }

    protected void readValue(String value) throws ParseException {
    }

    protected void writeValues() throws ObjectConversionException {
    }

    protected void validateValues() throws ObjectConversionException {
    }

    protected synchronized void readEmptyValue() {
        this.investigation.IDF.updateTaskList(this.getTaskIndex(), Status.COMPLETE);
    }
}

