/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.handler.Handler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.IDFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.IgnoredLineHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.AccessionHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.CommentHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.DateOfExperimentHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ExperimentDescriptionHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ExperimentalDesignHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ExperimentalFactorNameHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ExperimentalFactorTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ExperimentalFactorTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.InvestigationTitleHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.NormalizationTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.NormalizationTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonAddressHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonAffiliationHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonEmailHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonFaxHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonFirstNameHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonLastNameHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonMidInitialsHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonPhoneHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonRolesHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PersonRolesTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolContactHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolDescriptionHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolHardwareHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolNameHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolParametersHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolSoftwareHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ProtocolTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PubMedIdHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PublicReleaseDateHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PublicationAuthorListHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PublicationDoiHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PublicationStatusHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PublicationStatusTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.PublicationTitleHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.QualityControlTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.QualityControlTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ReplicateTermSourceRefHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.ReplicateTypeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.SDRFFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.TermSourceFileHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.TermSourceNameHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.idf.impl.TermSourceVersionHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.IgnoredHeaderHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.SDRFHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.ArrayDataHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.ArrayDataMatrixHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.DerivedArrayDataHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.DerivedArrayDataMatrixHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.ExtractHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.FactorValueNodeHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.HybridizationHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.ImageHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.LabeledExtractHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.NormalizationHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.SampleHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.ScanHandler;
import uk.ac.ebi.arrayexpress2.magetab.handler.sdrf.node.SourceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerPool {
    private static HandlerPool ourInstance = new HandlerPool();
    private final List<Class<? extends IDFHandler>> idfHandlerClasses;
    private final Map<String, Class<? extends IDFHandler>> idfHandlerMap;
    private final Map<Class<? extends IDFHandler>, List<IDFHandler>> idfHandlerStore;
    private final List<Class<? extends SDRFHandler>> sdrfHandlerClasses;
    private final Map<String, Class<? extends SDRFHandler>> sdrfHandlerMap;
    private final Map<Class<? extends SDRFHandler>, List<SDRFHandler>> sdrfHandlerStore;
    private Log log = LogFactory.getLog(this.getClass());

    public static HandlerPool getInstance() {
        return ourInstance;
    }

    private HandlerPool() {
        this.idfHandlerClasses = new ArrayList<Class<? extends IDFHandler>>();
        this.idfHandlerMap = new HashMap<String, Class<? extends IDFHandler>>();
        this.idfHandlerStore = new HashMap<Class<? extends IDFHandler>, List<IDFHandler>>();
        this.sdrfHandlerClasses = new ArrayList<Class<? extends SDRFHandler>>();
        this.sdrfHandlerMap = new HashMap<String, Class<? extends SDRFHandler>>();
        this.sdrfHandlerStore = new HashMap<Class<? extends SDRFHandler>, List<SDRFHandler>>();
        this.useDefaultHandlers();
    }

    public void configureHandlers(Set<Class<? extends Handler>> handlerClasses) {
        this.idfHandlerClasses.clear();
        this.idfHandlerMap.clear();
        this.idfHandlerStore.clear();
        this.sdrfHandlerClasses.clear();
        this.sdrfHandlerMap.clear();
        this.sdrfHandlerStore.clear();
        this.addHandlerClasses(handlerClasses);
    }

    public void useDefaultHandlers() {
        HashSet<Class<? extends Handler>> handlerClasses = new HashSet<Class<? extends Handler>>();
        handlerClasses.add(AccessionHandler.class);
        handlerClasses.add(CommentHandler.class);
        handlerClasses.add(DateOfExperimentHandler.class);
        handlerClasses.add(ExperimentalDesignHandler.class);
        handlerClasses.add(ExperimentalFactorNameHandler.class);
        handlerClasses.add(ExperimentalFactorTermSourceRefHandler.class);
        handlerClasses.add(ExperimentalFactorTypeHandler.class);
        handlerClasses.add(ExperimentDescriptionHandler.class);
        handlerClasses.add(InvestigationTitleHandler.class);
        handlerClasses.add(NormalizationTermSourceRefHandler.class);
        handlerClasses.add(NormalizationTypeHandler.class);
        handlerClasses.add(PersonAddressHandler.class);
        handlerClasses.add(PersonAffiliationHandler.class);
        handlerClasses.add(PersonEmailHandler.class);
        handlerClasses.add(PersonFaxHandler.class);
        handlerClasses.add(PersonFirstNameHandler.class);
        handlerClasses.add(PersonLastNameHandler.class);
        handlerClasses.add(PersonMidInitialsHandler.class);
        handlerClasses.add(PersonPhoneHandler.class);
        handlerClasses.add(PersonRolesHandler.class);
        handlerClasses.add(PersonRolesTermSourceRefHandler.class);
        handlerClasses.add(ProtocolContactHandler.class);
        handlerClasses.add(ProtocolDescriptionHandler.class);
        handlerClasses.add(ProtocolHardwareHandler.class);
        handlerClasses.add(ProtocolNameHandler.class);
        handlerClasses.add(ProtocolParametersHandler.class);
        handlerClasses.add(ProtocolSoftwareHandler.class);
        handlerClasses.add(ProtocolTermSourceRefHandler.class);
        handlerClasses.add(ProtocolTypeHandler.class);
        handlerClasses.add(PublicationAuthorListHandler.class);
        handlerClasses.add(PublicationDoiHandler.class);
        handlerClasses.add(PublicationStatusHandler.class);
        handlerClasses.add(PublicationStatusTermSourceRefHandler.class);
        handlerClasses.add(PublicationTitleHandler.class);
        handlerClasses.add(PublicReleaseDateHandler.class);
        handlerClasses.add(PubMedIdHandler.class);
        handlerClasses.add(QualityControlTermSourceRefHandler.class);
        handlerClasses.add(QualityControlTypeHandler.class);
        handlerClasses.add(ReplicateTermSourceRefHandler.class);
        handlerClasses.add(ReplicateTypeHandler.class);
        handlerClasses.add(SDRFFileHandler.class);
        handlerClasses.add(TermSourceFileHandler.class);
        handlerClasses.add(TermSourceNameHandler.class);
        handlerClasses.add(TermSourceVersionHandler.class);
        handlerClasses.add(SourceHandler.class);
        handlerClasses.add(SampleHandler.class);
        handlerClasses.add(ExtractHandler.class);
        handlerClasses.add(LabeledExtractHandler.class);
        handlerClasses.add(HybridizationHandler.class);
        handlerClasses.add(FactorValueNodeHandler.class);
        handlerClasses.add(ScanHandler.class);
        handlerClasses.add(NormalizationHandler.class);
        handlerClasses.add(ArrayDataHandler.class);
        handlerClasses.add(DerivedArrayDataHandler.class);
        handlerClasses.add(ArrayDataMatrixHandler.class);
        handlerClasses.add(DerivedArrayDataMatrixHandler.class);
        handlerClasses.add(ImageHandler.class);
        this.idfHandlerClasses.clear();
        this.idfHandlerMap.clear();
        this.idfHandlerStore.clear();
        this.sdrfHandlerClasses.clear();
        this.sdrfHandlerMap.clear();
        this.sdrfHandlerStore.clear();
        this.addHandlerClasses(handlerClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDFHandler getIDFHandler(String tag, String lineData, MAGETABInvestigation investigation, int taskNumber, double progressIncrement) {
        IDFHandler handler = null;
        Map<String, Class<? extends IDFHandler>> map = this.idfHandlerMap;
        synchronized (map) {
            String strippedTag;
            String string = strippedTag = tag.contains("[") ? tag.substring(0, tag.indexOf("[") + 1).concat(tag.substring(tag.indexOf("]"), tag.length())) : tag;
            if (this.idfHandlerMap.containsKey(strippedTag)) {
                Class<? extends IDFHandler> handlerClass = this.idfHandlerMap.get(strippedTag);
                Map<Class<? extends IDFHandler>, List<IDFHandler>> map2 = this.idfHandlerStore;
                synchronized (map2) {
                    List<IDFHandler> handlers = this.idfHandlerStore.get(handlerClass);
                    if (handlers != null && handlers.size() > 0) {
                        handler = handlers.get(0);
                        handlers.remove(handler);
                        this.log.debug("Reusing existing handler, " + handler.toString());
                    } else {
                        try {
                            this.log.debug("Instantiating new handler for " + tag);
                            handler = handlerClass.newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new NullPointerException("Could not open handler class " + handlerClass.getName());
                        }
                        catch (InstantiationException instantiationException) {
                            throw new NullPointerException("Unable to instantiate handler class " + handlerClass.getName() + "; this may be due to a non-default constructor?");
                        }
                    }
                }
            }
            List<Class<? extends IDFHandler>> list = this.idfHandlerClasses;
            synchronized (list) {
                ArrayList<Class<? extends IDFHandler>> handlerClasses = new ArrayList<Class<? extends IDFHandler>>();
                handlerClasses.addAll(this.idfHandlerClasses);
                for (Class clazz : handlerClasses) {
                    try {
                        handler = (IDFHandler)clazz.newInstance();
                        this.idfHandlerMap.put(handler.handlesTag(), handler.getClass());
                        if (!this.idfHandlerStore.containsKey(handler.getClass())) {
                            this.idfHandlerStore.put(handler.getClass(), new ArrayList());
                        }
                        this.idfHandlerClasses.remove(handler.getClass());
                        if (handler.canHandle(tag)) break;
                        Map<Class<? extends IDFHandler>, List<IDFHandler>> map3 = this.idfHandlerStore;
                        synchronized (map3) {
                            this.idfHandlerStore.get(handler.getClass()).add(handler);
                        }
                        handler = null;
                    }
                    catch (IllegalAccessException e) {
                        throw new NullPointerException("Could not open handler class " + clazz.getName());
                    }
                    catch (InstantiationException e) {
                        throw new NullPointerException("Unable to instantiate handler class " + clazz.getName() + "; this may be due to a non-default constructor?");
                    }
                }
            }
            if (handler == null) {
                this.log.warn("Ignoring tag '" + tag + "', there is no handler for this tag configured");
                handler = new IgnoredLineHandler();
            }
            this.log.debug("Calibrating handler with required parameters...");
            handler.setInvestigation(investigation);
            this.log.debug("Adding data (" + lineData + ") to handler [" + handler.toString() + "]");
            handler.setData(lineData);
            handler.setTaskIndex(taskNumber);
            handler.increasesProgressBy(progressIncrement);
            return handler;
        }
    }

    public void relinquishIDFHandler(IDFHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public SDRFHandler getSDRFHandler(String tag, String[] headerData, String[] rowData, MAGETABInvestigation investigation, int taskNumber, double progressIncrement) {
        SDRFHandler handler = null;
        Map<String, Class<? extends SDRFHandler>> map = this.sdrfHandlerMap;
        synchronized (map) {
            Object handlerClass;
            String strippedTag;
            String string = strippedTag = tag.contains("[") ? tag.substring(0, tag.indexOf("[") + 1).concat(tag.substring(tag.indexOf("]"), tag.length())) : tag;
            if (this.sdrfHandlerMap.containsKey(strippedTag)) {
                handlerClass = this.sdrfHandlerMap.get(strippedTag);
                Map<Class<? extends SDRFHandler>, List<SDRFHandler>> map2 = this.sdrfHandlerStore;
                synchronized (map2) {
                    List<SDRFHandler> handlers = this.sdrfHandlerStore.get(handlerClass);
                    if (handlers != null && handlers.size() > 0) {
                        handler = handlers.get(0);
                        handlers.remove(handler);
                    } else {
                        try {
                            handler = (SDRFHandler)((Class)handlerClass).newInstance();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new NullPointerException("Could not open handler class " + ((Class)handlerClass).getName());
                        }
                        catch (InstantiationException instantiationException) {
                            throw new NullPointerException("Unable to instantiate handler class " + ((Class)handlerClass).getName() + "; this may be due to a non-default constructor?");
                        }
                    }
                }
            }
            handlerClass = this.sdrfHandlerClasses;
            synchronized (handlerClass) {
                ArrayList<Class<? extends SDRFHandler>> handlerClasses = new ArrayList<Class<? extends SDRFHandler>>();
                handlerClasses.addAll(this.sdrfHandlerClasses);
                for (Class clazz : handlerClasses) {
                    try {
                        handler = (SDRFHandler)clazz.newInstance();
                        this.sdrfHandlerMap.put(handler.handlesTag(), handler.getClass());
                        if (!this.sdrfHandlerStore.containsKey(handler.getClass())) {
                            this.sdrfHandlerStore.put(handler.getClass(), new ArrayList());
                        }
                        if (handler.canHandle(tag)) break;
                        Map<Class<? extends SDRFHandler>, List<SDRFHandler>> map2 = this.sdrfHandlerStore;
                        synchronized (map2) {
                            this.sdrfHandlerStore.get(handler.getClass()).add(handler);
                        }
                        handler = null;
                    }
                    catch (IllegalAccessException e) {
                        throw new NullPointerException("Could not open handler class " + clazz.getName());
                    }
                    catch (InstantiationException e) {
                        throw new NullPointerException("Unable to instantiate handler class " + clazz.getName() + "; this may be due to a non-default constructor?");
                    }
                }
            }
            if (handler == null) {
                void var14_18;
                StringBuffer sb = new StringBuffer();
                String[] arr$ = rowData;
                int len$ = arr$.length;
                boolean bl = false;
                while (var14_18 < len$) {
                    String s = arr$[var14_18];
                    sb.append(s).append("\t");
                    ++var14_18;
                }
                if (!sb.toString().trim().equals("")) {
                    this.log.warn("Ignoring data [" + sb.toString().trim() + "] for tag '" + tag + "', there is no handler for this tag configured");
                } else {
                    this.log.warn("Ignoring header tag '" + tag + "', there is no handler for this tag configured");
                }
                handler = new IgnoredHeaderHandler();
            }
            handler.setInvestigation(investigation);
            handler.setData(headerData, rowData);
            handler.setTaskIndex(taskNumber);
            handler.increasesProgressBy(progressIncrement);
            return handler;
        }
    }

    public void relinquishSDRFHandler(SDRFHandler handler) {
    }

    private void addHandlerClasses(Set<Class<? extends Handler>> handlerClasses) {
        for (Class<? extends Handler> handlerClass : handlerClasses) {
            if (IDFHandler.class.isAssignableFrom(handlerClass)) {
                this.idfHandlerClasses.add(handlerClass);
                continue;
            }
            if (SDRFHandler.class.isAssignableFrom(handlerClass)) {
                this.sdrfHandlerClasses.add(handlerClass);
                continue;
            }
            throw new IllegalArgumentException("Handler classes must be either IDF or SDRF handler implementations");
        }
    }
}

