/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SDRFNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDRF {
    public List<SourceNode> sourceNodes = new ArrayList<SourceNode>();
    private Map<Class<? extends SDRFNode>, List<SDRFNode>> nodeStoreByClass = new HashMap<Class<? extends SDRFNode>, List<SDRFNode>>();
    private Map<String, List<SDRFNode>> nodeStoreByTag = new HashMap<String, List<SDRFNode>>();
    private final MAGETABInvestigation investigation;
    private double complete = 0.0;
    private Status[] taskStates;
    private Status lastStatus = Status.READY;
    private static final Object PROGRESS_LOCK = new Object();
    protected Log log = LogFactory.getLog(this.getClass());

    public SDRF(MAGETABInvestigation investigation) {
        this.investigation = investigation;
        this.taskStates = new Status[]{Status.READY};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgress() {
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            return (int)Math.rint(this.complete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseProgressBy(double increase) {
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            this.complete += increase;
            this.investigation.increaseTotalProgressBy(increase / 2.0);
            SDRF sDRF = this;
            synchronized (sDRF) {
                this.notifyAll();
            }
        }
    }

    public synchronized void setNumberOfTasks(int totalTasks) {
        this.taskStates = new Status[totalTasks];
        for (int i = 0; i < totalTasks; ++i) {
            this.taskStates[i] = Status.READY;
        }
    }

    public synchronized void updateTaskList(int taskIndex, Status taskStatus) {
        this.taskStates[taskIndex] = taskStatus;
    }

    public synchronized Status getStatus() {
        Status status = this.lastStatus == Status.FAILED ? Status.FAILED : Status.COMPLETE;
        int i = 0;
        for (Status taskStatus : this.taskStates) {
            ++i;
            if (taskStatus.ordinal() >= status.ordinal()) continue;
            status = taskStatus;
            this.log.debug("Lowest status found: " + (Object)((Object)status) + ", task index " + i);
        }
        if (this.lastStatus == Status.FAILED) {
            this.notifyAll();
        } else if (this.lastStatus != status) {
            this.lastStatus = status;
            this.notifyAll();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStatus(Status nextStatus) {
        if (nextStatus == Status.FAILED) {
            this.log.debug("Updating status - parsing failed");
        }
        this.lastStatus = nextStatus;
        this.notifyAll();
        MAGETABInvestigation mAGETABInvestigation = this.investigation;
        synchronized (mAGETABInvestigation) {
            this.log.debug("Notifying any threads waiting on investigation following change in status");
            this.investigation.notifyAll();
        }
    }

    public synchronized void storeNode(SDRFNode node) {
        ArrayList nodes;
        if (!this.nodeStoreByClass.containsKey(node.getClass())) {
            nodes = new ArrayList();
            this.nodeStoreByClass.put(node.getClass(), nodes);
        }
        this.nodeStoreByClass.get(node.getClass()).add(node);
        if (!this.nodeStoreByTag.containsKey(node.getNodeType())) {
            nodes = new ArrayList();
            this.nodeStoreByTag.put(node.getNodeType(), nodes);
        }
        this.nodeStoreByTag.get(node.getNodeType()).add(node);
    }

    public synchronized boolean hasBeenHandled(String nodeName, Class<? extends SDRFNode> nodeType) {
        return this.lookupNode(nodeName, nodeType) != null;
    }

    public synchronized <T extends SDRFNode> T lookupNode(String nodeName, Class<T> nodeType) {
        if (this.nodeStoreByClass.containsKey(nodeType)) {
            List<SDRFNode> nodes = this.nodeStoreByClass.get(nodeType);
            for (SDRFNode node : nodes) {
                if (!node.getNodeName().equals(nodeName)) continue;
                return (T)node;
            }
        }
        return null;
    }

    public synchronized SDRFNode lookupNode(String nodeName, String nodeType) {
        if (this.nodeStoreByTag.containsKey(nodeType)) {
            List<SDRFNode> nodes = this.nodeStoreByTag.get(nodeType);
            for (SDRFNode node : nodes) {
                if (!node.getNodeName().equals(nodeName)) continue;
                return node;
            }
        }
        return null;
    }

    public synchronized <T extends SDRFNode> List<T> lookupNodes(Class<T> nodeType) {
        if (this.nodeStoreByClass.containsKey(nodeType)) {
            return this.nodeStoreByClass.get(nodeType);
        }
        return new ArrayList();
    }

    public synchronized List<? extends SDRFNode> lookupNodes(String nodeType) {
        if (this.nodeStoreByTag.containsKey(nodeType)) {
            return this.nodeStoreByTag.get(nodeType);
        }
        return new ArrayList();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (SourceNode s : this.sourceNodes) {
            sb.append("\n").append(s.toString());
            sb.append(this.childrenToString(s, 0));
        }
        return sb.toString();
    }

    private String childrenToString(SDRFNode node, int indent) {
        StringBuffer sb = new StringBuffer();
        ++indent;
        for (String s : node.getChildNodeValues()) {
            SDRFNode childNode = this.lookupNode(s, node.getChildNodeType());
            if (childNode == null) continue;
            sb.append("\n");
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append(childNode.toString()).append("\t");
            sb.append(this.childrenToString(childNode, indent));
        }
        return sb.toString();
    }
}

