/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.datamodel;

import uk.ac.ebi.arrayexpress2.magetab.datamodel.IDF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.SDRF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;

public class MAGETABInvestigation {
    public volatile String accession;
    public final IDF IDF;
    public final SDRF SDRF;
    private double complete = -1.0;
    private Status status = Status.READY;
    private static final Object PROGRESS_LOCK = new Object();

    public MAGETABInvestigation() {
        this.IDF = new IDF(this);
        this.SDRF = new SDRF(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgress() {
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            return (int)Math.rint(this.complete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        Status status = Status.COMPLETE;
        if (this.IDF.getStatus().ordinal() < status.ordinal()) {
            status = this.IDF.getStatus();
        }
        if (this.SDRF.getStatus().ordinal() < status.ordinal()) {
            status = this.SDRF.getStatus();
        }
        MAGETABInvestigation mAGETABInvestigation = this;
        synchronized (mAGETABInvestigation) {
            if (this.status != status) {
                this.status = status;
                this.notifyAll();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseTotalProgressBy(double increase) {
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            if (this.complete == -1.0) {
                this.complete = 0.0;
            }
            this.complete += increase;
            MAGETABInvestigation mAGETABInvestigation = this;
            synchronized (mAGETABInvestigation) {
                this.notifyAll();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" IDF: \n\n");
        sb.append(this.IDF.toString());
        sb.append("\n\n");
        sb.append(" SDRF: \n\n");
        sb.append(this.SDRF.toString());
        sb.append("\n\n");
        return sb.toString();
    }
}

