/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.arrayexpress2.magetab.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDF {
    public volatile String investigationTitle = "";
    public volatile List<String> experimentalDesign = new ArrayList<String>();
    public volatile List<String> experimentalDesignTermSourceREF = new ArrayList<String>();
    public volatile List<String> experimentalFactorName = new ArrayList<String>();
    public volatile List<String> experimentalFactorType = new ArrayList<String>();
    public volatile List<String> experimentalFactorTermSourceREF = new ArrayList<String>();
    public volatile List<String> personLastName = new ArrayList<String>();
    public volatile List<String> personFirstName = new ArrayList<String>();
    public volatile List<String> personMidInitials = new ArrayList<String>();
    public volatile List<String> personEmail = new ArrayList<String>();
    public volatile List<String> personPhone = new ArrayList<String>();
    public volatile List<String> personFax = new ArrayList<String>();
    public volatile List<String> personAddress = new ArrayList<String>();
    public volatile List<String> personAffiliation = new ArrayList<String>();
    public volatile List<String> personRoles = new ArrayList<String>();
    public volatile List<String> personRolesTermSourceREF = new ArrayList<String>();
    public volatile List<String> qualityControlType = new ArrayList<String>();
    public volatile List<String> qualityControlTermSourceREF = new ArrayList<String>();
    public volatile List<String> replicateType = new ArrayList<String>();
    public volatile List<String> replicateTermSourceREF = new ArrayList<String>();
    public volatile List<String> normalizationType = new ArrayList<String>();
    public volatile List<String> normalizationTermSourceREF = new ArrayList<String>();
    public volatile String dateOfExperiment = "";
    public volatile String publicReleaseDate = "";
    public volatile List<String> pubMedId = new ArrayList<String>();
    public volatile List<String> publicationDOI = new ArrayList<String>();
    public volatile List<String> publicationAuthorList = new ArrayList<String>();
    public volatile List<String> publicationTitle = new ArrayList<String>();
    public volatile List<String> publicationStatus = new ArrayList<String>();
    public volatile List<String> publicationStatusTermSourceREF = new ArrayList<String>();
    public volatile String experimentDescription = "";
    public volatile List<String> protocolName = new ArrayList<String>();
    public volatile List<String> protocolType = new ArrayList<String>();
    public volatile List<String> protocolDescription = new ArrayList<String>();
    public volatile List<String> protocolParameters = new ArrayList<String>();
    public volatile List<String> protocolHardware = new ArrayList<String>();
    public volatile List<String> protocolSoftware = new ArrayList<String>();
    public volatile List<String> protocolContact = new ArrayList<String>();
    public volatile List<String> protocolTermSourceREF = new ArrayList<String>();
    public volatile List<String> sdrfFile = new ArrayList<String>();
    public volatile List<String> termSourceName = new ArrayList<String>();
    public volatile List<String> termSourceFile = new ArrayList<String>();
    public volatile List<String> termSourceVersion = new ArrayList<String>();
    private volatile Map<String, Set<String>> comments = new HashMap<String, Set<String>>();
    private final MAGETABInvestigation investigation;
    private double complete = 0.0;
    private Status[] taskStates;
    private Status lastStatus = Status.READY;
    private static final Object PROGRESS_LOCK = new Object();
    protected Log log = LogFactory.getLog(this.getClass());

    public IDF(MAGETABInvestigation investigation) {
        this.investigation = investigation;
        this.taskStates = new Status[]{Status.READY};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgress() {
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            return (int)Math.rint(this.complete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseProgressBy(double increase) {
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            this.complete += increase;
            this.investigation.increaseTotalProgressBy(increase / 2.0);
            IDF iDF = this;
            synchronized (iDF) {
                this.notifyAll();
            }
        }
    }

    public synchronized void setNumberOfTasks(int totalTasks) {
        this.taskStates = new Status[totalTasks];
        for (int i = 0; i < totalTasks; ++i) {
            this.taskStates[i] = Status.READY;
        }
    }

    public synchronized void updateTaskList(int taskIndex, Status taskStatus) {
        this.taskStates[taskIndex] = taskStatus;
    }

    public synchronized Status getStatus() {
        Status status = this.lastStatus == Status.FAILED ? Status.FAILED : Status.COMPLETE;
        int i = 0;
        for (Status taskStatus : this.taskStates) {
            ++i;
            if (taskStatus.ordinal() >= status.ordinal()) continue;
            status = taskStatus;
            this.log.debug("Lowest status found: " + (Object)((Object)status) + ", task index " + i);
        }
        if (this.lastStatus == Status.FAILED) {
            this.notifyAll();
        } else if (this.lastStatus != status) {
            this.lastStatus = status;
            this.notifyAll();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStatus(Status nextStatus) {
        if (nextStatus == Status.FAILED) {
            this.log.debug("Updating status - parsing failed");
        }
        this.lastStatus = nextStatus;
        this.notifyAll();
        MAGETABInvestigation mAGETABInvestigation = this.investigation;
        synchronized (mAGETABInvestigation) {
            this.log.debug("Notifying any threads waiting on investigation following change in status");
            this.investigation.notifyAll();
        }
    }

    public synchronized void addComment(String type, String comment) {
        if (!this.comments.containsKey(type)) {
            this.comments.put(type, new HashSet());
        }
        this.comments.get(type).add(comment);
    }

    public synchronized Map<String, Set<String>> getComments() {
        return this.comments;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Investigation Title\t").append(this.investigationTitle).append("\n");
        sb.append("Experimental Design\t");
        for (String s : this.experimentalDesign) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Experimental Factor Name\t");
        for (String s : this.experimentalFactorName) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Experimental Factor Type\t");
        for (String s : this.experimentalFactorType) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Experimental Factor Term Source REF\t");
        for (String s : this.experimentalFactorTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Last Name\t");
        for (String s : this.personLastName) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person First Name\t");
        for (String s : this.personFirstName) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Mid Initials\t");
        for (String s : this.personMidInitials) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Email\t");
        for (String s : this.personEmail) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Phone\t");
        for (String s : this.personPhone) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Fax\t");
        for (String s : this.personFax) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Address\t");
        for (String s : this.personAddress) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Affiliation\t");
        for (String s : this.personAffiliation) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Roles\t");
        for (String s : this.personRoles) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Person Roles Term Source REF\t");
        for (String s : this.personRolesTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Quality Control Type\t");
        for (String s : this.qualityControlType) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Quality Control Term Source REF\t");
        for (String s : this.qualityControlTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Replicate Type\t");
        for (String s : this.replicateType) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Replicate Type Term Source REF\t");
        for (String s : this.replicateTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Normalization Type\t");
        for (String s : this.normalizationType) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Normalization Term Source REF\t");
        for (String s : this.normalizationTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Date of Experiment\t").append(this.dateOfExperiment);
        sb.append("\n");
        sb.append("Public Release Date\t").append(this.publicReleaseDate);
        sb.append("\n");
        sb.append("PubMed ID\t");
        for (String s : this.pubMedId) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Publication DOI\t");
        for (String s : this.publicationDOI) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Publication Author List\t");
        for (String s : this.publicationAuthorList) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Publication Title\t");
        for (String s : this.publicationTitle) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Publication Status\t");
        for (String s : this.publicationStatus) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Publication Status Term Source REF\t");
        for (String s : this.publicationStatusTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Experiment Description\t").append(this.experimentDescription);
        sb.append("\n");
        sb.append("Protocol Name\t");
        for (String s : this.protocolName) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Type\t");
        for (String s : this.protocolType) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Description\t");
        for (String s : this.protocolDescription) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Parameters\t");
        for (String s : this.protocolParameters) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Hardware\t");
        for (String s : this.protocolHardware) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Software\t");
        for (String s : this.protocolSoftware) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Contact\t");
        for (String s : this.protocolContact) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Protocol Term Source REF\t");
        for (String s : this.protocolTermSourceREF) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("SDRF File\t");
        for (String s : this.sdrfFile) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Term Source Name\t");
        for (String s : this.termSourceName) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Term Source File\t");
        for (String s : this.termSourceFile) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        sb.append("Term Source Version\t");
        for (String s : this.termSourceVersion) {
            sb.append(s).append("\t");
        }
        sb.append("\n");
        return sb.toString();
    }
}

