/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNGDecodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.PNGImageDecoder;
import com.sun.media.jai.codecimpl.PNGImageEncoder;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNGCodec
extends ImageCodec {
    static /* synthetic */ Class class$com$sun$media$jai$codec$PNGEncodeParam;
    static /* synthetic */ Class class$com$sun$media$jai$codec$PNGDecodeParam;

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 4 || n == 5) {
            return false;
        }
        int[] nArray = sampleModel.getSampleSize();
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            if (nArray[n3] != n2) {
                return false;
            }
            ++n3;
        }
        if (n2 < 1 || n2 > 16) {
            return false;
        }
        int n4 = sampleModel.getNumBands();
        if (n4 < 1 || n4 > 4) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel && (n4 != 1 || n2 > 8)) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (imageEncodeParam instanceof PNGEncodeParam) {
                if (colorModel instanceof IndexColorModel ? !(imageEncodeParam instanceof PNGEncodeParam.Palette) : (n4 < 3 ? !(imageEncodeParam instanceof PNGEncodeParam.Gray) : !(imageEncodeParam instanceof PNGEncodeParam.RGB))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)seekableStream, pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)new FileInputStream(file), pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder(inputStream, pNGDecodeParam);
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNGEncodeParam pNGEncodeParam = null;
        if (imageEncodeParam != null) {
            pNGEncodeParam = (PNGEncodeParam)imageEncodeParam;
        }
        return new PNGImageEncoder(outputStream, pNGEncodeParam);
    }

    public Class getDecodeParamClass() {
        return class$com$sun$media$jai$codec$PNGDecodeParam != null ? class$com$sun$media$jai$codec$PNGDecodeParam : (class$com$sun$media$jai$codec$PNGDecodeParam = PNGCodec.class$("com.sun.media.jai.codec.PNGDecodeParam"));
    }

    public Class getEncodeParamClass() {
        return class$com$sun$media$jai$codec$PNGEncodeParam != null ? class$com$sun$media$jai$codec$PNGEncodeParam : (class$com$sun$media$jai$codec$PNGEncodeParam = PNGCodec.class$("com.sun.media.jai.codec.PNGEncodeParam"));
    }

    public String getFormatName() {
        return "png";
    }

    public int getNumHeaderBytes() {
        return 8;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }
}

