/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.BMPCodec;
import com.sun.media.jai.codecimpl.FPXCodec;
import com.sun.media.jai.codecimpl.GIFCodec;
import com.sun.media.jai.codecimpl.JPEGCodec;
import com.sun.media.jai.codecimpl.PNGCodec;
import com.sun.media.jai.codecimpl.PNMCodec;
import com.sun.media.jai.codecimpl.TIFFCodec;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ImageCodec {
    private static Hashtable codecs = new Hashtable();
    private static final byte[][] grayIndexCmaps;
    private static final int[] GrayBits8;
    private static final ComponentColorModel colorModelGray8;
    private static final int[] GrayAlphaBits8;
    private static final ComponentColorModel colorModelGrayAlpha8;
    private static final int[] GrayBits16;
    private static final ComponentColorModel colorModelGray16;
    private static final int[] GrayAlphaBits16;
    private static final ComponentColorModel colorModelGrayAlpha16;
    private static final int[] GrayBits32;
    private static final ComponentColorModel colorModelGray32;
    private static final int[] GrayAlphaBits32;
    private static final ComponentColorModel colorModelGrayAlpha32;
    private static final int[] RGBBits8;
    private static final ComponentColorModel colorModelRGB8;
    private static final int[] RGBABits8;
    private static final ComponentColorModel colorModelRGBA8;
    private static final int[] RGBBits16;
    private static final ComponentColorModel colorModelRGB16;
    private static final int[] RGBABits16;
    private static final ComponentColorModel colorModelRGBA16;
    private static final int[] RGBBits32;
    private static final ComponentColorModel colorModelRGB32;
    private static final int[] RGBABits32;
    private static final ComponentColorModel colorModelRGBA32;

    static {
        ImageCodec.registerCodec(new BMPCodec());
        ImageCodec.registerCodec(new GIFCodec());
        ImageCodec.registerCodec(new FPXCodec());
        ImageCodec.registerCodec(new JPEGCodec());
        ImageCodec.registerCodec(new PNGCodec());
        ImageCodec.registerCodec(new PNMCodec());
        ImageCodec.registerCodec(new TIFFCodec());
        byte[][] byArrayArray = new byte[5][];
        byArrayArray[0] = null;
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 85;
        byArray2[2] = -86;
        byArray2[3] = -1;
        byArrayArray[2] = byArray2;
        byArrayArray[3] = null;
        byte[] byArray3 = new byte[16];
        byArray3[1] = 17;
        byArray3[2] = 34;
        byArray3[3] = 51;
        byArray3[4] = 68;
        byArray3[5] = 85;
        byArray3[6] = 102;
        byArray3[7] = 119;
        byArray3[8] = -120;
        byArray3[9] = -103;
        byArray3[10] = -86;
        byArray3[11] = -69;
        byArray3[12] = -52;
        byArray3[13] = -35;
        byArray3[14] = -18;
        byArray3[15] = -1;
        byArrayArray[4] = byArray3;
        grayIndexCmaps = byArrayArray;
        GrayBits8 = new int[]{8};
        colorModelGray8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits8, false, false, 1, 0);
        GrayAlphaBits8 = new int[]{8, 8};
        colorModelGrayAlpha8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits8, true, false, 3, 0);
        GrayBits16 = new int[]{16};
        colorModelGray16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits16, false, false, 1, 1);
        GrayAlphaBits16 = new int[]{16, 16};
        colorModelGrayAlpha16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits16, true, false, 3, 1);
        GrayBits32 = new int[]{32};
        colorModelGray32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits32, false, false, 1, 3);
        GrayAlphaBits32 = new int[]{32, 32};
        colorModelGrayAlpha32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits32, true, false, 3, 3);
        RGBBits8 = new int[]{8, 8, 8};
        colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits8, false, false, 1, 0);
        RGBABits8 = new int[]{8, 8, 8, 8};
        colorModelRGBA8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits8, true, false, 3, 0);
        RGBBits16 = new int[]{16, 16, 16};
        colorModelRGB16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits16, false, false, 1, 1);
        RGBABits16 = new int[]{16, 16, 16, 16};
        colorModelRGBA16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits16, true, false, 3, 1);
        RGBBits32 = new int[]{32, 32, 32};
        colorModelRGB32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits32, false, false, 1, 3);
        RGBABits32 = new int[]{32, 32, 32, 32};
        colorModelRGBA32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits32, true, false, 3, 3);
    }

    protected ImageCodec() {
    }

    public abstract boolean canEncodeImage(RenderedImage var1, ImageEncodeParam var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorModel createComponentColorModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        if (n == 0) {
            switch (n2) {
                case 1: {
                    return colorModelGray8;
                }
                case 2: {
                    return colorModelGrayAlpha8;
                }
                case 3: {
                    return colorModelRGB8;
                }
                case 4: {
                    return colorModelRGBA8;
                }
                default: {
                    return componentColorModel;
                }
            }
        }
        if (n == 1) {
            switch (n2) {
                case 1: {
                    return colorModelGray16;
                }
                case 2: {
                    return colorModelGrayAlpha16;
                }
                case 3: {
                    return colorModelRGB16;
                }
                case 4: {
                    return colorModelRGBA16;
                }
                default: {
                    return componentColorModel;
                }
            }
        }
        if (n != 3) return componentColorModel;
        switch (n2) {
            case 1: {
                componentColorModel = colorModelGray32;
                break;
            }
            case 2: {
                componentColorModel = colorModelGrayAlpha32;
                break;
            }
            case 3: {
                componentColorModel = colorModelRGB32;
                break;
            }
            case 4: {
                componentColorModel = colorModelRGBA32;
            }
        }
        return componentColorModel;
    }

    public static ColorModel createGrayIndexColorModel(SampleModel sampleModel, boolean bl) {
        byte[] byArray;
        int n;
        block7: {
            block6: {
                if (sampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException();
                }
                n = sampleModel.getSampleSize(0);
                byArray = null;
                if (n >= 8) break block6;
                byArray = grayIndexCmaps[n];
                if (bl) break block7;
                int n2 = byArray.length;
                byte[] byArray2 = new byte[n2];
                int n3 = 0;
                while (n3 < n2) {
                    byArray2[n3] = byArray[n2 - n3 - 1];
                    ++n3;
                }
                byArray = byArray2;
                break block7;
            }
            byArray = new byte[256];
            if (!bl) {
                int n4 = 0;
                while (n4 < 256) {
                    byArray[n4] = (byte)n4;
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < 256) {
                    byArray[n5] = (byte)(255 - n5);
                    ++n5;
                }
            }
        }
        return new IndexColorModel(n, byArray.length, byArray, byArray, byArray);
    }

    protected abstract ImageDecoder createImageDecoder(SeekableStream var1, ImageDecodeParam var2);

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return this.createImageDecoder(new FileSeekableStream(file), imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream, true);
        return this.createImageDecoder(seekableStream, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(seekableStream, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, File file, ImageDecodeParam imageDecodeParam) throws IOException {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(file, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(inputStream, imageDecodeParam);
    }

    protected abstract ImageEncoder createImageEncoder(OutputStream var1, ImageEncodeParam var2);

    public static ImageEncoder createImageEncoder(String string, OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageEncoder(outputStream, imageEncodeParam);
    }

    public static ImageCodec getCodec(String string) {
        return (ImageCodec)codecs.get(string.toLowerCase());
    }

    public static Enumeration getCodecs() {
        return codecs.elements();
    }

    protected abstract Class getDecodeParamClass();

    public static String[] getDecoderNames(SeekableStream seekableStream) {
        if (!seekableStream.canSeekBackwards() && !seekableStream.markSupported()) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageCodec2"));
        }
        Enumeration enumeration = codecs.elements();
        Vector<String> vector = new Vector<String>();
        Object var3_3 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            int n = imageCodec.getNumHeaderBytes();
            if (n == 0 && !seekableStream.canSeekBackwards()) continue;
            try {
                if (n > 0) {
                    seekableStream.mark(n);
                    byte[] byArray = new byte[n];
                    seekableStream.readFully(byArray);
                    seekableStream.reset();
                    if (!imageCodec.isFormatRecognized(byArray)) continue;
                    vector.add(imageCodec.getFormatName());
                    continue;
                }
                long l = seekableStream.getFilePointer();
                seekableStream.seek(0L);
                if (imageCodec.isFormatRecognized(seekableStream)) {
                    vector.add(imageCodec.getFormatName());
                }
                seekableStream.seek(l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return ImageCodec.vectorToStrings(vector);
    }

    protected abstract Class getEncodeParamClass();

    public static String[] getEncoderNames(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        Enumeration enumeration = codecs.elements();
        Vector<String> vector = new Vector<String>();
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            if (!imageCodec.canEncodeImage(renderedImage, imageEncodeParam)) continue;
            vector.add(imageCodec.getFormatName());
        }
        return ImageCodec.vectorToStrings(vector);
    }

    public abstract String getFormatName();

    public int getNumHeaderBytes() {
        return 0;
    }

    public boolean isFormatRecognized(SeekableStream seekableStream) throws IOException {
        throw new RuntimeException(JaiI18N.getString("ImageCodec1"));
    }

    public boolean isFormatRecognized(byte[] byArray) {
        throw new RuntimeException(JaiI18N.getString("ImageCodec0"));
    }

    public static void registerCodec(ImageCodec imageCodec) {
        codecs.put(imageCodec.getFormatName().toLowerCase(), imageCodec);
    }

    public static void unregisterCodec(String string) {
        codecs.remove(string.toLowerCase());
    }

    private static String[] vectorToStrings(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }
}

